/*
 Copyright (c) 2003 RIPE

 All Rights Reserved

 Permission to use, copy, modify, and distribute this software and its
 documentation for any purpose and without fee is hereby granted,
 provided that the above copyright notice appear in all copies and that
 both that copyright notice and this permission notice appear in
 supporting documentation, and that the name of the author not be
 used in advertising or publicity pertaining to distribution of the
 software without specific, written prior permission.

 THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
 AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
 DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

 $Id: log.c,v 1.21 2003/04/17 08:40:54 can Exp $
*/

#include "log.h"

GAsyncQueue *logQueue;

gboolean logQueueEmpty(void)
{
    if (g_async_queue_length(logQueue) >= 0)
        return FALSE;
    return TRUE;
}

GThreadFunc logger(gpointer data)
{
    gchar *p;
    FILE *f = stderr;
    time_t t;
    gchar bufLog[100], buf[100], *currentLog = NULL;
    struct tm lmt;
    gchar *logDir;

    logDir = (gchar *) getConf("LOGDIR");
    /* Unless logging to stderr, we longer need it */
    if (strncmp(logDir, "-", 1) != 0) {
        close(2);
        f = NULL;
    }
    currentLog = g_strdup_printf("%s/v6wpdlog.XXXXXXXXXXXX", logDir);
    while (TRUE) {
        p = g_async_queue_pop(logQueue);
        if (time(&t) == ((time_t) - 1)) {
            local_error("Error getting time: %s", strerror(errno));
        }
        localtime_r(&t, &lmt);
        strftime(buf, 80, "%Y-%m-%d %H:%M:%S", &lmt);
        strftime(bufLog, 80, "%Y%m%d", &lmt);
        g_strchomp(buf);
        g_strchomp(bufLog);
        if (f != stderr) {
            sprintf(currentLog, "%s/v6wpdlog.%s", logDir, bufLog);
            f = fopen(currentLog, "a+");
            if (f == NULL) {
                fprintf(stderr, "Can't open %s: %s", currentLog,
                        strerror(errno));
                exit(1);
            }
            setvbuf(f, NULL, _IONBF, 0);
        }
        fprintf(f, "%s %s\n", buf, p);
        fflush(f);
        if (f != stderr) {
            fclose(f);
        }
        g_free(p);
    }
}

void logHandler(const gchar * log_domain, GLogLevelFlags log_level,
                const gchar * message, gpointer user_data)
{
    gchar facMsg[200], *fac[] =
        { "RECURSION", "FATAL", "ERROR", "CRITICAL", "WARNING", "MESSAGE",
        "INFO", "DEBUG"
    };
    gint c = 0;

    facMsg[0] = 0;
    while (log_level > 0) {
        if (((log_level >> 1) << 1) != log_level) {
            if (facMsg[0] == 0)
                sprintf(facMsg, "%s", fac[c]);
            else
                sprintf(facMsg, "%s_%s", facMsg, fac[c]);
        }
        log_level = log_level >> 1;
        c++;
    }
    g_async_queue_push(logQueue,
                       g_strdup_printf("%s %s", facMsg, message));
}

void startLogging(void)
{
    char *logDomains[] = { PACKAGE, NULL };
    gint c = 0;

    g_thread_create((GThreadFunc) logger, NULL, FALSE, NULL);
    logQueue = g_async_queue_new();
    do {
        g_log_set_handler(logDomains[c],
                          G_LOG_LEVEL_DEBUG | G_LOG_LEVEL_INFO |
                          G_LOG_LEVEL_MESSAGE | G_LOG_LEVEL_WARNING |
                          G_LOG_LEVEL_CRITICAL | G_LOG_LEVEL_ERROR |
                          G_LOG_FLAG_FATAL | G_LOG_FLAG_RECURSION,
                          logHandler, NULL);
        c++;
    } while (logDomains[c] != NULL);
    g_message("Logging started");
    /* close all stdin and stdout as we no longer need them
     * stderr comes later in logger, after we're convinced of the logging
     * stream */
    close(0);
    close(1);
    /* chdir to root directory, as any good daemon should do chdir("/"); */
}
