/*
**  Copyright (c) 1991 Bolt Beranek and Newman, Inc.
**  All rights reserved.
**
**  Redistribution and use in source and binary forms are permitted
**  provided that: (1) source distributions retain this entire copyright
**  notice and comment, and (2) distributions including binaries display
**  the following acknowledgement:  ``This product includes software
**  developed by Bolt Beranek and Newman, Inc. and CREN/CSNET'' in the
**  documentation or other materials provided with the distribution and in
**  all advertising materials mentioning features or use of this software.
**  Neither the name of Bolt Beranek and Newman nor CREN/CSNET may be used
**  to endorse or promote products derived from this software without
**  specific prior written permission.
**
**  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
**  WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
**  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*/
/*
 * Copyright (c) 1992 Purdue University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Purdue University.  The name of the University may not be used
 * to endorse or promote products derived * from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Note: this copyright applies to portions of this software developed
 * at Purdue beyond the software covered by the original copyright.
 */
#include <stdio.h>
#include <signal.h>
#include <errno.h>
#include <setjmp.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sys/param.h>
#include <sys/stream.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <sys/socket.h>
#include <net/if.h>
#include "dp_str.h"
#include "dp.h"
#include "dpd.h"

static char *WHERE = "dplogin";

static time_t starttime,
	      stoptime;
static long   duration;
static char *sitename,
	    *device,
	    *tty;

void hangup();

main(argc, argv)
    int			argc;
    char		*argv[];
{
    char login[L_cuserid];
    REMOTE *rp;
    extern REMOTE *findlogin();
    char *configfile;
    char *ttyname();

    /*
     * Become root completely..
     */
    setuid(geteuid());

    /* Set defaults. */
    setprogname(argv[0][0] == '-' ? argv[0]+1 : argv[0]);
    WHERE = progname; configfile = DP_CONFIG;

    if (cuserid(login) == NULL) {
	d_log(DLOG_GENERAL, WHERE, "Can't determine login name");
	exit(1);
    }
    if ((tty = ttyname(0)) && (tty = strrchr(tty, '/')))
	tty++;
    else {
	d_log(DLOG_GENERAL, WHERE, "Can't determine login tty");
	exit(1);
    }

    /* Read configuration data. */
    if (!readconfig(configfile))
	exit(2);

    if (!(rp = findlogin(login))) {
	d_log(DLOG_GENERAL, WHERE, "Unknown login name \"%s\"", login);
	exit(3);
    }

    /*
     * Save stuff for hangup().
     */
    sitename = rp->Sitename;
    device = rp->Device;
    record_pid(rp->Device);

    /*
     * This synchronizes the dial script on the other end..
     */
    printf("PPP start\n"); 
    fflush(stdout);

    if_atimeouts(rp);

    if (start_ppp(rp, (char *)0, 38400, 1) < 0) {
	d_log(DLOG_GENERAL, WHERE, "Failed to start PPP to \"%s\"", rp->Sitename);
	exit(1);
    }

    (void)signal(SIGHUP, SIG_IGN);
    (void)signal(SIGTERM, SIG_IGN);

    d_log(DLOG_GENERAL, WHERE, "PPP started to \"%s\"", rp->Sitename);

    (void)time(&starttime);

    collect_ppp(0);

    hangup(0);
    /* NOTREACHED */
}

/*
**  Catch signal and exit.
*/
void
hangup(sig)
    int			sig;
{
    static char	WHERE[] = "hangup";
    long		totalpkts;
    long		endipkts;
    long		endopkts;

    /*
     * Now ignore the signals since we're shutting down.
     */
    (void)signal(SIGHUP, SIG_IGN);
    (void)signal(SIGTERM, SIG_IGN);
    (void)signal(SIGCHLD, SIG_IGN);
    if (sig)
	d_log(DLOG_ALL, WHERE, "Process %d got signal %d for \"%s\"",
	    getpid(), sig, device);

    unlock_pid();

    /*
     * Log the statistics
     */
    (void)time(&stoptime);
    duration = stoptime - starttime;
    writelog(sitename, tty, starttime, stoptime, duration);

#if	0
    getpacketcounts(&endipkts, &endopkts);
    totalpkts = (endipkts - startipkts) + (endopkts - startopkts);
    d_log(DLOG_INFO, WHERE, "Inbound interface \"%s\" up %ld seconds",
	device, duration);
    d_log(DLOG_DIAG, WHERE,
	"Inpackets = %ld, Outpackets = %ld, Average = %.2f packets/sec",
	endipkts - startipkts, endopkts - startopkts,
	totalpkts ? ((float)totalpkts) / ((float)duration) : 0);
#endif

    /*
     * All done, report that we made it.
     */
    d_log(DLOG_GENERAL, WHERE, "Disconnected \"%s\"", device);
    exit(0);
}
