#include "ppp48.h"

/*
   Some simple test data to verify that the implementation of the 48 bit
   CRC is operating as expected. The transmitted data is assumed to be
   0x01, 0x3f, 0x03, 0xfe. The 48 bit CRC should be 0xa0, 0xbf, 0x91, 0xbe,
   0xd9, 0x01.

   For systems using 32 bit CRCs, the first two bytes of the 48 bit CRC
   should be sent following the data:
   ie.
      0x01, 0x3f, 0x03, 0xfe, 0xa0, 0xbf

   The CRC calculated and sent by the 32 bit CRC hardware should be
   0x91, 0xbe, 0xd9, 0x01.

   Similarly, the data to be sent on a 16 bit CRC system should be:
   0x01, 0x3f, 0x03, 0xfe, 0xa0, 0xbf, 0x91, 0xbe. The CRC calculated
   and sent by the 16 bit CRC hardware should be 0xd9, 0x01.

   At least, that is what should happen according to the math...
*/

unsigned char testdata[] = {0x01, 0x3f, 0x03, 0xfe};

main()
{
	int i;
	CRC48 acc;
	unsigned char output[6];

	initCRC48(&acc);
	calcCRC48(&acc, &testdata[0], sizeof(testdata));
	getCRC48(&acc, &output[0], 6);

	printf("Test data\n");
	for (i=0; i<sizeof(testdata); i++)
	   printf("%02x ", testdata[i]);

	printf("\n\nCRC48 calculated\n");
	for (i=0; i<sizeof(output); i++)
		printf("%02x ", output[i]);
	printf("\n");

	return 0;
}
