/*
 * Copyright (C) 1987 Research Institute for Advanced Computer Science.
 * All rights reserved.  The RIACS Software Policy contains specific
 * terms and conditions on the use of this software, and must be
 * distributed with any copies.  This file may be redistributed.  This
 * copyright and notice must be preserved in all copies made of this file.
 */


/*
 * N.B.: SLMTU is now a hard limit on input packet size.
 * SLMTU must be <= CLBYTES - sizeof(struct ifnet *).
 */
#define	SLMTU		1500
#define	SLIP_HIWAT	1000	/* don't start a new packet if HIWAT on queue */
#define	CLISTRESERVE	1000	/* Can't let clists get too low */


/* flags */
#define	SC_ESCAPED	0x0001	/* saw a FRAME_ESCAPE */
#define	SC_OACTIVE	0x0002	/* output tty is active */


/* frame delimiters */
#define FRAME_END	 	0300		/* Frame End */
#define FRAME_ESCAPE		0333		/* Frame Esc */
#define TRANS_FRAME_END	 	0334		/* transposed frame end */
#define TRANS_FRAME_ESCAPE 	0335		/* transposed frame esc */


/* SLIP softc structure. */
struct sl_softc {
	dev_t	sc_dev;		/* physical device attached to */
	struct	ifnet sc_if;	/* network-visible interface */
	short	sc_flags;	/* see below */
	short	sc_ilen;	/* length of input-packet-so-far */
	struct	tty *sc_ttyp;	/* pointer to tty structure */
	struct 	mbuf *sc_mbuf;	/* pointer to head of mbuf chain */
	char	*sc_mp;		/* pointer to next available buf char */
	lock_t	softc_lock;	/* lock for softc structure */
};

#define	IFPMLEN	(MLEN - sizeof(struct ifnet *))

#ifdef KERNEL
extern int	ifqmaxlen;
struct sl_softc **sl_softc;
int sloutput(), slioctl(), ttrstrt();
struct sl_softc *dev_to_sc();
#endif
