/*
 * ------------------------------------------------------------------------
 * 
 * GateD, Release 3.5.5 
 * 
 * Copyright (c) 1996, 1997 The Regents of the University of Michigan
 * All Rights Reserved
 * 
 * License to use, copy, modify, and distribute this software and its
 * documentation can be obtained from Merit at the University of Michigan.
 * 
 * Merit GateDaemon Project
 * 4251 Plymouth Road, Suite C
 * Ann Arbor, MI 48105
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the
 * University of Michigan and Merit shall not be liable for
 * any special, indirect, incidental or consequential damages with respect
 * to any claim by Licensee or any third party arising from use of the
 * software. GateDaemon was originated and developed through release 3.0
 * by Cornell University and its collaborators.
 * 
 * Please forward bug fixes, enhancements and questions to the
 * gated mailing list: gated-people@gated.merit.edu.
 * 
 * ---------------------
 * 
 * Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 * All rights reserved.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * Royalty-free licenses to redistribute GateD Release
 * 3 in whole or in part may be obtained by writing to:
 * 
 * GateDaemon Project
 * Information Technologies/Network Resources
 * 200 CCC
 * Cornell University
 * Ithaca, NY  14853-2601  USA
 * 
 * GateD is based on Kirton's EGP, UC Berkeley's routing
 * daemon	 (routed), and DCN's HELLO routing Protocol.
 * Development of GateD has been supported in part by the
 * National Science Foundation.
 * 
 * Please forward bug fixes, enhancements and questions to the
 * gated mailing list: gated-people@gated.cornell.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 * Portions of this software may fall under the following
 * copyrights:
 * 
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms are
 * permitted provided that the above copyright notice and
 * this paragraph are duplicated in all such forms and that
 * any documentation, advertising materials, and other
 * materials related to such distribution and use
 * acknowledge that the software was developed by the
 * University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote
 * products derived from this software without specific
 * prior written permission.  THIS SOFTWARE IS PROVIDED
 * ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * This copyright has ben automaticly added by the util/addcopyright.pl program.
 * __END_OF_COPYRIGHT__
 */

/*
 *  $Id: igmp.h,v 1.1 1995/10/12 20:27:09 root Exp $
 *
 *  Author: Tom Pusateri <pusateri@netedge.com>
 */

/* %(Copyright.header) */


#ifdef	PROTO_IGMP
/*
 * Internet Group Management Protocol
 *  
 */
struct igmp {
        u_int8          igmp_type;      /* version, type info  */
        u_int8          igmp_code;      /* used in dvmrp and pim */
        u_int16         igmp_cksum;     /* checksum */
        u_int32		igmp_group;     /* group address */
};

#define IGMP_UNDEFINED		0x10	/* not defined */
#define IGMP_MEMBERSHIP_QUERY	0x11	/* version, type */
#define IGMP_MEMBERSHIP_REPORT	0x12
#define IGMP_PROTO_DVMRP	0x13
#define IGMP_PROTO_PIM		0x14
#define	IGMP_CISCO_TRACE	0x15
#define IGMP_NEW_MEMBERSHIP_REPORT	0x16
#define IGMP_MEMBERSHIP_LEAVE	0x17
#define IGMP_MTRACE_RESPONSE	0x1e
#define IGMP_MTRACE_REQUEST	0x1f
#define	IGMP_MAX_TYPE		0x20
#define	IGMP_BASE_TYPE		IGMP_UNDEFINED

#define IGMP_MIN_PACKET_LENGTH		8
#define	IGMP_MAX_HOST_REPORT_DELAY	10

#define	IGMP_ENABLED		0x01	/* IGMP protocol status bit */

extern int igmp_config_status;		/* if IGMP is enabled in new config */

#define	IGMP_ALL_HOSTS		0xe0000001	/* 224.0.0.1 */
#define	IGMP_ALL_ROUTERS	0xe0000002	/* 224.0.0.2 */

#define	IP_MAX_TTL		255
/*
 * local group database
 */

struct group_list {
    struct group_list *forw, *back;
    struct in_addr group_addr;		/* Group address */
    struct in_addr last_addr;		/* Last host to report group */
#define	IGMP_NEW_NEIGHBORS	0x1
    flag_t group_flags;			/* status info about group */
    time_t refresh_time;		/* Time of last refresh */
};

/*
 * Used to scan the local group database
 */

#define	GROUP_LIST(gp, list)	{ for (gp = (list)->forw; gp != list; gp = gp->forw)
#define GROUP_LIST_END(gp, list)	if (gp == list) gp = (struct group_list *) 0; }

/*
 * defines used by parser
 */

#define	IGMP_LIMIT_QUERYINTERVAL	1, 0xffff
#define	IGMP_LIMIT_TIMEOUTINTERVAL	1, 0xffff

#define	IGMP_CONFIG_ENABLE		1
#define	IGMP_CONFIG_DISABLE		2
#define	IGMP_CONFIG_MAX			3

extern adv_entry *igmp_int_policy;		/* IGMP control info */

#define IFPS_DR_STATUS		IFPS_KEEP1
						/* IGMP group database/intf */
#define igmp_if_group_list	ifa_ps[RTPROTO_IGMP].ips_datas[0]
#define igmp_if_timer_timeout	ifa_ps[RTPROTO_IGMP].ips_datas[1]
#define igmp_if_proto		ifa_ps[RTPROTO_IGMP].ips_datas[2]

/*
 * tracing declarations
 */

extern trace *igmp_trace_options;	/* IGMP tracing configuration */
extern const bits igmp_trace_types[];	/* List of IGMP specific trace flags */

#define	TR_IGMP_INDEX_PACKETS	0	/* All packets */
#define	TR_IGMP_INDEX_QUERY	1	/* Query packets */
#define	TR_IGMP_INDEX_REPORT	2	/* New and old Report packets */
#define	TR_IGMP_INDEX_LEAVE	3	/* Leave packets */
#define	TR_IGMP_INDEX_MTRACE	4	/* Cisco & traceroute mcast packets */

#define	TR_IGMP_DETAIL_QUERY	TR_DETAIL_1
#define	TR_IGMP_DETAIL_REPORT	TR_DETAIL_2
#define	TR_IGMP_DETAIL_LEAVE	TR_DETAIL_3
#define	TR_IGMP_DETAIL_MTRACE	TR_DETAIL_4


/*
 * protocol defaults
 */

extern int igmp_default_queryinterval;		/* default query interval */
extern int igmp_default_timeoutinterval;	/* default timeout interval */


/*
 * Group Change defines
 */

#define	IGMP_GROUP_ADDED	1
#define	IGMP_GROUP_REMOVED	2

/**/
PROTOTYPE(igmp_init,
	  extern void,
	  (void));
PROTOTYPE(igmp_var_init,
	  extern void,
	  (void));
PROTOTYPE(igmp_enable_dr_status,
	  extern void,
	  (if_addr *));
PROTOTYPE(igmp_disable_dr_status,
	  extern void,
	  (if_addr *));
PROTOTYPE(igmp_enable_mrouting,
	  extern void,
	  (void));
PROTOTYPE(igmp_disable_mrouting,
	  extern void,
	  (void));
PROTOTYPE(igmp_enable_asserts,
	  extern void,
	  (void));
PROTOTYPE(igmp_disable_asserts,
	  extern void,
	  (void));
#ifdef	KRT_IPMULTI_TTL0
PROTOTYPE(igmp_add_vif,
	  extern void,
	  (if_addr *,
	   u_int32,
	   u_int32));
PROTOTYPE(igmp_del_vif,
	  extern void,
	  (if_addr *));
PROTOTYPE(igmp_lookup_task,
	  extern task *,
	  (void));
#endif	/* KRT_IPMULTI_TTL0 */
PROTOTYPE(igmp_unregister_recv,
	  extern int,
	  (int));
PROTOTYPE(igmp_register_recv,
	  extern int,
	  (int,
	  _PROTOTYPE(func,
		     void,
		     (if_addr *,
		      struct igmp *,
		      int))));
PROTOTYPE(igmp_register_group_change,
	  extern int,
	  (_PROTOTYPE(func,
		     void,
		     (int,
		      if_addr *,
		      u_int32))));
PROTOTYPE(igmp_unregister_group_change,
	  extern int,
	  (_PROTOTYPE(func,
		     void,
		     (int,
		      if_addr *,
		      u_int32))));
PROTOTYPE(igmp_group_add,
	  extern int,
	  (if_addr *,
	   sockaddr_un *));
PROTOTYPE(igmp_group_drop,
	  extern int,
	  (if_addr *,
	   sockaddr_un *));
PROTOTYPE(igmp_send,
	  extern int,
	  (if_addr *,
	   struct ip *,
	   int,
	   sockaddr_un *,
	   int));
PROTOTYPE(igmp_get_ifproto,
	  extern int,
	  (if_addr *));
PROTOTYPE(igmp_set_ifproto,
	  extern int,
	  (if_addr *,
	   int));
PROTOTYPE(igmp_reset_ifproto,
	  extern void,
	  (if_addr *,
	   int));

#endif	/* PROTO_IGMP */


/*
 * %(Copyright)
 */
