/* 
 * $Id: idrp_prototypes.h,v 1.18 1995/11/06 16:30:08 skh Exp $
 * Merit IDRP release 1.1 (gated 3.5.4).  Copyright (c) 1994 by Merit Network, Inc. 
 */

#ifndef _idrp_prototypes_h
#define _idrp_prototypes_h

/* prototypes for routines */ 

/* initialization routines */

/* routines set-up in task.c  */

/* routines set-up in task initialization for master task */
/* see idrp_init.c for details */
/*INIT_SEQ - 	idrp_cleanup, 
 *		idrp_var_init,
 * 		parse,
 *		idrp_init,
 *		idrp_flash,
 *		idrp_newpolicy 
 *
 * tasks - idrp_recv - receives all BISPDUs from
 * 			UDP or PID or CLNP or IDRP socket
 *	- idrp_reinit - reinitialize protocol
 * 	- idrp_new_policy - reinitialize policy  
 *	- idrp_delete - delete master task of idrp protocol turned off 
 */ 

PROTOTYPE(idrp_cleanup, static void , (task *tp)); /* task cleanup on re-config */
PROTOTYPE(idrp_var_init, extern void , (void));   /* task Initialization prior to config */
PROTOTYPE(idrp_init, extern void , (void));       /* task init after config */
PROTOTYPE(idrp_find_interface, sockaddr_un *, ());	/* get a local interface for local node's peer structure */ 


PROTOTYPE(idrp_init_this_node, extern void, (void));	/* initialize master task & nodes peer structure */ 
PROTOTYPE(idrp_init_task_block_all, extern void, (void));   /* initialize all idrp task_block memory */ 

/* master task routines */

PROTOTYPE(idrp_recv, extern void, (task * tp));  /* Read data from socket */
PROTOTYPE(idrp_reinit, static void, (task *tp));  /* Protocol re-initialization */
PROTOTYPE(idrp_newpolicy, extern void, (task *tp, rt_list *rtl));  /* Protocol re-initialization */
PROTOTYPE(idrp_terminate, extern void, (task *tp)); /* idrp task terminate */
PROTOTYPE(idrp_master_dump, extern void, (task *tp, FILE *fd)); /* Dump IDRP master task state */


/* initialize local routes from IDRP - associated with master task */

PROTOTYPE(idrp_init_local_rt, void, ());
PROTOTYPE(idrp_init_local_ribs, void, ());
PROTOTYPE(idrp_reconfig_rib, void, (idrp_ann_list *p_ann_list, int rib_id));
PROTOTYPE(idrp_newpolicy_deltas, void, (idrp_ann_list *p_ann_deltas, int rib_id));

/* routines set-up in peer task initialization 
 * idrp_parse_init - routines for idrp parsing
 */

PROTOTYPE(idrp_find_peer, extern idrpPeer * , (idrpPeer *p_new_peer));	/* find a peer on the peer list */
PROTOTYPE(idrp_link_peer, void, (idrpPeer *p_peer));	/* link a new peer to the peer list */
PROTOTYPE(idrp_small_blk_alloc, extern u_char *, ()); /* allocate small task block */
PROTOTYPE(idrp_small_blk_free, extern void, (u_char *p)); /* allocate small task block */
PROTOTYPE(idrp_med_blk_alloc, extern u_char *, ()); /* allocate medium task block */
PROTOTYPE(idrp_med_blk_free, void, (u_char *p)); /* free medium task block */
PROTOTYPE(idrp_big_blk_alloc,extern u_char *, (void)); /* allocate a big block */
PROTOTYPE(idrp_big_blk_free, void, (u_char *p)); /* free big peer task block */
PROTOTYPE(idrp_huge_blk_alloc, u_char *, (void)); /* free huge peer task block */
PROTOTYPE(idrp_huge_blk_free, void, (u_char *p)); /* free huge peer task block */
PROTOTYPE(idrp_local_peer_init, extern void, ());		/* fill in local node's peer structure */ 
PROTOTYPE(idrp_local_config_def, extern void, ());	/* fill in local node's peer structure */ 
PROTOTYPE(idrp_delete, extern void, (idrpPeer *peer)); /* idrp peer structure deletion  and list relinked */
PROTOTYPE(idrp_peer_config_init, extern void, (idrpPeer *peer)); /* configuration init a peer structure */
PROTOTYPE(idrp_peer_config_reinit, extern void, (idrpPeer *peer)); /* configuration init a peer structure */
PROTOTYPE(idrp_peer_preconfig_init, extern void, (idrpPeer *peer)); /* pre-configuration init a peer structure */
PROTOTYPE(idrp_update_peer, extern void, (idrpPeer *peer_old, idrpPeer *peer)); /* update old peer from new */
PROTOTYPE(idrp_is_new_rdi, extern void, (u_char *p_str, int len)); /* update old peer from new */
PROTOTYPE(idrp_route_cleanup, extern void, ()); 	/* cleanup routes if  idrp protocol turned off  */
PROTOTYPE(idrp_rib_set,extern int, (idrpRoute_options *p_opt)); 	/* cleanup routes if  idrp protocol turned off  */

/* qos based idrp_init_ribs.c file
 */
 
PROTOTYPE(idrp_qos_rib_reconfig,extern void, ());	/* set reconfigure flags the qos ribs */
PROTOTYPE(idrp_qos_rib_cleanup,extern void, ());	/* set reconfigure flags the qos ribs */
PROTOTYPE(idrp_find_rib,extern idrp_qos_rib *,(idrp_qos_rib *p_rib)); 	/* qos ribs */   
PROTOTYPE(compare_ribs,extern int,(idrp_qos_rib *p_rib1, idrp_qos_rib *p_rib2)); 	/* qos ribs */   
PROTOTYPE(idrp_del_rib_drop_peers,extern void,(int rib_id));		/* initalize idrp_attr_list of rib  */  
PROTOTYPE(idrp_check_qos_vals,extern int,(idrp_qos_rib *p_rib)); 	/*  validate qos rib values */   
PROTOTYPE(idrp_fill_qospdu,void ,(idrp_qos_rib *p_rib));	 	/*  validate qos rib values */   
PROTOTYPE(idrp_supp_all_ribs,extern void ,(idrpPeer *peer));	 	/*  all ribs id support in peer  */   
PROTOTYPE(idrp_init_def_rib, extern void, ());				/* initialize the default rib */
PROTOTYPE(idrp_rib_cleanup, extern void, ());				/* clenaup ribs if idrp protocol turned off */
PROTOTYPE(compare_peer_ribs, extern int, (idrpPeer *peer1, idrpPeer *peer2)); 	/* qos ribs */   
PROTOTYPE(idrp_free_rib, extern void ,(idrp_qos_rib *p_rib));


/* routines to set-up the sockets for the master task 
 * file: idrp_init_sock 
 * - idrp_ip_pdi_sock_init - initialize the ip pid socket for intialization
 * - idrp_udp_sock_init - initialize the UDP socket
 * - idrp_clnp_raw_sock_init - intialize the CLNP socket
 * - idrp_idrp_sock_init - intialize the idrp socket
 * - idrp_init_local_proto_sock - set the local node's protocol socket
 *       (call one of 4 above routines)
 * - idrp_set_local_iso_intf_addr - set the iso addres in local
 *	 peer structure	 - format depends on bind!! 
 */ 

PROTOTYPE(idrp_ip_pid_sock_init, void, (task *p_task, sockaddr_un *p_addr));
PROTOTYPE(idrp_udp_sock_init, void, (task *p_task, sockaddr_un *p_addr));
PROTOTYPE(idrp_clnp_raw_sock_init, void , (task *p_task, sockaddr_un *p_addr));
PROTOTYPE(idrp_idrp_sock_init, void, (task *p_task));
PROTOTYPE(idrp_init_local_proto_sock, void, ());
PROTOTYPE(idrp_set_local_iso_intf_addr, void, ());


/* routines for socket interaction recv and transmit
 * (transmit and recieve also found in idrp_recv 
 *   idrp_post 
 * - idrp_send_clnp_pdu - send the IDRP packet via the CLNP pdu
 * - idrp_idrp_send_pdu - send IDRP packte via the CLNP in idrp socket
 * - idrp_ip_interface - is this an interface on this node 
 */

PROTOTYPE(idrp_ip_raw_sock_recv, idrpPeer *,(idrp_proto_header *pdu_proto));
PROTOTYPE(idrp_udp_sock_recv, idrpPeer *,(idrp_proto_header *pdu_proto));
PROTOTYPE(idrp_clnp_sock_recv, idrpPeer *,(idrp_proto_header *pdu_proto));
PROTOTYPE(idrp_idrp_sock_recv, idrpPeer *,(idrp_proto_header *pdu_proto,sockaddr_un *p_srcaddr, \
					sockaddr_un *p_dstaddr));
PROTOTYPE(idrp_send_clnp_pdu, void,(idrpPeer *peer_loc, idrpPeer *peer_to, u_char *p_buf, int len, sockaddr_un *where_to));
PROTOTYPE(idrp_send_idrp_pdu, void,(idrpPeer *peer_loc, idrpPeer *peer_to, u_char *p_buf, int len, sockaddr_un *where_to));
PROTOTYPE(idrp_ip_interface, int,(idrp_fixed_ip_header *p_ip));
PROTOTYPE(idrp_same_subnet, boolean,(idrp_attribute_record *p_att, idrpPeer *peer));


/* here's the peer routines
 * idrp_peer_dump - (not done)
 * idrp_peer_reinit (not done) - reinitialize for policy
 * idrp_peer_cleanup (not done) - cleanup after terminate or on re-config
 * idrp_peer_terminate - needs to be done prior to 1st release (peer down)
 *			configure peer down
 * idrp_peer_ete_init	- initialize ETE stuff in peer (reinit stuff)
 */ 
   
 
PROTOTYPE(idrp_peer_dump, extern void, (task *tp, FILE *)); /* Dump IDRP state */

PROTOTYPE(idrp_peer_reinit, static void, (task *tp)); /* reinitialize a peer */  
PROTOTYPE(idrp_peer_cleanup, extern void, (task *tp)); /* idrp cleanup on re-init */
PROTOTYPE(idrp_peer_terminate, extern void, (task *tp)); /* termination of peer task */
PROTOTYPE(idrp_peer_ete_init, extern void, (idrpPeer *peer)); /* ete variable init in a peer structure */
PROTOTYPE(idrp_peer_ete_reinit, extern void, (idrpPeer *peer)); /* ete variable init in a peer structure */
PROTOTYPE(idrp_reinit_ete_timers, extern void, (idrpPeer *peer)); /* reinit timers on working peer */
PROTOTYPE(idrp_init_peer_tasks, extern void, ()); /* init peer tasks  */


/* %% routines for iso address pretty-printing */

PROTOTYPE(iso_ptoa, extern char * , (struct iso_prefix *prefix));   /* pretty print ISO prefix */

/* comparison of 2 iso address - yes or no */

PROTOTYPE(isoaddrcmp, extern int, (struct iso_net_addr *addr1, struct iso_net_addr *addr2)); 
PROTOTYPE(isoaddr_netiso_cmp, extern int, (struct iso_addr *addr1, struct iso_net_addr *addr2)); 
	
/* compare 2 iso addresses - return <,  =, > */
	
PROTOTYPE(compare_iso_addr, extern int, (struct iso_net_addr *addr1, struct iso_net_addr *addr2)); 

/* compare iso prefixes */

PROTOTYPE(isopfxcompare, extern int, (struct iso_prefix *pfx1, struct iso_prefix *pfx2)); /* Compare two prefixes */

/* idrp.c routines */
/* %% general utility routines */

PROTOTYPE (drop_packet, int , ());
PROTOTYPE(idrp_trace, static void, (idrpPeer *peer, \
		char *comment, \
		int  send_flag, \
		idrpPdu *pdu, \
		int	length));

PROTOTYPE(log_nm_event, extern void, (idrpPeer *peer, \
		int type, \
		int value));

PROTOTYPE(free_buffer, extern void, (idrpBuffer *buf));
PROTOTYPE(set_rib_id, extern int, (idrp_distinguish_att *p_qos));
PROTOTYPE(idrp_sockdup, sockaddr_un *, (sockaddr_un * dst,  sockaddr_un *src));
PROTOTYPE(idrp_free_valid_results, void,(idrpPeer *peer,parse_results *p_res));

/* idrp_utils.c */
PROTOTYPE(bcmp_bothlens, int, (const caddr_t b1, int len1, const caddr_t b2, int len2));
PROTOTYPE(idrp_insert_canon_rdpath, idrp_canon_rdpath *,
	(idrp_canon_rdpath *p_list, idrp_canon_rdpath *p_elem));

/* %% timer routines */

PROTOTYPE(start_rexmit_timer, extern void, (idrpPeer *peer));
PROTOTYPE(kill_rexmit_timer, extern void, (idrpPeer *peer));
PROTOTYPE(start_keepalive_timer, extern void, (idrpPeer *peer));
PROTOTYPE(start_opensent_timer, static void, (idrpPeer *peer));


/* %% pdu sending routines  */

/* post idrp pdu, and enqueued pdus */

PROTOTYPE(idrp_post, static void, (idrpPeer *peer, idrpBuffer *buf)); 
PROTOTYPE(post_enqueued_pdus, void, (idrpPeer *peer));

/* send a pdu - format stuff in to pdu  */

PROTOTYPE(idrp_send_pdu, void, (idrpPeer *peer, idrpPdu *pdu, idrp_proto_header *pdu_proto, \
				u_int type, u_int length, u_int proto_len, u_int buf_len, u_int freeze_seq));

PROTOTYPE(send_open, void, (idrpPeer *peer, u_int freeze_seq));
PROTOTYPE(send_update_pdu, void, (idrpPeer *peer, idrp_send_list *p_send_list, u_int unreachable));

PROTOTYPE(idrp_send_error, extern void, (idrpPeer *peer, u_int code));  

PROTOTYPE(send_cease, extern void, (idrpPeer *peer)); /* send cease pdu */
PROTOTYPE(send_keepalive, extern void, (idrpPeer *peer)); /* send keepalive */
PROTOTYPE(pull_old_open_rexmit, void,(idrpPeer *peer));	/* process acks of old opens */

PROTOTYPE(send_refresh_pdu, void, (idrpPeer *peer, int type));	/* send Rib Refresh */
PROTOTYPE(send_rib_atts, byte *, (idrp_RIB_att *p_openribatt, idrpPeer *peer));	/* send Rib Refresh */


/* idrp_rt_peer.c routines - actions for a peer 
 */ 
   
PROTOTYPE(flush_xmit_queue, extern void, (idrpPeer *peer)); /* flush transmit queue */
PROTOTYPE(flush_rexmit_queue, extern void, (idrpPeer *peer)); /* flush transmit queue */
PROTOTYPE(path_down, static void, (idrpPeer *peer));
PROTOTYPE(free_acked_pdu, static void, (idrpPeer *peer)); 

PROTOTYPE(free_rexmit_queue, extern void,(idrpPeer *peer)); /* flush re-xmit queue */
PROTOTYPE(begin_close, extern void,(idrpPeer *peer)); /* begin close sequence */
PROTOTYPE(ack_pdu, void,(idrpPeer *peer,u_int ack, u_int credit,u_int type));		/* process acks */
PROTOTYPE(pull_old_open_rexmit, void,(idrpPeer *peer));      /* pull old ack after open rexmit  */ 

PROTOTYPE(path_up, void,(idrpPeer *peer));		/* path up BIS-BIS established */
PROTOTYPE(idrp_refresh_peer, void, (idrp_ann_list *p_ann_list,idrpPeer *peer, idrp_ann_list *p_ann[], int qos));
		/* send Rib Refresh to all connected peers */
PROTOTYPE(idrp_req_refresh, void, (idrpPeer *peer));		/* request a Rib Refresh from a Peer */ 

/* parsing routines for pdus */

PROTOTYPE(idrp_parse_open, int,(idrpPeer *peer, idrpPdu *pdu));

/* put valid_auth_data here for now - move either to idrp.c or idrp_auth.c */

PROTOTYPE(valid_auth_data, int,(u_char *p_auth_data,idrpPeer *peer));

PROTOTYPE(process_open, static void, (idrpPeer *peer, idrpPdu *pdu));

PROTOTYPE(parse_update, int,(idrpPeer *peer, idrpPdu *pdu, int length, parse_results *res, \
			sockaddr_un *p_next_hop, sockaddr_un *p_dst_intf));

PROTOTYPE(parse_update_cleanup, void,(parse_results *res,idrpPeer *peer));
PROTOTYPE(parse_update_cleanup_reuse, void,(parse_results *res,idrpPeer *peer));
PROTOTYPE(parse_update_cleanup_free, int, (parse_results   *p_res, idrpPeer        *peer, int free));


PROTOTYPE(process_update, static void, (idrpPeer *peer, idrpPdu *pdu, int length, sockaddr_un *p_next_hop,sockaddr_un *p_dst_intf));

PROTOTYPE(process_keepalive, static void, (idrpPeer *peer,idrpPdu *pdu, int length));

PROTOTYPE(process_error, static void, (idrpPeer *peer,idrpPdu *pdu));

PROTOTYPE(process_cease, static void, (idrpPeer *peer,idrpPdu *pdu,int length));

PROTOTYPE(parse_rib_refresh, u_int,(idrpPeer *peer, \
				   idrpPdu  *pdu));

PROTOTYPE(process_rib_refresh, static void, (idrpPeer *peer, \
				    idrpPdu  *pdu, \
				    int      length));

PROTOTYPE(process_header_error, static void, (idrpPeer *peer,idrpPdu *pdu,int length));

PROTOTYPE(process_rcv_seq, static void, (idrpPeer *peer, idrpPdu *pdu));
PROTOTYPE(process_rcv_seq_open, void, (idrpPeer *peer, idrpPdu *pdu));

PROTOTYPE(in_sequence, static int,(idrpPeer *peer, u_int seq));
PROTOTYPE(in_seq_range, static int,(idrpPeer *peer, u_int seq));
PROTOTYPE(idrp_recv_pdu, static void,(idrpPeer *peer, \
				     idrpPdu *pdu, \
				     int length, \
			 	     sockaddr_un *p_next_hop, \
			 	     sockaddr_un *p_dst_intf));

PROTOTYPE(idrp_recv, extern void,(task *tp));

PROTOTYPE(parse_rib_att, byte * ,(idrp_RIB_att *p_open_rib_att, u_int rib_count, idrpPeer *peer));

/* %% idrp events */
/* task timer events - also idrp state machine events */

PROTOTYPE(idrp_start_event, extern void, (idrpPeer *peer)); 	/* start this peer */
PROTOTYPE(idrp_stop_event, extern void, (idrpPeer *peer));	/* stop this peer */
PROTOTYPE(idrp_event_closetimer, extern void, (task_timer *tip, time_t interval ));  /* Connect timer fired */
PROTOTYPE(idrp_event_holdtimetimer, extern void, (task_timer *tip, time_t interval ));/* Abort timer fired */

/* task timer events - not idrp state machine events */
PROTOTYPE(idrp_event_keepalivetimer, extern void, (task_timer *tip, time_t interval ));/* KeepAlive Timer */
PROTOTYPE(idrp_event_rexmittimer, extern void, (task_timer *tip, time_t interval ));  /* Retransmission Timer */
PROTOTYPE(idrp_event_starttimer, extern void, (task_timer *tip, time_t interval ));   /* Startup Timer */
PROTOTYPE(idrp_event_opensenttimer, extern void, (task_timer *tip, time_t interval )); /* open sent timer */
PROTOTYPE(idrp_event_closestaytimer, extern void, (task_timer *tip, time_t interval ));/* stay in closed timer */

/* %% pdu parsing routines */

PROTOTYPE(checksum_ok, int,(idrpPeer *peer, \
			   idrpPdu *pdu, \
			   int length));

PROTOTYPE(valid_header, int,(idrpPeer *peer, idrpPdu *pdu, int length));  /* validate header */

/* md4 checksum pdu */ 

/* %% validate attributes in attribute record */

PROTOTYPE(valid_attr, int,(idrpPeer *peer, \
			  idrp_attribute_record *att_rec));
PROTOTYPE(valid_dist_attr, int,(idrpPeer *peer, \
			  idrp_attribute_record *p_att));

PROTOTYPE(valid_usr_attr, int,(idrpPeer *peer, \
			  idrp_attribute_record *p_att));

/* rd pathwy checks */
 
PROTOTYPE(valid_seg_type, int,(int type, flag_t *p_flag));  /* validate path segment type */
PROTOTYPE(valid_rd_path, int,(idrpPeer *peer, \
			     idrp_attribute_record *att_rec, \
			     u_char *p_rdpath, \
			     int    rdpath_length));  /* validate rd path by linking to cannon list */


/* compare attributes - 1 if match, 0 if don't */
 
PROTOTYPE(compare_atts, boolean,(idrp_attribute_record *p_att1, idrp_attribute_record *p_att2));
PROTOTYPE(find_attr_ann_list, idrp_ann_list *, (idrp_ann_list *p_ann_list, idrp_attribute_record *attr));
PROTOTYPE(find_attr_rec, idrp_attribute_record *, (idrp_attribute_record *attr));
PROTOTYPE(idrp_dif_path, extern int, (idrp_attribute_record *p_att1,idrp_attribute_record *p_att2));
PROTOTYPE(idrp_free_attr_block, extern void, (idrpPeer *peer, idrp_attribute_record *attr));
PROTOTYPE(ATTS_REC_ZERO, void,(idrp_attribute_record *p_atts));
PROTOTYPE(idrp_free_routeid_chain_id, void,(idrp_attribute_record *p_att, int id, idrpPeer *Peer)); 
PROTOTYPE(idrp_free_routeid_chain_entry, int,(idrp_attribute_record *p_att, idrpRoute_entry *p_rte_ent, idrpPeer *Peer)); 
PROTOTYPE(idrp_free_routeid_chain, int,(idrp_attribute_record *p_att)); 
PROTOTYPE(idrp_find_routeid_chain, idrpRoute_entry *,(idrpRoute *p_rt,idrpRoute_entry **p_rte_last));
PROTOTYPE(idrp_create_routeid_chain_ent, idrpRoute_entry *,(idrpRoute *p_rt));
PROTOTYPE(idrp_free_nlri_att_rec, extern void, (idrpRoute *p_rt, int link));
PROTOTYPE(idrp_free_attr_rec, extern void,(idrpPeer *peer, idrp_attribute_record *p_att,int id,int relink));
PROTOTYPE(idrp_free_opts, void, (idrpRoute_options *p_opts));
PROTOTYPE(idrp_free_snpa_list, void, (snpa_list *p_snpa_list));
PROTOTYPE(idrp_path_dump, void,(idrp_canon_rdpath *p_rdl,idrpPeer *peer));
PROTOTYPE(relink_free_att, void,(idrp_attribute_record *p_atts));
PROTOTYPE(link_att_list, void,(idrp_attribute_record *p_atts));
PROTOTYPE(idrp_free_nlri_chain, int,(idrpRoute_entry *p_rte));
PROTOTYPE(idrp_dist_list_check, int,(idrp_attribute_record *p_att,int type, idrpPeer *peer));
PROTOTYPE(free_dist_list, void,(idrp_canon_rdpath *p_rdlist));
PROTOTYPE(find_rdi_rdilist, int,(struct iso_net_addr *p_rdi,idrp_canon_rdpath *p_list));
PROTOTYPE(idrp_wellknown_type, int, (int attr_type, idrpPeer *peer, idrp_path_attr *p_attrs));
PROTOTYPE(idrp_transitive_att, int, (idrp_path_attr *p_attrs, u_char *cp, int attr_len, \
				 int attr_type, idrp_attribute_record *p_att));
 
PROTOTYPE(wellknown_attrib_twice, int, (int attr_type, idrp_path_attr *p_attrs, \
				 parse_results *p_res, idrpPeer *peer, idrp_attribute_record *p_att, \
				  int attr_len));

PROTOTYPE(idrp_copy_nondist_att, void, (idrp_attribute_record *p_att, parse_results *p_res));
PROTOTYPE(send_next_hop, int,(idrp_attribute_record *p_att, idrpPeer *peer,idrp_attribute_entry *p_oatt_nexthop));
PROTOTYPE(idrp_parse_next_hop,int,(u_char *dataptr, int attr_len,idrp_attribute_record *p_att));
PROTOTYPE(fill_multi_exit,int, (idrp_attribute_record *p_atts, idrpPeer *peer, idrp_attr_data_entry *p_xmit));
PROTOTYPE(send_multi_exit,boolean, (idrp_attribute_record *p_att, idrpPeer *peer, idrp_attr_data_entry *p_xmit));
PROTOTYPE(idrp_copy_opts, void, (idrpRoute_options *p_opt1, idrpRoute_options *p_opt2,int rib_id));


/* %% - idrp_attr_rec - routines to handle attribute record
 * -idrp_free_canon_rdpath - free the canonical rdi path list
 * -idrp_canon_my_rdi_path - make canonical path from rdi list
 * -idrp_my_rdi_rdpath - is this pathway only my rdi (returns true/false)
 * -idrp_dump_rdi_path - dump the canonical rdi path in pretty print
 * - add_new_route_id_chain - add new route_id_list entry to chain
 * - idrp_free tran - free transitive attribute_entry_list 
 */
 
PROTOTYPE(idrp_free_canon_rdpath, void, (idrp_canon_rdpath *p_can_list));
PROTOTYPE(idrp_canon_my_rdi_path, extern int, (idrp_attribute_record *p_att));
PROTOTYPE(idrp_my_rdi_rdpath, int, (idrp_attribute_record *p_att));
PROTOTYPE(idrp_dump_rdi_path, void, (idrp_canon_rdpath *p_rdl,idrpPeer *peer));
PROTOTYPE(add_new_routeid_chain, int,(idrpRoute_entry *p_rte,idrp_attribute_record *p_att));
PROTOTYPE(add_nlri_routeid_chain, int,(idrpRoute_entry *p_rte,idrpRoute *p_idrp_rt));
PROTOTYPE(idrp_free_trans, void, (idrp_attribute_entry_list *p_trans_list));
PROTOTYPE(idrp_free_attr_list, void, (idrp_attribute_record *p_att_list));
PROTOTYPE(idrp_free_oatt_list, void, (idrp_att_list *p_oatt_list));


/* rdpath list information 
 * - 
 * - idrp_free_canon_rdpath
 - idrp_canon_my_rdi_path
 * - idrp_my_rdi_rdpath
 * - link_rd_canon
 * - link_rd_list
 * - add_local_rd_to_path   
 */
 

PROTOTYPE(link_rd_canon, int, (idrp_canon_rdpath *p_rd_new,idrp_attribute_record *p_att));
PROTOTYPE(link_rd_list, int, (idrp_canon_rdpath *p_rd_new,idrp_canon_rdpath **p_rd_list));
PROTOTYPE(add_local_rd_to_path, int,(idrpPeer *peer, idrp_attribute_record *attr_rec));

/* protocol to family transfer routines -
 * can these be done in macros ?? 
*/

PROTOTYPE(proto_to_nlri_id, extern u_int, (char *type, int len, u_char *proto));
PROTOTYPE(proto_to_socktype, extern u_int, (char *type, int len, u_char *proto));
PROTOTYPE(family_to_nlri_id, u_int, (int	family));

/* %% rib refresh routines */


PROTOTYPE(rib_refresh_pdu_release, void,(idrpPeer *peer)); /* refresh aborted, release pdus */ 
							  /* %% check for parse results release */
PROTOTYPE(refresh_pdu_link, void,(idrpPeer *peer, parse_results *results, idrpPdu *pdu));

PROTOTYPE(rib_refresh_update_process, void,(idrpPeer *peer));  /* process all updates for Rib refresh */
PROTOTYPE(refresh_free_pdu_results, void,(idrpRefresh *p_ref,idrpPeer *peer));


PROTOTYPE(idrp_sm, extern int,(idrpPeer *peer, int event));

PROTOTYPE(idrp_send_dest_set, sockaddr_un *,(idrpPeer *peer));	/* set send destination sockaddr_un */
 
PROTOTYPE(my_bis_peer, int,(gw_entry *gw));	/* Is it my bis peer */ 


PROTOTYPE(md4, u_char *, (u_char *, u_int, u_char *));	/* md4 master routine */
							/* rest of code in md4.c */ 


/* idrp_init.c */

/* iso utilities */

PROTOTYPE(isopfxcompare, extern int, (struct iso_prefix *pfx1, struct iso_prefix *pfx2)); /* Compare two prefixes */



/* %%% idrp_rt_util.c routines  */
/* %% hash routines      */

PROTOTYPE(idrp_rid_hash_get, extern idrp_rid_hash *,(idrpPeer *peer,u_int id));	/* get hash table entry */
PROTOTYPE(idrp_add_hash_entry, extern idrp_rid_hash *, (idrpPeer *peer, u_int id, idrpRoute *p_route[])); /* add entry */ 
PROTOTYPE(idrp_free_hash_entry, extern void, (idrpPeer *peer,u_int id));  /* free hash table entry */
PROTOTYPE(idrp_release_hash_tbl, extern void, (idrpPeer *peer));	 /* free memory from peer hash table */

PROTOTYPE(idrp_init_hash_tbl, extern void, (idrpPeer *peer));	 /* re-initialize memory from peer hash table */

PROTOTYPE(idrp_reinit_hash_tbl, extern void, (idrpPeer *peer));	 /* reinit memory from peer hash table */

/* %% idrpRoute structure release routines */

PROTOTYPE(idrp_alloc_idrpRoute, extern idrpRoute *, (idrpPeer *peer, idrp_attribute_record * attr_rec, int family, \
							int route_id_in));
/* Allocate route block */

PROTOTYPE(idrp_free_idrpRoute, void, (idrpRoute *p_rt));

PROTOTYPE(idrp_free_idrpRoute_entry, void, (idrpRoute_entry *p_ent, idrp_attribute_record *p_att));

PROTOTYPE(free_idrpRoute_ent,  idrpRoute_entry *, (int id, idrpPeer *peer, idrpRoute_entry *p_rt_list));	
/* free entry of idrpRoute list */

PROTOTYPE(circular_free_idrpRoute, idrpRoute_entry *, (int id, idrpRoute_entry *p_rt_list));

PROTOTYPE(idrp_add_idrpRoute_entry, idrpRoute_entry *, (u_int id, idrpRoute_entry *p_rtl));
PROTOTYPE(idrp_free_outlist, void, (idrpRoute *p_idrp_rt)); 
PROTOTYPE(idrp_rem_relink_outlist, void, (idrpRoute *p_idrp_rt, int peer_id)); 
PROTOTYPE(idrp_relink_repl_outlist, void, (idrpRoute *p_idrp_rt, idrpRoute *p_idrp_rt_old)); 
PROTOTYPE(idrp_any_rt_anns, boolean, (idrpRoute *p_idrp_rt));
PROTOTYPE(idrp_route_opt_free, void, (idrpRoute_options *p_opt));
PROTOTYPE(idrp_copy_routelist, void, (idrp_attribute_record *p_att, parse_results *res));
PROTOTYPE(idrp_route_opt_free, void, (idrpRoute_options *p_opt));


/* global rdi path and global rdi routines 
 */
 
PROTOTYPE(idrp_insert_global_rdi, rdi *, (rdi **pp_rdi));
PROTOTYPE(idrp_free_global_rdi, void, (rdi *p_rdi));
PROTOTYPE(idrp_find_global_rdi, rdi *,(int rdi_len, byte *p_rdi_str)); 
PROTOTYPE(idrp_global_rdi_order, void,());
PROTOTYPE(idrp_link_rdpath, boolean, (flag_t segtype, rdi *p_rid, idrp_attribute_record *p_att)); 
PROTOTYPE(idrp_create_rdpath_list, rdpath_list *, (flag_t segtype, rdi *p_rdi));
PROTOTYPE(idrp_add_to_rdpath, boolean, (flag_t segtype, rdi *p_rdi, rdpath_list *p_rdpath)); 
PROTOTYPE(idrp_free_rdpath, void, (rdpath_list *p_rdpath)); 
PROTOTYPE(idrp_free_rdpath_list, void, (rdpath_list *p_rdpath)); 
PROTOTYPE(idrp_insert_global_rdpaths, rdpath_list *, (rdpath_list *p_rdpath)); 
PROTOTYPE(find_rdpath_list, rdpath_list *, (idrp_rdpath_hash *p_hash, rdpath_list *p_rd_pathl));
PROTOTYPE(find_rdpath_hash_entry, idrp_rdpath_hash *, (rdi *p_rdi));
PROTOTYPE(idrp_free_rdpath_hash_entry, void, (rdpath_list *p_rdpathl));
PROTOTYPE(compare_rdi, int, (rdi * p_rdi1, rdi *p_rdi2));

/* rdi lists and distribution list handling
 */
 
PROTOTYPE(exclude_global_rdilist,void,(idrp_canon_rdpath *p_found,idrp_canon_rdpath **p_rdi_list)); 
PROTOTYPE(copy_canon_rdi_list,idrp_canon_rdpath *,(idrp_canon_rdpath *p_rdi_list)); 
PROTOTYPE(idrp_add_end_rdilist,idrp_canon_rdpath *,(rdi *p_rdi,idrp_canon_rdpath *p_rdi_list)); 
PROTOTYPE(find_global_rdi_rdilist,idrp_canon_rdpath *,(rdi *p_rdi,idrp_canon_rdpath *p_rdi_list)); 
PROTOTYPE(same_dist_list, boolean, (idrp_canon_rdpath *p_dist1, idrp_canon_rdpath *p_dist2)); 



/* %% dump routines for now/
 * 	- idrp_master_dump	- dump master task
 */
PROTOTYPE(idrp_peer_dump, void,(task *tp,  FILE *fd));	/* dump peer task */
PROTOTYPE(idrp_dump_peer_mib, extern void, (FILE *fd, idrpPeer *peer));
PROTOTYPE(idrp_dump_peer_local_mib, extern void, (FILE *fd));
PROTOTYPE(idrp_dump_peer_extra, extern void, (FILE *fd, idrpPeer *peer));
PROTOTYPE(idrp_dump_attr_list, extern void, (FILE *fd, idrpPeer *peer,int rib1, int rib2));
PROTOTYPE(idrp_dump_attr_entry, extern void, (FILE *fd, idrp_attribute_record *att));
PROTOTYPE(idrp_peer_rtbit_dump, extern void, (rt_head *, void_t data, char *));
PROTOTYPE(idrp_dump_local_rib, static void,(FILE *fd));
PROTOTYPE(idrp_dump_adj_rib, static void,(FILE *fd, idrpPeer *peer));
PROTOTYPE(idrp_dump_pref_list, extern void, (FILE *fd, idrpPeer *peer));
PROTOTYPE(idrp_dump_aggr_list, extern void, (FILE *fd, idrpPeer *peer));
PROTOTYPE(idrp_dump_dist_list, extern void, (FILE *fd, idrpPeer *peer));
PROTOTYPE(idrp_dump_route_mib, extern void, (FILE *fd, idrpRoute *idrp_rt));
PROTOTYPE(idrp_dump_internal_systems, extern void, (FILE *fd));
PROTOTYPE(idrp_dump_intra_is_systems, extern void, (FILE *fd));
PROTOTYPE(idrp_dump_snpa_list, extern void, (FILE *fd, snpa_list snpal));
PROTOTYPE(idrp_dump_snpa_entry, extern void, (FILE *fd, snpa_entry *snpa));
PROTOTYPE(idrp_get_byte_value, extern long, (char *data, int n));
PROTOTYPE(idrp_qos_active_dump, extern void, (FILE *fd, FILE *fdk));
PROTOTYPE(idrp_qos_attr_dump, extern void, (FILE *fd,FILE *fdk));
PROTOTYPE(idrp_local_rib_dump_only, extern void,(FILE *fd));

/* idrp_rt_peer.c - routines 
 * %% AdjRib checks
 */ 

PROTOTYPE(consistency_check, static void, (int rib_no));  /* consistency check one rib or all */
PROTOTYPE(validate_AdjRib, extern void, (int rib_no, idrpPeer *peer)); /* validate AdjRib */
PROTOTYPE(validate_allRibs, extern void, (int rib_no)); 		/* validate all AdjRib rib_no */

/* %% idrp_rt_policy routines
 * PREF - calculate preference for routine
 *  
 * %% Distribution policy routines for sending 
 * DIST - can this route be distributed to this peer
 * DIST_WITH - can this route be withdrawn from this peer
 * DIST_ATTR - modify or keep attribute record
 *
 * idrp_proto_pref -  given equal gated pref which protocol preferred 
 */
 
PROTOTYPE(idrp_proto_pref, extern int, (u_int proto_rcv, idrpPeer *peer));
PROTOTYPE(PREF, int,(idrpRoute *p_idrp_rt,int *p_idrp_pref,pref_t *p_gated_pref));
PROTOTYPE(DIST, int, (idrpRoute *p_idrp_rt, idrpPeer *peer,int type));
PROTOTYPE(DIST_WITH, int, (idrpRoute *p_idrp_rt, idrpPeer *peer,int type));
PROTOTYPE(DIST_ATTR, idrp_attribute_record *, (idrp_attribute_record *p_att, idrpPeer *peer));
PROTOTYPE(AGGR, void, (idrpPeer *peer,  idrp_ann_list *p_ann_list));
PROTOTYPE(idrp_new_route, int,(idrpRoute *p_idrp_rt));
PROTOTYPE(idrp_dist_policy_change, int, (idrpRoute *p_idrp_rt));
PROTOTYPE(idrp_route_export, int, (idrpRoute *p_idrp_rt,idrpPeer *peer));
PROTOTYPE(idrp_confed_change, int, (idrpRoute *p_idrp_rt,idrpPeer *peer,idrp_attr_data_entry *p_heir, \
		 idrp_attr_data_entry *p_rdpath, u_char **p_data,int *p_status));

PROTOTYPE(export_dist_list, int,(idrpRoute *p_idrp_rt, idrpPeer *peer, int *type));   
PROTOTYPE(confed_chk, int,(idrpRoute *p_idrp_rt, idrpPeer *peer, rdpath_list **p_rdc_opath,u_char *p_data));   
PROTOTYPE(create_rdc_rdpath, rdpath_list *, (int no_dif_rdc,rdc_check rdc_dif_proc[], \
		int path_segment_cnt, rdc_path_chk path[], rdpath_list *p_rd_opath, u_char *p_data, idrpPeer *peer));	  
PROTOTYPE(copy_rdpath_seg, rdpath_list *,(idrpPeer *peer, rdpath *p_path, rdpath_list **p_rdc_path,int type));   
PROTOTYPE(convert_rdcpath_seg, void,(idrpPeer *peer,rdc_path_chk path, rdpath_list **p_rdc_path));   
PROTOTYPE(copy_part_rdpath_seg, void,(idrpPeer *peer, rdpath *p_path, rdpath_list **p_rdc_path, \
		int type, int start_rdi, int end_rdi));   

PROTOTYPE(fill_rdc_path, void, (idrpRoute *p_idrp_rt, idrpPeer *peer, rdpath_list *p_rdc_path, \
		idrp_attr_data_entry *p_heir, idrp_attr_data_entry *p_rdpath, u_char *p_data));	

PROTOTYPE(dist_unmod, int,(idrpRoute *p_irt, idrpPeer *peer, int flash));



/* idrp_out_att -  has output attribute record information
 */
 
PROTOTYPE(create_idrp_out_att,idrp_attribute_record *,(idrpRoute *p_idrp_rt,idrpPeer *peer));
PROTOTYPE(link_out_att,void,(idrp_attribute_record *p_att));
PROTOTYPE(unlink_out_att,void,(idrp_attribute_record *p_att));
PROTOTYPE(idrp_free_outatt_list,void,());

/* %% Descision processes */
/* phase 1 */

PROTOTYPE(idrp_pref,extern void,(idrpRoute *p_idrp_rt));  /* idrp preference calculation */
PROTOTYPE(idrp_def_pref,extern void,(idrpRoute *p_idrp_rt));  /* idrp preference calculation */
PROTOTYPE(idrp_ext_info_pref, int,(rt_entry *p_rt));

PROTOTYPE(idrp_to_gated_pref, extern int, (idrpRoute *p_rt));	/* transmuting idrp preference to gated */ 

PROTOTYPE(tie_break, int, (idrpRoute *p_idrp_rt1, idrpRoute *p_idrp_rt2));   /* break the tie */
PROTOTYPE(tie_break_use_peer, int, (idrpRoute *p_idrp_rt1, idrpRoute *p_idrp_rt2));   /* break the tie */
PROTOTYPE(tie_break_use_peer_local, int, (idrpRoute *p_idrp_rt1, idrpRoute *p_idrp_rt2));   /* break the tie */

/* iso specific - phase2 comparisons */

PROTOTYPE(multi_exit_compare, int, \
		 (idrp_attribute_record *p_att1, \
		  idrp_attribute_record *p_att2));  /* multi_exit_disc */

/* %% phase3 - processing */


PROTOTYPE(idrp_flash, extern void, (task *tp, rt_list *rtl)); /* idrp flash update */
PROTOTYPE(phase3_process, extern void, (rt_list *rtl));		/* phase3_process */
PROTOTYPE(phase3_rib, void,  (idrp_ann_list *,int rib_id ));	/* rib processing for phase3 */
PROTOTYPE(idrp_phase3_dump, int,  (idrpPeer *peer, rt_list *rtl[]));	/* send phase 3 routes full dump */

PROTOTYPE(phase3_newpolicy , void, (rt_head *rth, idrp_ann_list *p_ann_list));
PROTOTYPE(ph3_newpolicy_deltas, idrp_ann_list *, (idrp_ann_list *p_ann_list));
PROTOTYPE(phase3_status_change, void,  (rt_list *rtl, idrp_ann_list *,int newpolicy));
PROTOTYPE(ph3_status_case1, void, (rt_head *rth, idrp_ann_list *p_ann_list,int newpolicy)); /* new idrp route */
PROTOTYPE(ph3_status_case2, int, (rt_head *rth, idrp_ann_list *p_ann_list,int newpolicy)); /* new ext_info route */
PROTOTYPE(ph3_status_case3, void, (rt_head *rth, idrp_ann_list *p_ann_list,int newpolicy)); /* old active idrp, new active idrp */
PROTOTYPE(ph3_status_case4, int, (rt_head *rth, idrp_ann_list *p_ann_list,int newpolicy)); /* old active ext_info -> new ext_info */
PROTOTYPE(ph3_status_case5, void, (rt_head *rth, idrp_ann_list *p_ann_list,int newpolicy)); /* old ext_info to new idrp */
PROTOTYPE(ph3_status_case6, int, (rt_head *rth, idrp_ann_list *p_ann_list,int newpolicy)); /* old idrp to new ext_info */
PROTOTYPE(ph3_status_case7, void, (rt_head *rth, idrp_ann_list *p_ann_list,int newpolicy)); /* old idrp to delete route */
PROTOTYPE(ph3_status_case8, void, (rt_head *rth, idrp_ann_list *p_ann_list,int newpolicy)); /* old ext_info to new route */

PROTOTYPE(idrp_send_phase3_routes, void, (idrp_ann_list *p_idrp_ann));
PROTOTYPE(idrp_send_ann_routes, int, (idrpPeer *peer,idrp_ann_list *p_idrp_ann, int flash));
PROTOTYPE(idrp_del_ph3_routes, void, (idrp_ann_list *p_idrp_ann));

/* phase 1 processing */
/* processing update routes routines */

PROTOTYPE(idrp_route_mod, extern int, (idrpRoute *p_idrp_rt, idrpPeer *peer, idrpRoute_link rt_chg));
PROTOTYPE(idrp_process_pdu_routes, idrp_ann_list *, (idrpPeer *peer, parse_results *res, int type)); /* process update pdu */

/* phase one processing */

PROTOTYPE(idrp_phase1_process, void,(idrp_ann_list *ann_list));  /* phase1 handing */
PROTOTYPE(phase1_internal, int,(idrp_ann_list *ann_list));	/* phase1 handling internal routes */
PROTOTYPE(phase1_external, int,(idrp_ann_list *ann_list));	/* phase1 handling external routes */
PROTOTYPE(ph1_with_int_route, void,(idrpRoute *p_idrp_rt));	/* phase1 withdraw internal route */
PROTOTYPE(ph1_with_rep_int_route, void,(idrpRoute *p_idrp_rt));  /* phase1 withdraw/replaced internal route */
PROTOTYPE(ph1_add_int_route, void,(idrpRoute *p_idrp_rt));	/* phase1 add internal route */

PROTOTYPE(ph1_with_ext_route, void,(idrpRoute *p_idrp_rt,idrp_ann_list *p_ext_ann_list));
					/* Phase 1 withdrawl of external route */

PROTOTYPE(ph1_with_rep_ext_route, void,(idrpRoute *p_idrp_rt,idrp_ann_list *p_ext_ann_list));
PROTOTYPE(ph1_add_ext_route, void,(idrpRoute *p_idrp_rt,idrp_ann_list *p_ext_ann_list));

PROTOTYPE(idrp_replace_ext, void, (idrpRoute *p_idrp_rt, rt_entry *p_rt, idrp_ann_list *p_ext_ann_list, \
					idrpRoute *p_best_rt, int pref));
  
PROTOTYPE(send_best_ext, void,(idrp_ann_list *p_ext_ann_list));
PROTOTYPE(del_routes_best_ext, void,(idrp_ann_list *p_ext_ann_list));
PROTOTYPE(idrp_parse_to_ann, idrp_ann_list * , (parse_results *res, idrpPeer *peer));


PROTOTYPE(link_rid_to_with_list, idrp_ann_list *, (idrp_ann_list *p_with_list, idrp_rid_hash *p_rid, idrpPeer *peer));

PROTOTYPE(idrp_process_rdloop, idrp_ann_list * ,(idrp_ann_list *p_with_list,idrp_ann_list *p_ann_list, idrpPeer *peer));
PROTOTYPE(find_nlri_in_with, int, (idrpRoute *p_idrp_rt, idrp_ann_list *p_with_list,int family));
PROTOTYPE(verify_extinfo_idrp_rt, int,(idrpRoute *p_idrp_rt,rt_entry *p_rt));
PROTOTYPE(ph3_create_ext_route, idrpRoute *,(rt_entry *p_rt, rt_head *rth, int pref, adv_results *p_adv_res));

/* utility routines shared by both phase 1 and phase 3 processing */

/* %% routines for general sending */

PROTOTYPE(link_ann_list_out, int , (idrpRoute *p_idrp_rt, idrp_ann_list *p_ann_list, int type)); /* link to announce list */
PROTOTYPE(link_ann_list, int , (idrpRoute *p_idrp_rt, idrp_ann_list *p_ann_list, int type)); /* link to announce list */
PROTOTYPE(unlink_ann_list, int, (idrpRoute *p_idrp_rt, idrp_ann_list *p_ann_list,
				 int type)); /* unlink from announce list */
PROTOTYPE(create_ann_list_entry, idrp_ann_list *, (idrpPeer *peer, idrp_attribute_record *p_att));
PROTOTYPE(link_ann_list_ann_list, void, (idrp_ann_list *p_ann_list, idrpPeer *peer, \
					idrp_ann_list *p_add_ann_list));

PROTOTYPE(free_ann_list, void , (idrp_ann_list *p_ann_list));
PROTOTYPE(rem_ann_ann_list_entry, void , (idrp_ann_list *p_ann_list, int nlri_fam, idrpRoute *p_irt, idrpRoute *p_irt_last));
PROTOTYPE(clean_ann_ann_list, idrp_ann_list * , (idrp_ann_list *p_ann_list));
PROTOTYPE(find_ann_list_entry, idrp_ann_list *, (idrpPeer *peer, idrp_attribute_record *p_att, \
				idrp_ann_list *p_ann_list)); 
PROTOTYPE(link_send_list, int , (idrp_send_list *p_send_list,idrp_send_list *p_send_new));
PROTOTYPE(send_with_replace, idrp_send_list *, (idrpRoute *p_idrp_rt, idrp_attribute_record *p_att_dist,  \
			idrp_send_list *p_send_list, idrpPeer *peer,int flash));
PROTOTYPE(send_with_attr, idrp_send_list *, (idrpRoute *p_idrp_rt, idrp_attribute_record *p_att_dist, \
				 idrp_send_list *p_send_list, idrpPeer *peer,int dist));
PROTOTYPE(send_update_reset_send_list, void, (idrpPeer *peer, idrp_send_list *p_send_list, idrp_send_list *p_tmp_send));

PROTOTYPE(send_nlri_attr, idrp_send_list *, (idrpRoute *p_idrp_rt, idrp_attribute_record *p_att_dist,  \
				 idrp_send_list *p_send_list, idrpPeer *peer)); 

PROTOTYPE(create_send_list, idrp_send_list *, (idrp_attribute_record *p_att_dist, idrpPeer *peer));
PROTOTYPE(free_send_list, void, (idrp_send_list *p_send_list, idrpPeer *peer)); 
PROTOTYPE(flush_att_send_list, void,(idrpPeer *peer,idrp_attribute_record *p_att_dist, \
				idrp_send_list *p_send_list));
PROTOTYPE(idrp_send_list_room, boolean, (idrp_send_list *p_list, idrp_send_list *p_new, u_int new_send_list));
PROTOTYPE(idrp_del_sent_routes, void,(idrp_ann_list *list)); /* delete routes given type */  
PROTOTYPE(best_ext_route, int,(idrpRoute	*p_idrp_rt,idrpRoute *p_best_ext)); /* give best ext of pair */ 
PROTOTYPE(remove_ann_dup, void ,(idrp_ann_list *p_with_list,idrp_ann_list *p_ann_list));
								/* remove announce duplicates */
								/* for the withdraw 10, replace 8 case */

PROTOTYPE(idrp_clean_replace_routes, extern void, (idrp_ann_list *p_ann_list));


/* - mixture of phase1 and phase3 utilites and gated utilities
 *   ( a true no-man's land of code - filled with dragons)
 * 
 *  idrp_add_route_locate - do gated checking for routes to be added to gated tables,  
 *			  - look up best ext, gateway and preference matches
 *  idrp_with_route_locate - do gated checking for routes to be withdrawn from gated tables
 */


PROTOTYPE(idrp_add_route_locate, extern int, (sockaddr_un *p_dest, \
						 idrpRoute *p_idrp_rt, \
						 idrp_rt_chain_walk *p_gate, \
						 idrp_rt_chain_walk *p_pref, \
						 idrpRoute **p_best_ext));

PROTOTYPE(idrp_with_route_locate, extern int, (sockaddr_un *dest, \
						 idrpRoute *p_idrp_rt, \
						 idrp_rt_chain_walk *p_gate, \
						 idrp_rt_chain_walk *p_pref, \
						 idrpRoute **p_best_ext));


PROTOTYPE(find_active_idrp_route, idrpRoute*, (idrpRoute *p_idrp_rt));
PROTOTYPE(isopfx_sock_mask_pair, void, (idrpRoute *p_idrp_rt, sockaddr_un **p_dest, sockaddr_un **p_mask));

/* group processing */

PROTOTYPE(idrp_rt_send_init, void, (idrpPeer *peer));	/* send all routes initially */
PROTOTYPE(idrp_peer_down, extern void, (idrpPeer *peer)); /* Process a down peer */
PROTOTYPE(idrp_peer_route_pull, extern int, (rt_entry *rt, idrp_ann_list *p_ann_list)); /* process down peer */

PROTOTYPE(idrp_rt_reinit, extern void,(idrpPeer *peer));	/* re-init peer after policy change */ 
PROTOTYPE(idrp_send_refresh_all_routes, extern void,(idrpPeer *peer));	/* send all routes for refresh */

/* generic processing routines */

/* iso sockaddr structure set from iso net address */

PROTOTYPE(idrp_iso_sockaddr_mask, extern void,(sockaddr_un *mask, int cnt)); /* create bit mask for iso address */
PROTOTYPE(idrp_set_iso_sockaddr, extern void,(struct sockaddr_iso *spt, int iso_len,u_char *iso_net_addr));

/* %%  idrp_rt_minadv.c routines -
 *     routines dealing with the Minimum Route Advertisement timer
 */ 

PROTOTYPE(idrp_minadv_annlist, idrp_ann_list *,(idrp_ann_list *p_ann,int type));   /* set minadv for all of announce list */
PROTOTYPE(idrp_add_min_route_adv, void,(idrpRoute *p_idrp_rt, idrp_ann_list *p_ann));  	/* add route to min_rte adv list */
/*PROTOTYPE(advmin_interval_calc, int,(struct timeval *tp, idrpPeer *peer,int type));*/
	/* calculate interval for rte list */ 
PROTOTYPE(idrp_set_min_route_timer, int,());				/* set min_route_adv timer */
PROTOTYPE(new_damping_queue, static void,(idrpPeer *peer));
PROTOTYPE(new_RD_damping_queue, static void,(idrpPeer *peer));
PROTOTYPE(idrp_process_minadv, extern void,(task_timer *tip, time_t interval));  /* all routes process loop */
PROTOTYPE(idrp_min_adv_rt, int, (idrpRoute *p_idrp_rt, idrp_ann_list *p_ann_list));	/* one route process handling */ 

/* process minimum advertisement for this RD */

PROTOTYPE(idrp_add_rt_min_advRD, void,(idrpRoute *p_idrp_rt, idrp_ann_list *p_ann));
PROTOTYPE(idrp_set_min_advRD_time, int,());
PROTOTYPE(idrp_process_minadvRD, extern void,(task_timer *tip, time_t interval));  /* all routes process loop */
PROTOTYPE(idrp_min_advRD_rt, int, (idrpRoute *p_idrp_rt, idrp_ann_list *p_ann_list)); /* one route process handling */ 
PROTOTYPE(idrp_set_minadv_timers, void,());				/* set min_route_adv timers */

/* process withdraws for both this RD and other RD in min adver
 */

PROTOTYPE(idrp_process_with_minadv, void, (idrpRoute *p_idrp_rt));

/* utility routines for placing queues into new routes during
 * idrp_route replacement
 */

PROTOTYPE(idrp_repl_minadv_chains, void, (idrpRoute *p_idrp_rt, idrpRoute *p_idrp_rt_old));
PROTOTYPE(repl_min_adv_head, int ,(idrpRoute *p_idrp_rt_old,idrpRoute *p_idrp_rt,int type));
PROTOTYPE(find_repl_minadv, int, (idrpRoute *p_idrp_rt, idrpRoute *p_idrp_rt_old));

#ifdef 	IDRP_QOS
/* qos related routines */
 
PROTOTYPE(qos_min_adv_rt, extern void, (idrpRoute *p_idrp_rt,idrp_ann_list *p_ann_list));
PROTOTYPE(qos_min_advRD_rt, extern void, (idrpRoute *p_idrp_rt,idrp_ann_list *p_ann_list));
#endif	/* IDRP_QOS */

PROTOTYPE(idrp_min_adv_cleanup, extern void, (idrpPeer *peer));
PROTOTYPE(min_adv_list_clean, extern int, (idrpPeer *peer,int type));
PROTOTYPE(min_adv_empty_cleanup, extern void, ());
PROTOTYPE(min_advRD_empty_cleanup, extern void, ());
PROTOTYPE(relink_min_adv_list, extern void, (idrpRoute *p_irt,int type, idrpAdvRt *p_adv, int nlri_type));
PROTOTYPE(relink_min_advRD_list, extern void, (idrpRoute *p_irt,int type, idrpAdvRt *p_adv, int nlri_type));



/* local node routes */

PROTOTYPE(idrp_minadvRD_local_init, int,(idrpRoute *p_idrp_rt,idrp_ann_list *p_ann_list));

/*  %% gated related routines 
 * 
 *  idrp_rt_change - has this idrp route really changed 
 *  free_rt_chain_walk - free idrp_rt_chain_walk structure - build in idrp_add_route_locate
 */  

PROTOTYPE(idrp_rt_change, extern int, (rt_entry *p_rt, idrpRoute *p_idrp_rt2));  /* idrp route change tested */
PROTOTYPE(free_rt_chain_walk, void,(idrp_rt_chain_walk *p_ch,idrpPeer *peer));


/* find the best external route */
 
PROTOTYPE(find_next_best, idrpRoute *, (idrpRoute *p_idrp_rt));
PROTOTYPE(find_best_ext, idrpRoute *, (rt_entry *p_rt,idrpRoute *p_idrp_rt));

/* find best external routes */


/* %% local RD routines */

PROTOTYPE(idrp_add_local_rt_gated, extern int,(idrpRoute *p_idrp_rt));
PROTOTYPE(idrp_local_rt, extern int, (u_char *p_nlri_str, int byte_cnt, int bit_cnt, \
			 int family, u_char *p_gw_str, int gw_byte_cnt, int opts,
			 idrpRoute_options *p_in_opts)); /* add a local route to rib */

PROTOTYPE(idrp_find_local_dest, idrpRoute *, (u_char *p_nlri_str, int byte_cnt, int bit_cnt, \
			 int family, u_char *p_gw_str, int gw_byte_cnt, idrpRoute_options  *p_opts)); /* add a local route to rib */
PROTOTYPE(local_gw_match, int, (idrpRoute *p_irt, u_char *p_gw_str, int byte_cnt));

PROTOTYPE(create_local_att, idrp_attribute_record *, (idrpRoute_options *p_opts, \
		sockaddr_un * p_next_hop, int local_flags,int rib_id)); /* create local attribute */
PROTOTYPE(find_local_att_rec, idrp_attribute_record *, (sockaddr_un *p_next_hop, idrpRoute_options *p_opts,int rib_id));
PROTOTYPE(idrp_fill_local_man_attrib, void, (idrp_attribute_record *p_atts));  /* fill local attribute array */ 
PROTOTYPE(idrp_fill_local_opt_attrib, void, (idrp_attribute_record *p_atts));  /* fill local attribute array */ 

PROTOTYPE(fill_next_hop, int, (idrp_attribute_record *p_atts));
PROTOTYPE(fill_DIST_LIST, int, (idrp_attribute_record *p_atts, idrp_canon_rdpath *p_rd, int type));
PROTOTYPE(fill_MULTI_EXIT, int, (idrp_attribute_record *p_atts));

#ifdef IDRP_QOS
PROTOTYPE(idrp_fill_local_qos_attrib, extern void, (idrp_attribute_record *p_atts));
#endif /* IDRP_QOS */

PROTOTYPE(create_local_rd_path, idrp_canon_rdpath *, (int len, u_char *ptr));	/* create a canonical rd path */
PROTOTYPE(idrp_create_local_gw, sockaddr_un *, (u_char *p_gw_str, int gw_byte_cnt, int family)); /* create gw struture */ 
PROTOTYPE(idrp_copy_opts_nexthop, sockaddr_un *, (idrpRoute_options *p_opts,sockaddr_un * p_next_hop)); /* create gw struture */ 

PROTOTYPE(create_local_snpa_entry, void, (snpa_list ** pp_snpa_list, int len, u_char *ptr)); /* create snpa_entry in local mem */ 

PROTOTYPE(idrp_local_route_reset, void,());	/* flag all local routes for reparsing */
PROTOTYPE(idrp_local_route_clean, int,());	/* clean up all local routes and attribute records */
PROTOTYPE(idrp_local_clear_reconfig, void, ());
PROTOTYPE(idrp_free_local_att, void , (idrp_attribute_record *p_att)); 
PROTOTYPE(free_local_att, void ,(idrp_attribute_record *p_att)); 
PROTOTYPE(idrp_flag_local_att, void, (idrp_attribute_record *p_att));
PROTOTYPE(idrp_clean_local_att, int, (idrp_attribute_record *p_att));
PROTOTYPE(free_local_attr_record, void, (idrp_attribute_record *p_att));
PROTOTYPE(clean_local_route_chain, int, (idrpRoute_entry *p_rte));

PROTOTYPE(idrp_free_local_idrpRoute_ent, void,(idrpRoute_entry *p_rte));	/* free local route entry */
PROTOTYPE(idrp_free_local_rt, void,(idrpRoute *p_idrp_rt));	/* free one local route on chain */
PROTOTYPE(idrp_free_local_route_chain, void, (idrpRoute_entry *p_idrp_rtl));	/* release nrlis associated */
										/* with local routes before task */
										/* initialization */  
PROTOTYPE(idrp_local_free_rdi_path, void, (idrp_canon_rdpath *p_rdi));	/* free local memory rdi_canon_path */
PROTOTYPE(idrp_local_mem_fit, u_char *, (int len));	/* fit memory in length */

PROTOTYPE(idrp_mem_fit_free, void, (void **pp_mem, int len)); /* free memory from attribute entry */
PROTOTYPE(rdi_canon_length, int, (idrp_canon_rdpath *p_rdi, idrp_rdi_mem *p_req)); /* memory required DIST_LIST */
PROTOTYPE(idrp_local_rdi_print, void, (idrp_canon_rdpath *p_rdi));	/* print local rdi for parsing */
PROTOTYPE(opts_compare, boolean,(idrpRoute_options *p_opt_old,idrpRoute_options *p_opts_new));
PROTOTYPE(idrp_opts_to_mask, int, (idrpRoute_options *p_opts, sockaddr_un *p_next_hop,int rib_id));
PROTOTYPE(idrp_confed_ok, int, (idrpPeer *peer,u_char *p_data));
PROTOTYPE(idrp_qos_parse, int, (idrp_attribute_record *p_att, u_char *dataptr, int attr_type,idrpPeer *peer));


/* %% ext_info routines for the attribute record (gated related) */

PROTOTYPE(find_ext_info_attr_rec, extern idrp_attribute_record *, (rt_head *p_rth, rt_entry *p_rt, \
			idrpRoute_options *p_opts,int rib_id));
PROTOTYPE(create_ext_info_attr_rec, extern idrp_attribute_record *, (rt_head *p_rth, rt_entry *p_rt));

#ifdef 	IDRP_ASPATH
PROTOTYPE(idrp_aspath_to_canon_rdpath, int, (as_path *p_as, idrp_attribute_record *p_att, \
			 idrpPeer *peer, int type, u_char *p_bgp));
PROTOTYPE(idrp_aspath_ext_info, int, (idrp_canon_rdpath *p_can_list, idrp_attribute_record *p_att, \
			 idrpPeer *peer, int size));
PROTOTYPE(idrp_aspath_bgp_xfr, int, (idrp_canon_rdpath *p_can_list, \
	idrp_attribute_record *p_att, idrpPeer *peer, int size, u_char *p_bgp));

PROTOTYPE(idrp_as_rdi_map, struct iso_net_addr *, (int as));
PROTOTYPE(idrp_bgp_within_rd, int, (idrpRoute *p_idrp_rt));
PROTOTYPE(fill_as_info, int, 
	  (idrp_canon_rdpath	*p_can_list,
	   idrp_attribute_record	*p_att,
	   idrpPeer		*peer,
	   int			size));
#endif

PROTOTYPE(idrp_ext_info_peer, idrpPeer *,(rt_entry *p_rt, idrpRoute *p_idrp_rt));


/* idrp_ribs.c routines */

#ifdef	IDRP_QOS
PROTOTYPE(rib_supported, extern int ,(idrp_distinguish_att *p_qos));
PROTOTYPE(rib_supp_mask, extern int ,(u_int mask,u_int value));
PROTOTYPE(ph3_create_qos_routes, extern void ,(rt_entry *p_rt, rt_head *p_rth, int pref, idrpRoute *p_idrp_rt));
PROTOTYPE(qos_active_status, extern void ,(idrpRoute *p_irt, int rib_id));
PROTOTYPE(qos_chg_active, idrp_ann_list * ,(int rib_id,int newpolicy));
PROTOTYPE(qos_all_active, idrp_ann_list * ,(int rib_id));
PROTOTYPE(qos_phase3_dump, extern void ,(idrpPeer *peer));
PROTOTYPE(qos_export, idrp_ann_list * ,(idrp_ann_list *p_ann, int rib_id,idrpPeer *peer,int link));
PROTOTYPE(ph3_create_qos_route, extern idrpRoute * ,(int pref, idrpRoute *p_irt, int rib_id, int family));
PROTOTYPE(idrp_qos_del_static, extern void ,(idrpRoute *p_irt, idrp_ann_list *p_ann_list));
PROTOTYPE(qos_del_active, extern int ,(idrpRoute *p_irt));
PROTOTYPE(find_next_qos_active, extern idrpRoute *,(idrpRoute *p_irt));

/* idrp_rt_ribs.c routines */

PROTOTYPE(ph3_qos_case1, void, (idrpRoute *p_idrp_rt, idrp_ann_list *p_ann_list,int rib_id, int newpolicy)); /* new idrp route */
PROTOTYPE(ph3_qos_case3, void, (idrpRoute *p_idrp_rt, idrpRoute *p_idrp_rt_old, idrp_ann_list *p_ann_list,int rib_id, int newpolicy)); /* new idrp route */
PROTOTYPE(ph3_qos_case7, void, (idrpRoute *p_idrp_rt, idrp_ann_list *p_ann_list,int rib_id, int newpolicy)); /* new idrp route */
PROTOTYPE(qos_in_ann_list, extern int,(idrp_ann_list *p_ann_list));  /* process any qos that have come in */
PROTOTYPE(idrp_process_qos, extern void,(task_timer *tip, time_t interval));  /* process any qos that have come in */
PROTOTYPE(idrp_qos_chg_rib, extern void,());  /* process any qos that have come in */
PROTOTYPE(idrp_qos_kernel_dump, extern void,());  /* process any qos that have come in */
PROTOTYPE(idrp_qos_status_repl, extern void,(idrpRoute *p_idrp_rt, idrpRoute *p_idrp_rt_old));  /* process any qos that have come in */

#endif	IDRP_QOS

/* idrp_rt.c routines */

PROTOTYPE(sock_supported, int, (idrpPeer *peer, sockaddr_un *addr));
PROTOTYPE(idrp_sock_dup, sockaddr_un *, (idrpPeer *peer, sockaddr_un *addr));

/* %% gated interaction routines
 * - mediate_pref_match - modify the gated preference match as phase2 desires
 * - idrp_add_rt_to_gated - add a route to gated tables
 * - idrp_repl_gated_rt - replace an idrpRoute structure in gated table
 *    			- call the rt_change routine to handle changes if needed 
 * - idrp_mod_rt_gated - modify gated routing table 
 */

PROTOTYPE(mediate_pref_match, int , (idrp_rt_chain_walk *p_pref, idrpRoute *p_irt));
PROTOTYPE(idrp_add_rt_to_gated, extern int, (idrpRoute *p_idrp_rt, sockaddr_un *p_dest));   /* add a local route to rib */
PROTOTYPE(idrp_repl_gated_rt, idrpRoute *, (idrpRoute *p_idrp_rt, rt_entry *p_rt));  /* replace rtd portion of gated rt */
PROTOTYPE(idrp_mod_rt_gated, int, (idrpRoute *p_idrp_rt, int pref)); 
PROTOTYPE(idrp_del_rt_gated, int, (idrpRoute *p_idrp_rt, int reset_status_bit_p));
PROTOTYPE(idrp_repl_rt_gated, idrpRoute *, (idrpRoute *p_idrp_rt, rt_entry *p_rt));
PROTOTYPE(idrp_qos_gated_del, void, (idrpRoute *p_idrp_rt, rt_entry *p_rt,int reset_rt_bit));



PROTOTYPE(insert_in_pref_order, int, (idrpRoute *p_rt, idrpRoute *p_best));
PROTOTYPE(idrp_del_best_ext, idrpRoute *, (idrpRoute *p_idrp_rt));
PROTOTYPE(idrp_ann_list_empty, int, (idrp_ann_list *p_ann_list));
PROTOTYPE(find_nlri_in_ann_list, idrpRoute *, (idrpRoute *p_idrp_rt, idrp_ann_list *p_ann_list));
PROTOTYPE(rdi_in_dist_list, int, (idrp_attribute_entry *p_attrib, struct iso_net_addr *p_rdi));
PROTOTYPE(idrp_clear_reconfig, void, (idrp_ann_list *p_ann_list));
PROTOTYPE(idrp_test_stopper, void, ());

PROTOTYPE(idrp_set_import_return_vals, void,
	  (proto_t adv_proto,
           flag_t adv_flag,
           void_t ps_policy,
           void_t ps_data));
PROTOTYPE(idrp_set_export_return_vals, void,
	  (proto_t adv_proto,
           flag_t adv_flag,
           void_t ps_policy,
           idrpRoute *p_route));
PROTOTYPE(policy_rdpath_cmp, int,
	  (const struct _policy_rdpath *p_rdpath1, 
	   const struct _policy_rdpath *p_rdpath2));

PROTOTYPE(idrp_ps_dstmatch, int,  (void *adv_ps_field, 
		sockaddr_un *dst, 
		void *ps_data));
PROTOTYPE(idrp_ps_free, void, (adv_entry *p_adv)); 
PROTOTYPE(idrp_ps_print, char *, (void *adv_ps_field, int doit));
PROTOTYPE(idrp_ps_rtmatch, int, (void *adv_ps_field, rt_entry *p_rt));
PROTOTYPE(idrp_ps_set, int, (void *adv_ps_field, 
		flag_t qos_flag,
		void *ps_data));

/* idrp_policy.c */
PROTOTYPE(rdpath_adv_match, int, 
	  (policy_rdpath *p_policy_rdpath, 
	   struct _rdpath_list *p_actual_path));

/* idrp_rdpath.c */
PROTOTYPE(policy_and_actual_rdpath_cmp, boolean, 
	  (policy_rdpath *p_policy_path,
	   rdpath_list *p_actual_path));
PROTOTYPE(CONSUME_ACTUAL, void, (policy_actual_path_tracking *p_act));
PROTOTYPE(ADVANCE_ACTUAL, void, (policy_actual_path_tracking *p_act));
PROTOTYPE(match_one, boolean,
	  (policy_rdpath **pp_policy,
	   policy_actual_path_tracking *p_actual,
	   boolean *p_synch));
PROTOTYPE(extract_rdi_from_rdpath, rdi *,
	  (rdpath *p_path,
	   int index));
PROTOTYPE(extract_rdi, rdi *,
	  (const policy_actual_path_tracking *p_act));
PROTOTYPE(extract_rdi_with_index, rdi *,
	  (const policy_actual_path_tracking *p_act,
	   int index));
PROTOTYPE(find_rdi_in_seq, boolean, 
	  (const rdi *p_rdi, 
	   policy_actual_path_tracking *p_actual));
PROTOTYPE(find_rdi_in_set, boolean, (const rdi *p_rdi, rdpath *p_path));
PROTOTYPE(match_rdi, boolean, 
	  (const policy_rdpath *p_pol, 
	   const policy_actual_path_tracking *p_act));
PROTOTYPE(match_rdset, boolean, 
	  (policy_rdpath **pp_pol,
	   policy_actual_path_tracking *p_act));
PROTOTYPE(match_rd_or_list, boolean,
	  (policy_rdpath **pp_pol,
	   policy_actual_path_tracking *p_act));
PROTOTYPE(scan_for_rdi, boolean,
	  (const policy_rdpath *p_pol,
	   policy_actual_path_tracking *p_act));
PROTOTYPE(scan_for_rdset, boolean,
	  (policy_rdpath **pp_pol,
	  policy_actual_path_tracking *p_act));
PROTOTYPE(scan_for_rdi_in_or_list, boolean,
	  (policy_rdpath **pp_pol,
	   policy_actual_path_tracking *p_act));
PROTOTYPE(rdpath_adv_free, void,
	  (struct _policy_rdpath *p_rdpath));

#endif /* not define _idrp_prototypes_h */

