/* 
 * $Id: idrp_rdi_list.c,v 1.2 1995/08/01 20:26:07 sjr Exp $ 
 * Merit IDRP release 1.1 (gated 3.5.4).  Copyright (c) 1994 by Merit Network, Inc. 
 */

#include "include.h"
#include "iso.h"
#include "idrp.h"


/* idrp_rdi_list.c - 
 * 
 */


void
exclude_global_rdilist(p_found,p_rdi_list)
idrp_canon_rdpath	*p_found;
idrp_canon_rdpath	**p_rdi_list;
{
idrp_canon_rdpath	*p_rdilist;
rdi			*p_rdi_go;
idrp_canon_rdpath	*p_can;

/* routine to pull found rdi out of this 
 */ 

	p_rdilist = *p_rdi_list;
	if (p_rdilist == p_found)
		{
		/* at the beginning of the list
		 */
 
		*p_rdi_list = p_found->p_next;
		p_found->p_prev = (idrp_canon_rdpath *) NULL;
		}
	else
		{ 
		p_found->p_prev->p_next = p_found->p_next;
		if (p_found->p_next)
			{
			p_found->p_next->p_prev = p_found->p_prev;
			}
		idrp_free_global_rdi(p_found->p_rdi);
		IDRP_MEM_FIT_FREE(p_found);
		} 

}	

idrp_canon_rdpath *
copy_canon_rdi_list(p_rdi_list)
idrp_canon_rdpath *p_rdi_list;
{
idrp_canon_rdpath *p_rdi_new,*p_rdi_nl;
idrp_canon_rdpath *p_can;
idrp_canon_rdpath *p_last = 0;

	/* copy the allocation  
	 */
 
	if (p_rdi_list == (idrp_canon_rdpath *) NULL)
		return((idrp_canon_rdpath *) NULL);

		
	p_rdi_nl = p_rdi_new = (idrp_canon_rdpath *) idrp_local_mem_fit(sizeof(idrp_canon_rdpath));
	RDPATH_LIST(p_rdi_list,p_can)
		{
		/* copy the entry to a new list
	 	 */

		if (p_last)
			{
			p_rdi_nl->p_next =  (idrp_canon_rdpath *) idrp_local_mem_fit(sizeof(idrp_canon_rdpath));
			p_rdi_nl = p_rdi_nl->p_next;
			} 
		p_rdi_nl->p_rdi = p_can->p_rdi;
		p_can->p_rdi->refcnt++; 
		p_rdi_nl->p_prev = p_last;
		p_last = p_rdi_nl;
		}  RDPATH_LIST_END; 

	return(p_rdi_new);	
}


idrp_canon_rdpath *
idrp_add_end_rdilist(p_rdi,p_rdi_list)
rdi			*p_rdi;
idrp_canon_rdpath	*p_rdi_list;
{
idrp_canon_rdpath *p_rdi_new = (idrp_canon_rdpath *) NULL;
idrp_canon_rdpath *p_last = (idrp_canon_rdpath *) NULL;
idrp_canon_rdpath *p_can;

	RDPATH_LIST(p_rdi_list,p_can)
		{
		/* copy the entry to a new list
	 	 */
		p_last = p_can;
		} RDPATH_LIST_END; 

	if (p_last)
		{
		/* add to the list
		 * increment count on the global rdi list
		 */

		p_rdi_new = p_last->p_next = (idrp_canon_rdpath *) idrp_local_mem_fit(sizeof(idrp_canon_rdpath));
		p_rdi_new->p_prev = p_last;
		p_rdi_new->p_rdi = p_rdi;
		p_rdi->refcnt++;	
		}
	
	return(p_rdi_new);	

}

idrp_canon_rdpath *
find_global_rdi_rdilist(p_rdi,p_rdi_list)
rdi			*p_rdi;
idrp_canon_rdpath 	*p_rdi_list;
{
idrp_canon_rdpath 	*p_can;

	RDPATH_LIST(p_rdi_list,p_can)
		{

		/* read through canonical list
		 */

		if (p_can->p_rdi == p_rdi)
			{
			return(p_can);
			}
		} RDPATH_LIST_END;

}

boolean 
same_dist_list(p_dist1,p_dist2)
idrp_canon_rdpath	*p_dist1;
idrp_canon_rdpath	*p_dist2;
{
idrp_canon_rdpath	*p_can;
idrp_canon_rdpath	*p_can2;

	p_can2 = p_dist2;
	/* compare the list by walking the path structure
	 */

	RDPATH_LIST(p_dist1,p_can)
		{
		 if (p_can->p_rdi != p_can2->p_rdi) 
			return(FALSE);

		if ((p_can->p_next != NULL) && (p_can2->p_next == NULL))
			return(FALSE);

		p_can2 = p_can2->p_next;
		} RDPATH_LIST_END;

	return(TRUE);	
} 
