/* 
 * $Id: md4idrp.c,v 1.1.1.1 1994/12/14 01:33:16 labovit Exp $
 * Merit IDRP release 1.1 (gated 3.5.4).  Copyright (c) 1994 by Merit Network, Inc. 
 */

#define MD MD4

#include "md4global.h"	/* RSAREF globals and constants */
#include "md4.h"	/* md4-specific includes */
#include "include.h"	/* generic gated includes */

/* 
 * Function: md4sum
 * Status: Thought to work; not finalized.
 * Author: jgs
 * Date: Mon Dec 07 12:47:00 1992
 * Notes:
 *   md4sum wants a u_char * instead of an idrpBuffer * as previously agreed.
 * This is so that other people can use it more conveniently if they want
 * to, w/o having to cast their pointer as an idrpBuffer pointer.  Is there
 * a "generic pointer" type defined somewhere in the bowels of gated?  If
 * so, we should probably use that.
 *
 * NOTE:  I think that indeed there is a "generic pointer".  The question then
 * is if we really ought to use it.  u_char * seems to be pretty generic of
 * itself.
 *
 *   length should be the length in u_chars (that is, in bytes) of the buffer.
 *   By the way, it may well be possible to tune the md4c.c code to be faster
 * for our application -- it as much as says so in RFC 1320.  However, it's
 * also mentioned that the code is written to be as portable as possible,
 * which seems desirable for our application.  I'm leaving it alone for now.
 *
 * NOTE:  Well, I suspect that we can sacrifice portability for some things.
 * For example, bcopy() is going to exist on all platforms gated runs on, so
 * why not use it?  Given that we're going to call md4 once for each pdu sent
 * and received it will pay to tweak it at least a bit.
 *
 *   Finally, I couldn't think of a good reason to define a separate md4sum
 * type.  I reverted to just using a u_char *.  If there's a reason to go 
 * with an md4sum type instead I'd be glad to do it.
 */

PROTOTYPE(md4, u_int *, (u_char *, u_int, u_int *));

u_int * 
md4 __PF3(buffer, u_char *,	/* buffer to be md4-digested */
	  length, u_int,	/* length of buffer in bytes */
	  digest, u_int *)	/* 16 bytes for md4 digest */
{
	MD4_CTX context;

	/* These all call functions in md4c.c, straight from RFC 1320 */
	MDInit (&context);
	MDUpdate(&context, buffer, length);
	MDFinal(digest, &context);

	return(digest);
}
