/*
 * targets.h,v 1.13 1993/11/29 02:52:56 jch Exp
 */

/* Gated Release 3.5 */
/* Copyright (c) 1990,1991,1992,1993,1994 by Cornell University. All rights */
/* reserved. Refer to Particulars and other Copyright notices at the end of this */
/* file. */


/* Target definitions. */

typedef struct _td_entry {
    struct _td_entry *td_forw, *td_back;
    u_short	td_flags;
    u_short	td_metric;
    rt_entry	*td_rt;
} td_entry;

#define	TDF_HOLDDOWN	0x8000	/* This entry is in holddown */
#define	TDF_CHANGED	0x4000	/* This entry is changed */
#define	TD_HOLDDOWN(tdp)	BIT_TEST((tdp)->td_flags, TDF_HOLDDOWN)
#define	TD_CHANGED(tdp)		BIT_TEST((tdp)->td_flags, TDF_CHANGED)

#define	TD_ALLOC(tdp)	tdp = (td_entry *) task_block_alloc(target_td_block)
#define	TD_FREE(tdp)	task_block_free(target_td_block, tdp)

#define	TD_GET(tlp, rth, tdp)	rttsi_get(rth, (tlp)->target_rtbit, (byte *) &tdp);
#define	TD_SET(tlp, rth, tdp)	rttsi_set(rth, (tlp)->target_rtbit, (byte *) &tdp);

#define	TD_ENQUE(tlp, tdp)	INSQUE(tdp, &(tlp)->target_td)
#define	TD_DEQUE(tdp)		REMQUE(tdp)
#define	TD_ENQUE_FREE(tlp, tdp)	INSQUE(tdp, &(tlp)->target_td_free)

#define	TD_FREEUP(tlp, tdp) \
	{ \
	    TD_DEQUE(tdp); \
	    TD_ENQUE_FREE(tlp, tdp); \
	}

#define	TD_SCHEDULE(tlp) \
	{ \
	    if (!(tlp)->target_free_job) { \
		tlp->target_free_job = task_job_create(tlp->target_task, \
						       TASK_JOB_PRIO_FLASH-1, \
						       "cleanup", \
						       target_cleanup, \
						       (void_t) tlp); \
	    } \
	}
     

#define	TD_LIST(tdp, list) \
	{ \
	    register td_entry *Xtdp_next = (list)->td_forw; \
	    while (Xtdp_next != (list)) { \
		(tdp) = Xtdp_next; \
		Xtdp_next = Xtdp_next->td_forw;
#define	TD_LIST_END(tdp, list) } }

typedef struct _target {
    struct _target *target_next;	/* Pointer to the next one */
    sockaddr_un	**target_dst;		/* Destination */
    sockaddr_un	**target_src;		/* Source */
    if_addr	*target_ifap;		/* Interface */
    gw_entry	*target_gwp;		/* Gateway if available */
    flag_t	target_rtbit;		/* Bit for this target */
    flag_t	target_flags;		/* Protocol dependent flags */
    task	*target_task;		/* Task that owns us */
    td_entry	target_td;		/* Head of list of routes to announce */
    td_entry	target_td_free;		/* Head of list of routes to announce */
    task_job	*target_free_job;	/* Cleanup job */
    _PROTOTYPE(target_reset,
	       void,
	       (task *,
		struct _target *));	/* Routine to clean up a target being freed */
    
} target;

#define	TARGETF_BROADCAST	0x01		/* This is a broadcast address */
#define	TARGETF_SOURCE		0x02		/* This is a P2P client */
#define	TARGETF_SUPPLY		0x04		/* We supply updates to this client */
#define	TARGETF_ALLINTF		0x08		/* We want to see all interfaces */
#define	TARGETF_POLICY		0x10		/* Initial policy has been run */

#define	TARGETF_USER4		0x1000
#define	TARGETF_USER3		0x2000
#define	TARGETF_USER2		0x4000
#define	TARGETF_USER1		0x8000		/* For protocol use */


#define	TARGET_LIST(tlp, list)	for (tlp = list; tlp; tlp = tlp->target_next)
#define	TARGET_LIST_END(tlp, list)

PROTOTYPE(target_locate,
	  extern target *,
	  (target *,
	   if_addr *,
	   gw_entry *));
PROTOTYPE(target_free,
	  extern target *,
	  (task *,
	   target *));
PROTOTYPE(target_cleanup,
	  extern void,
	  (task_job *));
PROTOTYPE(target_build,
	  extern int,
	  (task *,
	   target **,
	   gw_entry *,
	   flag_t,
	   _PROTOTYPE(dump,
		      void,
		      (rt_head *,
		       void_t,
		       char *))));
PROTOTYPE(target_dump,
	  extern void,
	  (FILE *,
	   target *,
	   const bits *));

extern block_t target_td_block;

/*
 * ------------------------------------------------------------------------
 * 
 * 	GateD, Release 3.5
 * 
 * 	Copyright (c) 1990,1991,1992,1993,1994 by Cornell University
 * 	    All rights reserved.
 * 
 * 	THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * 	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * 	LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * 	AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * 	Royalty-free licenses to redistribute GateD Release
 * 	3 in whole or in part may be obtained by writing to:
 * 
 * 	    GateDaemon Project
 * 	    Information Technologies/Network Resources
 * 	    200 CCC
 * 	    Cornell University
 * 	    Ithaca, NY  14853-2601  USA
 * 
 * 	GateD is based on Kirton's EGP, UC Berkeley's routing
 * 	daemon	 (routed), and DCN's HELLO routing Protocol.
 * 	Development of GateD has been supported in part by the
 * 	National Science Foundation.
 * 
 * 	Please forward bug fixes, enhancements and questions to the
 * 	gated mailing list: gated-people@gated.cornell.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 *       Portions of this software may fall under the following
 *       copyrights:
 * 
 * 	Copyright (c) 1988 Regents of the University of California.
 * 	All rights reserved.
 * 
 * 	Redistribution and use in source and binary forms are
 * 	permitted provided that the above copyright notice and
 * 	this paragraph are duplicated in all such forms and that
 * 	any documentation, advertising materials, and other
 * 	materials related to such distribution and use
 * 	acknowledge that the software was developed by the
 * 	University of California, Berkeley.  The name of the
 * 	University may not be used to endorse or promote
 * 	products derived from this software without specific
 * 	prior written permission.  THIS SOFTWARE IS PROVIDED
 * 	``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * 	INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * 	MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
