/*  krt_rtread_kinfo.c,v 1.8.2.3 1994/07/28 02:00:25 jch Exp
 */
/* Gated Release 3.5 */
/* Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.  All */
/* rights reserved.  Refer to Particulars and other Copyright notices at */
/* the end of this file.  */
/*  */


#define       INCLUDE_ROUTE
#define       INCLUDE_IOCTL
#define       INCLUDE_IF
#include <stropts.h>
#include "include.h"
#ifdef        PROTO_INET
#include "inet.h"
#endif        /* PROTO_INET */
#ifdef        PROTO_ISO
#include "iso.h"
#endif        /* PROTO_ISO */
#include "krt.h"
#include "krt_var.h"


/* Use the ioctl() system call to read the routing table(s) */
/*ARGSUSED*/
int
krt_rtread __PF1(tp, task *)
{
    size_t size, alloc_size;
    caddr_t kbuf;
    rt_parms rtparms;
    struct strioctl ioc;
    struct rtrecord *krt;
    if_addr *ifap;

    trace_only_tp(tp,
                TRC_NL_BEFORE,
                ("krt_rtread: Initial routes read from kernel (via socket ioctl)
));

    bzero((caddr_t) &rtparms, sizeof (rtparms));
    rtparms.rtp_n_gw = 1;

    ioc.ic_cmd = SIOCGRTSIZ;
    ioc.ic_timout = 0;
    ioc.ic_len = 0;
    ioc.ic_dp = 0;
    if ((alloc_size = ioctl(tp->task_socket, I_STR, &ioc)) < 0) {
      trace_log_tp(tp,
                   0,
                   LOG_ERR,
                   ("krt_rtread: ioctl for routing table estimate: %m"));
      return errno;
    }
    if (alloc_size < 0) {
      errno = EINVAL;
      trace_log_tp(tp,
                   0,
                   LOG_ERR,
                   ("krt_rtread: routing table estimate: %m"));
      return errno;
    }
    if (alloc_size == 0) {
      goto end;
    }
    trace_tp(tp,
           TR_STATE,
           0,
           ("krt_rtread: routing table estimates %d entries needed",
            alloc_size));
    size = ROUNDUP(alloc_size * sizeof(struct rtrecord), task_pagesize);
    kbuf = (caddr_t) task_block_malloc(size);
    ioc.ic_cmd = SIOCGRTTAB;
    ioc.ic_timout = 0;
    ioc.ic_len = size;
    ioc.ic_dp = (char *)kbuf;
    if ((alloc_size = ioctl(tp->task_socket, I_STR, &ioc)) < 0) {
      trace_log_tp(tp,
                   0,
                   LOG_ERR,
                   ("krt_rtread: routing table retrieve: %d, %m", size));
      task_block_reclaim(size, kbuf);
      return errno;
    }

    krt = (struct rtrecord *) kbuf;
    for ( ; alloc_size ; alloc_size--, krt++ ) {

      {
          struct sockaddr_in *addr;

          addr = (struct sockaddr_in *) &krt->rt_dst;
          addr->sin_family = AF_INET;
          addr->sin_port = 0;
          bzero((caddr_t) addr->sin_zero, sizeof (addr->sin_zero));

          addr = (struct sockaddr_in *) &krt->rt_gateway;
          addr->sin_family = AF_INET;
          addr->sin_port = 0;
          bzero((caddr_t) addr->sin_zero, sizeof (addr->sin_zero));
      }

     rtparms.rtp_dest = sock2gated(&krt->rt_dst, unix_socksize(&krt->rt_dst));

      rtparms.rtp_router = sock2gated(&krt->rt_gateway, unix_socksize(&krt->rt_g
ateway));
      rtparms.rtp_state = krt_flags_to_state((flag_t) krt->rt_flags);
      if (BIT_TEST(krt->rt_flags, RTF_HOST)) {
          rtparms.rtp_dest_mask = sockhostmask(rtparms.rtp_dest);
      } else if ((ifap = if_withdstaddr(rtparms.rtp_dest))
              || (ifap = inet_ifwithnet(rtparms.rtp_dest))) {
          rtparms.rtp_dest_mask = ifap->ifa_netmask;
      } else {
          rtparms.rtp_dest_mask = inet_mask_natural(rtparms.rtp_dest);
      }
      krt_rtread_add(tp,
                     &rtparms,
                     (flag_t) krt->rt_flags,
                     FALSE,
                     "REMNANT");

    }
    task_block_reclaim(size, kbuf);
end:

    return 0;
}
