/*
 * Copyright (c) 1993,1995
 *	Texas A&M University.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Texas A&M University
 *	and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Developers:
 *             David K. Hess, Douglas Lee Schales, David R. Safford
 */
/*
 * Miscellaneous constants.
 */
#define VERSION       "2.0"

#define YES     1
#define NO      0

#define ETHERPROTO     0xA001U
#define SEND_TIMEOUT   3
#define SEND_RETRIES   3
#define SYNC_RETRIES   3

#define PASSWORD_LENGTH 12

#define BUFFER_SIZE     1500

#define DEFAULT_PORT    6767

/* define the three feedback shift register polynomials */
#define MASK1 0x80000057
#define MASK2 0x80000062
#define MASK3 0x20000029

/*
 * Filter protocol message constants.
 */
#define FM_M_SYNC		0
#define FM_M_SYNCACK		1
#define FM_M_WRITE		2
#define FM_M_WRITEACK		3
#define FM_M_REBOOT		4
#define FM_M_REBOOTACK		5
#define FM_M_NEWKEY		6
#define FM_M_NEWKEYACK		7
#define FM_M_QUERY		8
#define FM_M_QUERYACK		9
#define FM_M_LOAD		10
#define FM_M_LOADACK		11
#define FM_M_ERROR		12
#define FM_M_RELEASE		13
#define FM_M_RELEASEACK		14
#define FM_M_STATISTICS		15
#define FM_M_STATISTICSACK	16

#define FM_F_CRYPTED   0x01

#define FM_QUERY_NETWORK   0
#define FM_QUERY_HOST      1
#define FM_QUERY_REJECT    2
#define FM_QUERY_ALLOW     3
#define FM_QUERY_CLASS     4

#define FM_LOAD_NETWORK   0
#define FM_LOAD_REJECT    1
#define FM_LOAD_ALLOW     2
#define FM_LOAD_CLASS     3

#define FM_LOAD_FLAGS_BEGIN  0x01
#define FM_LOAD_FLAGS_END    0x02

#define FM_RELEASE_CLASSES  0
#define FM_RELEASE_REJECT   1
#define FM_RELEASE_ALLOW    2
#define FM_RELEASE_NETWORK  3

#define FM_STATISTICS_QUERY	0
#define FM_STATISTICS_CLEAR	1

#define FM_ERROR_INSECURE        0
#define FM_ERROR_SECURE          1
#define FM_ERROR_PASSFILE        2
#define FM_ERROR_PASSWRITE       3
#define FM_ERROR_NONETWORK       4
#define FM_ERROR_NOMEMORY        5
#define FM_ERROR_COMMAND         6
#define FM_ERROR_DATAFILE        7
#define FM_ERROR_DATAWRITE       8
#define FM_ERROR_INVALIDNETWORK  9
#define FM_ERROR_LOADBUFFER      10
#define FM_ERROR_LOSTSYNC        11

#define MAX_NUM_NETWORKS       32
#define MAX_NUM_ACCESS_LISTS   256
#define MAX_NUM_ACCESS_RANGES  32
#define MAX_NUM_REJECT_ENTRIES 32
#define MAX_NUM_ALLOW_ENTRIES  8


#define FM_STAT_DB_PACKETS_FILTERED_INSIDE 	0
#define FM_STAT_DB_PACKETS_FILTERED_OUTSIDE 	1
#define FM_STAT_DB_PACKETS_RX_INSIDE 		2
#define FM_STAT_DB_PACKETS_RX_OUTSIDE 		3
#define FM_STAT_DB_PACKETS_TX_INSIDE 		4
#define FM_STAT_DB_PACKETS_TX_OUTSIDE 		5
#define FM_STAT_DB_CACHE_ACCESSES	 	6
#define FM_STAT_DB_CACHE_MISSES			7
#define FM_STAT_DB_DROPPED_PACKETS		8
#define FM_STAT_CARD_FRAMES_RX_INSIDE		9
#define FM_STAT_CARD_FRAMES_RX_OUTSIDE		10
#define FM_STAT_CARD_BYTES_RX_INSIDE		11
#define FM_STAT_CARD_BYTES_RX_OUTSIDE		12
#define FM_STAT_CARD_MULTICAST_RX_INSIDE	13
#define FM_STAT_CARD_MULTICAST_RX_OUTSIDE	14
#define FM_STAT_CARD_BROADCAST_RX_INSIDE	15
#define FM_STAT_CARD_BROADCAST_RX_OUTSIDE	16
#define FM_STAT_CARD_CRC_RX_INSIDE		17
#define FM_STAT_CARD_CRC_RX_OUTSIDE		18
#define FM_STAT_CARD_BUFFER_DROPS_RX_INSIDE	18
#define FM_STAT_CARD_BUFFER_DROPS_RX_OUTSIDE	19
#define FM_STAT_CARD_HARDWARE_DROPS_RX_INSIDE	20
#define FM_STAT_CARD_HARDWARE_DROPS_RX_OUTSIDE	21
#define FM_STAT_CARD_FRAMES_TX_INSIDE		22
#define FM_STAT_CARD_FRAMES_TX_OUTSIDE		23
#define FM_STAT_CARD_BYTES_TX_INSIDE		24
#define FM_STAT_CARD_BYTES_TX_OUTSIDE		25
#define FM_STAT_CARD_MULTICAST_TX_INSIDE	26
#define FM_STAT_CARD_MULTICAST_TX_OUTSIDE	27
#define FM_STAT_CARD_BROADCAST_TX_INSIDE	28
#define FM_STAT_CARD_BROADCAST_TX_OUTSIDE	29
#define FM_STAT_CARD_TIMEOUT_DROPS_TX_INSIDE	30
#define FM_STAT_CARD_TIMEOUT_DROPS_TX_OUTSIDE	31
#define FM_STAT_CARD_HARDWARE_DROPS_TX_INSIDE	32
#define FM_STAT_CARD_HARDWARE_DROPS_TX_OUTSIDE	33
#define FM_STAT_UPTIME				34

#define MAX_NUM_STATISTICS	50
