/*
**  File Name:   setdate.c
**
**  usage: setdate [-v] [-d #days] [-h #hours] [filename]
**
**
** This software is Copyright (c) 1989, 1990, 1991 by Kent Landfield.
**
** Permission is hereby granted to copy, distribute or otherwise
** use any part of this package as long as you do not try to make
** money from it or pretend that you wrote it.  This copyright
** notice must be maintained in any copy made.
**
** Use of this software constitutes acceptance for use in an AS IS
** condition. There are NO warranties with regard to this software.
** In no event shall the author be liable for any damages whatsoever
** arising out of or in connection with the use or performance of this
** software.  Any use of this software is at the user's own risk.
**
**  If you make modifications to this software that you feel
**  increases it usefulness for the rest of the community, please
**  email the changes, enhancements, bug fixes as well as any and
**  all ideas to me. This software is going to be maintained and
**  enhanced as deemed necessary by the community.
**
**              Kent Landfield
**              uunet!sparky!kent
**              kent@sterling.com
*/

#ifndef lint
static char sccsid[] = "%W% %G%";
#endif
#include <stdio.h>
#include <ctype.h>
#include <sys/stat.h>
#include <dirent.h>
#include <time.h>

#define SEC_PER_DAY 86400L            /* total seconds per day  */
#define SEC_PER_HOUR 3600L            /* total seconds per hour */

/**********************************************************************/
/*                                                                    */
/*  NAME:       set_date_time                                         */
/*                                                                    */
/*  ABSTRACT:   This routine sets the access and modification         */
/*              times on the target to the secs passed into it.       */
/*  RETURN VALUE:                                                     */
/*              None                                                  */
/*                                                                    */
/**********************************************************************/

void set_date_time(secs,target)
    long secs;
    char *target;
{
    struct    utimbuf    {
        time_t    actime;
        time_t    modtime;
    } *times;

    int  utime();
    void free();
    char *malloc();

    times = (struct utimbuf *) malloc((unsigned)sizeof(struct utimbuf));
    times->actime = secs;
    times->modtime = secs;
    (void) utime(target, (struct { time_t x,y;} *)times);
    free(times);
}

/**********************************************************************/
/*                                                                    */
/*  NAME:       main                                                  */
/*                                                                    */
/*  ABSTRACT:   This routine sets the day on a file to that passed in.*/
/*              Input from stdin: must be in ls -l format.            */
/*              Input from command line: datestring and a filename    */
/*  RETURN VALUE:                                                     */
/*              None                                                  */
/*                                                                    */
/**********************************************************************/

main(argc,argv)
    int argc;
    char *argv[];
{
    void perror();
    char *strrchr();

    extern char *optarg;
    extern int optind, opterr;

    char Buf[BUFSIZ];
    int c;
    long long_secs;
    long subtract = 0L;
    int verbose = 0;

    struct stat stbuf;
    
    opterr = 0;
 
    while ((c = getopt(argc,argv,"d:h:v")) != EOF) {
        switch(c) {
        case 'h': subtract = atol(optarg) * SEC_PER_HOUR;
		  break;
        case 'd': subtract = atol(optarg) * SEC_PER_DAY;
		  break;
        case 'v': 
            	verbose++; 
		break;
         default: 
                (void)printf("usage: %s [-v] [-d #days] [-h #hours] [filename]\n",argv[0]);
                return(1);
        }
    }

    if ((optind >= argc) || (argc == 1)) {  /* file from stdin */
        while (fgets(Buf,sizeof Buf,stdin) != NULL) {
            Buf[strlen(Buf) -1] = '\0';
            if (stat(Buf, &stbuf) == 0) {
                long_secs = stbuf.st_mtime - subtract;
                set_date_time(long_secs,Buf);
                return(0);
            }
        }
    }
    else {
        if (stat(argv[optind], &stbuf) == 0) {
            long_secs = stbuf.st_mtime - subtract;
            if (verbose) 
                (void) printf("Secs: %ld - File: %s\n",long_secs,argv[optind]);
                set_date_time(long_secs,argv[optind]);
                return(0);
        }
    }
    return(0);
}
