

/***********************************************************
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/* 
 * keyWSinkP.h - Private definitions for keyWSink object
 * 
 */

#ifndef _XawKeyWSinkP_h
#define _XawKeyWSinkP_h

/***********************************************************************
 *
 * KeyWSink Object Private Data
 *
 ***********************************************************************/

#include <X11/Xaw/TextSinkP.h> 
#include <X11/Xaw/AsciiSinkP.h> 
#include "KeyWSink.h"

/************************************************************
 *
 * New fields for the KeyWSink object class record.
 *
 ************************************************************/

typedef struct _KeyWSinkClassPart {
  int foo;
} KeyWSinkClassPart;

/* Full class record declaration */

typedef struct _KeyWSinkClassRec {
    ObjectClassPart     object_class;
    TextSinkClassPart	text_sink_class;
    AsciiSinkClassPart	ascii_sink_class;
    KeyWSinkClassPart	keyw_sink_class;
} KeyWSinkClassRec;

extern KeyWSinkClassRec keyWSinkClassRec;

/* New fields for the KeyWSink object record */
typedef struct {
    /* public resources */
    char  **wordList;

    /* private state */
} KeyWSinkPart;

/****************************************************************
 *
 * Full instance record declaration
 *
 ****************************************************************/

typedef struct _KeyWSinkRec {
    ObjectPart          object;
    TextSinkPart	text_sink;
    AsciiSinkPart	ascii_sink;
    KeyWSinkPart	keyw_sink;
} KeyWSinkRec;

/* These symbols are not defined prior to X11R5 (or is is R4).
   Earlier Xaw versions used just LF, TAB, and SP amoung others.
   They normally come from TextP.h which is included by TextSink.h
   (included above); so, just to make sure... */

#ifndef XawLF
#define	XawLF	0x0a
#endif

#ifndef XawTAB
#define	XawTAB	0x09
#endif

#ifndef XawSP
#define	XawSP	0x20
#endif

#endif /* _XawKeyWSinkP_h */
