/* gui.h
   declarations for functions in gui.c */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.3     08 April 1993                  */
     /*                version 1.2     20 November 1992               */
     /*                version 1.1     20 April 1992                  */
     /*                version 1.0     04 March 1992                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992, 1993 by                                       */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/

#ifndef	GUI_H
#define	GUI_H
#include "gopher.h"
#include "status.h"
#include "popres.h"
#include <X11/Intrinsic.h>

#define XgRShowLevel	"ShowLevel"
typedef enum { showAll, showKnown, showAccessible, showAvailable } showLevel;
#define showEAll	"all"
#define showEKnown	"known"
#define showEAccessible	"accessible"
#define showEAvailable	"available"

#define XgRCopyType	"CopyType"
#define copyTypeEUnspec	"unspecified"
#define copyTypeENone	"none"
#define copyTypeEAscii	"ascii"
#define copyTypeEBinary	"binary"
#define copyTypeEBinaryEOF	"binaryEOF"

#define fromENone	"none"
#define fromEPointer	"pointer"
#define fromEMain	"application"
#define fromEWidget	"widget"
#define fromEScreen	"screen"

#define justETop	"top"
#define justELeft	"left"
#define justECenter	"center"
#define justEBottom	"bottom"
#define justERight	"right"

Boolean	cvtStringToShowLevel(
#ifdef PROTO
	Display *,	/* dpy */
	XrmValuePtr,	/* args */
	Cardinal *,	/* num_args */
	XrmValuePtr,	/* fromVal */
	XrmValuePtr,	/* toVal */
	XtPointer *	/* closureRet */
#endif
);

Boolean	cvtStringToPositionFrom(
#ifdef PROTO
	Display *,	/* dpy */
	XrmValuePtr,	/* args */
	Cardinal *,	/* num_args */
	XrmValuePtr,	/* fromVal */
	XrmValuePtr,	/* toVal */
	XtPointer *	/* closureRet */
#endif
);

Boolean	cvtStringToJustification(
#ifdef PROTO
	Display *,	/* dpy */
	XrmValuePtr,	/* args */
	Cardinal *,	/* num_args */
	XrmValuePtr,	/* fromVal */
	XrmValuePtr,	/* toVal */
	XtPointer *	/* closureRet */
#endif
);

Boolean	cvtStringToCopyType(
#ifdef PROTO
	Display *,	/* dpy */
	XrmValuePtr,	/* args */
	Cardinal *,	/* num_args */
	XrmValuePtr,	/* fromVal */
	XrmValuePtr,	/* toVal */
	XtPointer *	/* closureRet */
#endif
);

BOOLEAN	initGUI(
#ifdef PROTO
	int *,		/* argc */
	char **		/* argv */
#endif
);

static BOOLEAN	getOptions(
#ifdef PROTO
	int,		/* argc */
	char **		/* argv */
#endif
);

void	closeGUIandQuit(
#ifdef PROTO
	int		/* rc */
#endif
);

void	loadMarks(
);

void	markCurrentDirectory(
);

void	doUserRequests(
);

void	makeXThings(
);

gopherItemP	getSelectedItem(
);

void	markCurrentDirectory(
);

void	showError(
#ifdef PROTO
	char *		/* message */
#endif
);

void	showFatalError(
#ifdef PROTO
	char *		/* message */
#endif
);

void	showInfo(
#ifdef PROTO
	char *		/* message */
#endif
);

void	showStatus(
#ifdef PROTO
	char *,		/* message */
	statusType,	/* statType */ 
	char *,		/* host */
	int		/* port */
#endif
);

void	displayCurrent(
);

void	displayBookmarks(
);

void	checkPanelButtons(
);

void	clearBookmarks(
);

void	showFile(
#ifdef PROTO
	gopherItemP,	/* gi */
	char *,		/* title */
	char *,		/* fileName */ 
	char *		/* indexString */ 
#endif
);

void	showNameServer(
#ifdef PROTO
	char *,		/* title */
	int		/* s */ 
#endif
);

void	showIndex(
#ifdef PROTO
	gopherItemP 		/* gi */
#endif
);

void showHelp(
#ifdef PROTO
	char *		/* key */
#endif
);

#define POS_none        0
#define POS_pointer     1
#define POS_appPanel    2
#define POS_screen      3

void setPopupGeometry(
#ifdef PROTO
	Widget,  	/* w */
	popupPosResources *	/* placement */
#endif
);

void findPopupPosition(
#ifdef PROTO
	Widget,			/* w */
	Widget,			/* fromWidget */
	popupPosResources *,	/* placement */
	Position *,		/* rootX */
	Position *		/* rootY */
#endif
);

void positionAPopup(
#ifdef PROTO
	Widget,  	/* w */
	Widget,		/* fromWidget */
	popupPosResources *	/* placement */
#endif
);

void setTextWidgetSize(
#ifdef PROTO
	Widget,		/* textWidget */
	int,		/* width */
	int		/* height */
#endif
);

void getTextSize(
#ifdef PROTO
	Widget,		/* textWidget */
	int,		/* width */
	int,		/* height */
	Dimension *,		/* retun width in pixels */
	Dimension *		/* retun height in pixels */
#endif
);

static void maxWaitTimeProc(
#ifdef PROTO
	XtPointer,	/* clientData */
	XtIntervalId *	/* id */
#endif
);

void WaitForAllPendingEventsAndExpose(
#ifdef PROTO
	Display *,	/* dpy */
	Window		/* needToSee */
#endif
);

#endif	/* GUI_H */
