/* jobs.h
   header file for jobs.c */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.3     08 April 1993                  */
     /*                version 1.2     20 November 1992               */
     /*                version 1.1     20 April 1992                  */
     /*                version 1.0     04 March 1992                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992, 1993 by                                       */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/

#ifndef JOBS_H
#define JOBS_H
#include "osdep.h"

typedef struct jobListStruct {
	char	jobType;
	PID_TYPE	pid;
	struct jobListStruct *next;
	} jobList;


#include <signal.h>
#define KILL_SIGNAL	SIGTERM

#define NO_JOB		((PID_TYPE) -1)
#define NO_TYPE		(A_UNKNOWN)


void		addJob(
#ifdef PROTO
	int,		/* t */		/* really char */
	int		/* pid */	/* really PID_TYPE */
#endif
);

BOOLEAN		removeJob(
#ifdef PROTO
	int		/* pid */	/* really PID_TYPE */
#endif
);

char		findJobPID(
#ifdef PROTO
	int		/* pid */	/* really PID_TYPE */
#endif
);

PID_TYPE	findJobType(
#ifdef PROTO
	int		/* t */		/* really char */
#endif
);

void		killItemProcess(
#ifdef PROTO
	int		/* pid */	/* really PID_TYPE */
#endif
);

void		killAllItemType(
#ifdef PROTO
	int		/* t */		/* really char */
#endif
);

void		killAllItemProcesses(
);

void		waitOnChildren(
);

void		waitForJob(
#ifdef PROTO
	int		/* waitPID */	/* really PID_TYPE */
#endif
);

void		childIsGone(
);

#ifdef DEBUG
void		listJobs(
);
#endif /* DEBUG */

#endif	/* JOBS_H */
