/*
 * (C)opyright 1995 by Darren Reed.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and due credit is given
 * to the original author and the contributors.
 *
 * @(#)var.h	1.5 12/17/95
 */

extern	void	add_var();
extern	void	clear_var();
extern	void	del_lvl();
extern	void	call_emitpolicy();
extern	void	clear_policy();
extern	int	setup_policy();

typedef	struct	var	{
	struct	var	*va_next;	/* */
	int	va_lvl;			/* which if level */
	int	va_policy;
	char	*va_inout;
	char	*va_host[2];
	char	*va_net[2];
	char	*va_mask[2];
	char	*va_portcmp[2];
	char	*va_port1[2];
	char	*va_port2[2];
	char	*va_flags;
	char	*va_opts;
	char	*va_proto;
	char	*va_iface;
	char	*va_ttl;
	char	*va_tos;
	char	*va_action;
	char	*va_aclnum;
}	var_t;

#define	VP_ACTION	1
#define	VP_INTERFACE	2
#define	VP_PROTOCOL	4
#define	VP_INOUT	8
#define	VP_ACCESSLIST	16
#define	VP_LOG		32

#define	VA_ACTION	0
#define	VA_INOUT	1
#define	VA_ON		2
#define	VA_LOG		3
#define	VA_PROTO	4
#define	VA_FNET		5
#define	VA_FHOST	VA_FNET
#define	VA_FMASK	6
#define	VA_FPORT	7
#define	VA_TNET		8
#define	VA_THOST	VA_TNET
#define	VA_TMASK	9
#define	VA_TPORT	10
#define	VA_FLAGS	11
#define	VA_IPOPTS	12
#define	VA_ACL		13
#define	VA_MAX		(VA_ACL + 1)


typedef	struct	{
	char	*ft_name;
	int	ft_type;
	void	(*ft_func)();
	void	(*ft_emitpolicy)();
} target_t;

#define	FL_IPFILTER	1
#define	FL_IPFWADM	2
#define	FL_IPFIREWALL	3
#define	FL_IPFW		4
#define	FL_CISCO	5
#define	FL_SCREEND	6

