%{

#include "lex.h"

#undef input
#undef unput
#undef output
#undef yywrap

#define input() (*lex_source++)
#define unput(c) (*lex_source--)
#define output(c)
#define yywrap() 1

char *lex_source;
%}
%e 1100
%p 3000
%%
#			return(FMCOMMENT);
set 			return(FMSET);
load			return(FMLOAD);
verbose			return(FMVERBOSE);
target			return(FMTARGET);
key			return(FMKEY);
network			return(FMNETWORK);
networks                return(FMNETWORKS);
classes			return(FMCLASSES);
show			return(FMSHOW);
host			return(FMHOST);
class			return(FMCLASS);
allow			return(FMALLOW);
reject			return(FMREJECT);
query			return(FMQUERY);
statistics		return(FMSTATISTICS);
upload			return(FMUPLOAD);
write			return(FMWRITE);
quit			return(FMQUIT);
clear			return(FMCLEAR);
reset			return(FMRESET);
release			return(FMRELEASE);
reboot 			return(FMREBOOT);
newkey			return(FMNEWKEY);
genkey			return(FMGENKEY);
ping                    return(FMPING);
conditions		return(FMCONDITIONS);
warranty		return(FMWARRANTY);
\?                      return(FMHELP);
!			return(FMSHELL);
help                    return(FMHELP);
.			return(UNKNOWN);
%%
int tokenize(char *string)
{
    if (string == (char *) NULL || *string == '\0') 
	return EMPTY;

    lex_source = string;

    return yylex();
}
