/*
 * Copyright (c) 1993,1995
 *	Texas A&M University.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Texas A&M University
 *	and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Developers:
 *             David K. Hess, Douglas Lee Schales, David R. Safford
 */
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <malloc.h>
#include <memory.h>
#include "ports.h"
#include "protocols.h"
#include "services.h"
#include "chario.h"
#include "classes.h"
#include "hosts.h"
#include "y.tab.h"

#define TRUE 1
#define FALSE 0
	

struct keywds {
     char *name;
     int token;
};

struct keywds keywords[] = {
     { "in", IN },
     { "out", OUT },
     { "inout", INOUT },
     { "in-out", INOUT },
     { "define", DEFINE },
     { "host", HOST },
     { "include", INCLUDE },
     { "network", NETWORK },
     { "reject", REJECT },
     { "allow", ALLOW },
     { "src", SRC },
     { "dst", DST },
     { (char *)0, 0 }
     };

static int buflen = 0;
static int bufptr = 0;
static char *buffer = (char *)0;
     
int
yylex(void)
{
     int c;
     int comment = FALSE;
     int number;
     int i;
     int quote;
     
     while((c = fetchar())){
	  if(c == '#')
	       comment = TRUE;
	  else if(comment){
	       if(c == '\n')
		    comment = FALSE;
	  }
	  else if(!isspace(c))
	       break;
     }
     buflen = 16;
     buffer = (char *)malloc(buflen);
     if(!buffer){
	  fprintf(stderr, "%s, line %d: malloc failed\n",
		  __FILE__, __LINE__);
	  exit(1);
     }

     quote = FALSE;
     if(isalnum(c) || c == '"'){
	  bufptr = 0;
	  if(c == '"'){
	       quote = TRUE;
	       number = FALSE;
	  }
	  else {
	       buffer[bufptr++] = c;
	       number = isdigit(c);
	  }
	  while((c=fetchar())){
	       if(c == '"'){
		    if(quote)
			 c = fetchar();
		    break;
	       }
	       else if(!quote){
		    if(isspace(c))
			 break;
		    if(c == '<' || c == '>' || c == ',' ||
		       c == ';' || c == '=' || c == '/')
			 break;
		    if(bufptr && number && !isdigit(c) && !isalpha(c))
			 break;
		    if(!isdigit(c))
			 number = FALSE;
	       }
	       if(bufptr == buflen){
		    buflen *= 2;
		    buffer = (char *)realloc(buffer, buflen);
		    if(!buffer){
			 fprintf(stderr, "%s, line %d: realloc failed\n",
				 __FILE__, __LINE__);
			 exit(1);
		    }
	       }
	       buffer[bufptr++] = c;
	  }
	  pushchar(c);
	  if(bufptr == buflen){
	       buflen *= 2;
	       buffer = (char *)realloc(buffer, buflen);
	       if(!buffer){
		    fprintf(stderr, "%s, line %d: realloc failed\n",
			    __FILE__, __LINE__);
		    exit(1);
	       }
	  }
	  buffer[bufptr] = 0;
	  if(number){
	       int value = atoi(buffer);
	       free(buffer);
	       yylval.int32 = value;
	       if(value < 256)
		    return BYTEVAL;
	       return
		    INTEGER;
	  }

	  for(i=0;keywords[i].name;i++)
	       if(!strcmp(buffer, keywords[i].name)){
		    yylval.str = buffer;
		    return keywords[i].token;
	       }
	  yylval.str = buffer;
	  return STRING;
     }
     return c;
}
