/* sc_telnet.c
   gopher item subclass procedures for telnet sessions */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.3     08 April 1993                  */
     /*                version 1.2     20 November 1992               */
     /*                version 1.1     20 April 1992                  */
     /*                version 1.0     04 March 1992                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992, 1993 by                                       */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/

#include "conf.h"
#include "globals.h"
#include "gopher.h"
#include "appres.h"
#include "util.h"
#include "status.h"
#include "subst.h"
#include "sc_telnet.h"
#include "sc_telnetP.h"



/* giveTelnetSession
   provide an Xterm session running a telnet command */

static BOOLEAN
giveTelnetSession(gi)
gopherItemP	gi;
{
	char	*telnetCmd;	
	char	message[MESSAGE_STRING_LEN];


	if ((int) strlen ( appResources->telnetCommand ) <= 0 ) {
		showError("Cannot execute the telnet command");
		return FALSE;
	}

	if (gi->host == NULL || (int) strlen ( gi->host ) <= 0 ) {
		showError("There is no host to telnet to.");
		return FALSE;
	}

	telnetCmd = editCommand(gi, appResources->telnetCommand,
			 (char *) NULL, (char *) NULL);
	
	showStatus("starting a telnet session window", STAT_TEMP_MESSAGE,
			gi->host, gi->port);
	system(telnetCmd);
	free (telnetCmd);

	if ((int) strlen(vStringValue(&(gi->selector))) > 0) {
	    sprintf(message,
		"If a login name is required, try:\n\'%s\'",
		vStringValue(&(gi->selector)));
	    showInfo(message);
	}

	return TRUE;
}


/* GITelnet_init
   initialize telnet session class - prefix string */

void
GITelnet_init()
{
	GU_makePrefix(prefixTelnet,  appResources->prefixTelnet);
	GU_registerNewType(A_TELNET, &telnetSubclass);

	return;
}


/* GITelnet_access
   check the accessability of a telnet session item */

BOOLEAN
GITelnet_access(gi)
gopherItemP	gi;
{
	BOOLEAN	result;

	if (appResources->allowTelnet) {
		result = TRUE;
	}else {
		result = FALSE;
	}

	return result;
}


/* GITelnet_process
   process a telnet session selection. */

BOOLEAN
GITelnet_process(gi)
gopherItemP	gi;
{
	BOOLEAN	result;

	result = giveTelnetSession(gi);

	return result;
}
