/* single.c
   make and handle callbacks for inserting a single (out of context)
   gopher item */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.3     08 April 1993                  */
     /*                version 1.2     20 November 1992               */
     /*                version 1.1     20 April 1992                  */
     /*                version 1.0     04 March 1992                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992, 1993 by                                       */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/AsciiText.h>

#include "osdep.h"
#include "gopher.h"
#include "item.h"
#include "misc.h"
#include "help.h"
#include "panel.h"
#include "single.h"
#include "compatR4.h"
#include "xglobals.h"
#include "globals.h"
#include "util.h"
#include "gui.h"


static Widget		topLevel, singlePanel;
static Widget		giType, giName, giPath, giHost, giPort;

#define	DEFAULT_NAME	"Specially entered Gopher item"


#define THIS_POPUP_NAME		"singleItemPopup"

				/* default values */
static popupPosResources	placement = {
	/* position at the left of the main panel, 10% down */
	from_main, 0, 10, justify_top_left, justify_top_left, True, True
	};



/* createTextFieldL
   create a labelled single-line text field widget pair */

static Widget
createTextFieldL(name, parent, below)
char	*name;
Widget	parent, below;
{
	char	tempName[50];
	Widget	theForm, theText, theLabel;
	Arg	args[10];
	Cardinal	n;
	Dimension	w, h;

	strcpy(tempName, name);
	strcat(tempName, "Form");
	n = 0;
	if (below != NULL) {
	    XtSetArg(args[n], XtNfromVert, XtParent(below));  n++;
	}
	theForm = XtCreateManagedWidget(tempName, formWidgetClass,
			parent, args, n);

	strcpy(tempName, name);
	strcat(tempName, "Label");
	n = 0;
	XtSetArg(args[n], XtNbottom, XawChainBottom);  n++;
	XtSetArg(args[n], XtNtop, XawChainTop);  n++;
	XtSetArg(args[n], XtNright, XawChainLeft);  n++;
	XtSetArg(args[n], XtNleft, XawChainLeft);  n++;
	theLabel = XtCreateManagedWidget(tempName, labelWidgetClass,
			theForm, args, n);
	getTextSize(theLabel, 10, 1, &w, &h);
	n = 0;
	XtSetArg(args[n], XtNwidth, w);  n++;
	XtSetArg(args[n], XtNheight, h);  n++;
	XtSetValues(theLabel, args, n);
	
	n = 0;
	XtSetArg(args[n], XtNresizable, True);  n++;
	XtSetArg(args[n], XtNeditType, XawtextEdit);  n++;
	XtSetArg(args[n], XtNfromHoriz, theLabel);  n++;
	XtSetArg(args[n], XtNbottom, XawChainBottom);  n++;
	XtSetArg(args[n], XtNtop, XawChainTop);  n++;
	XtSetArg(args[n], XtNright, XawChainRight);  n++;
	XtSetArg(args[n], XtNleft, XawChainLeft);  n++;
	theText = XtCreateManagedWidget(name, asciiTextWidgetClass,
			theForm, args, n);
	setTextWidgetSize(theText, 40, 1);
	XtOverrideTranslations(theText, oneLineParsed);

	return theText;
	
}


/* setText
   set the contents of a text field to a string */

static void
setText(w, value)
Widget	w;
String	value;
{
	Arg		args[2];
	Cardinal	n;

	n = 0;
	XtSetArg(args[n], XtNstring, value);  n++;
	XtSetValues(w, args, n);
}


/* getText
   get the current contents of a text field */

static char *
getText(w)
Widget	w;
{
	Arg		args[2];
	Cardinal	n;
	String		value;

	n = 0;
	XtSetArg(args[n], XtNstring, &value);  n++;
	XtGetValues(w, args, n);

	return value;
}


/* buildSingleItem
   build the gopher item supplied through this panel */

static gopherItemP
buildSingleItem()
{
	char	*type, *name, *path, *host, *value;
	int	port;


	type = getText(giType);

	name = getText(giName);
	if (strcmp(name, "") == 0) {
		name = DEFAULT_NAME;
	}

	path = getText(giPath);

	host = getText(giHost);

	value = getText(giPort);
	if ( 1 != sscanf (value, "%d", &port) ) {
		port = 0;
	}

	return makeItem(*type, name, path, host, port, FALSE);
}


/* processSingleItem
   process the gopher item supplied through this panel */

static void
processSingleItem()
{
	gopherItemP	gi;

	gi = buildSingleItem();

	processItem(gi);
	checkButtonState(BS_changeSelected | BS_previous);

	freeItem(gi);
}


/* displaySinglePanel
   pop up the single gopher item panel window */

void
displaySinglePanel()
{
	gopherItemP	gi = getSelectedItem();

	/* if any item or bookmark is selected, prime this panel
	    with those fields */

	if (gi != (gopherItemP) NULL) {
		char	typeStr[2];
		char	portStr[8];

		typeStr[0] = gi->type;
		typeStr[1] = NULLC;
		sprintf (portStr, "%d", gi->port);

		setText(giType, typeStr);
		setText(giName, USER_STRING(gi));
		setText(giPath, vStringValue(&(gi->selector)));
		setText(giHost, gi->host);
		setText(giPort, portStr);
	}

	positionAPopup(singlePanel, topLevel, &placement);

	XtPopup(singlePanel, XtGrabNone);

	return;
}


/* endSinglePanel
   pop down the single gopher item panel window */

void
endSinglePanel()
{
	XtPopdown(singlePanel);

	return;
}


/* doneProc
   done callback for single gopher item panel */

static void
doneProc(w, client_data, call_data)
Widget		w;
XtPointer	client_data, call_data;
{

	endSinglePanel();

	processSingleItem();
}


/* cancelProc
   cancel callback for single gopher item panel */

static void
cancelProc(w, client_data, call_data)
Widget		w;
XtPointer	client_data, call_data;
{
	endSinglePanel();
}


/* clearProc
   clear fields callback for single gopher item panel */

static void
clearProc(w, client_data, call_data)
Widget		w;
XtPointer	client_data, call_data;
{
	setText(giType, "0");
	setText(giName, "");
	setText(giPath, "");
	setText(giHost, "");
	setText(giPort, "70");
}


/* singleMarkProc
   mark callback for single gopher item panel */

static void
singleMarkProc(w, client_data, call_data)
Widget		w;
XtPointer	client_data, call_data;
{
	gopherItemP	gi;

	gi = buildSingleItem();
	markItem(gi);
	unselectAllProc();
	displayBookmarks();
	checkButtonState(BS_unmark | BS_unmarkAll | BS_saveMarks);
}


/* singleHelpProc
   help callback for single gopher item panel. */

static void
singleHelpProc(w, client_data, call_data)
Widget		w;
XtPointer	client_data, call_data;
{
	char	*string;

	showHelp("single help");
}


/* doneActionProc
   implement the done action */

static void
doneActionProc(w, event, params, numParams)
Widget		w;
XEvent		*event;
String		*params;
Cardinal	*numParams;
{
	doneProc(NULL, NULL, NULL);
}


/* markActionProc
   implement the mark action */

static void
markActionProc(w, event, params, numParams)
Widget		w;
XEvent		*event;
String		*params;
Cardinal	*numParams;
{
	singleMarkProc(NULL, NULL, NULL);
}


/* cancelActionProc
   implement the cancel action */

static void
cancelActionProc(w, event, params, numParams)
Widget		w;
XEvent		*event;
String		*params;
Cardinal	*numParams;
{
	cancelProc(NULL, NULL, NULL);
}


/* clearActionProc
   implement the clear action */

static void
clearActionProc(w, event, params, numParams)
Widget		w;
XEvent		*event;
String		*params;
Cardinal	*numParams;
{
	clearProc(NULL, NULL, NULL);
}


/* helpActionProc
   implement the help action */

static void
helpActionProc(w, event, params, numParams)
Widget		w;
XEvent		*event;
String		*params;
Cardinal	*numParams;
{
	singleHelpProc(NULL, NULL, NULL);
}


/* makeSinglePanel
   create the elements of the single gopher item panel */

void
makeSinglePanel(top)
Widget	top;
{
	Widget		doneButton, helpButton, cancelButton, markButton,
			clearButton, singleForm, buttonBox;
	Widget		itemsForm, previous;
	Arg		args[10];
	Cardinal	n;

	static XtActionsRec	actionsTable[] = {
				{"singleDone",   doneActionProc},
				{"singleCancel", cancelActionProc},
				{"singleClear",	 clearActionProc},
				{"singleHelp",   helpActionProc},
				};

	topLevel = top;

	XtAppAddActions(appcon, actionsTable, XtNumber(actionsTable));


	/* create single gopher item panel */

	n = 0;
	XtSetArg(args[n], XtNtitle, "Special Gopher Item");  n++;
	singlePanel = XtCreatePopupShell("singlePanel",
			transientShellWidgetClass, topLevel, args, n);

	/* create SINGLE ITEM form */

	singleForm = XtCreateManagedWidget("singleForm", formWidgetClass,
					singlePanel, NULL, (Cardinal) 0);


	/* create BUTTON box */

		n = 0;
		XtSetArg(args[n], XtNorientation, XtorientHorizontal);  n++;
		XtSetArg(args[n], XtNtop,	XawChainTop);  n++;
		XtSetArg(args[n], XtNbottom,	XawChainTop);  n++;
		XtSetArg(args[n], XtNleft,	XawChainLeft);  n++;
		XtSetArg(args[n], XtNright,	XawChainLeft);  n++;
	buttonBox = XtCreateManagedWidget("buttonBox", boxWidgetClass,
					singleForm, args, n);



	/* create ITEMS form */

		n = 0;
		XtSetArg(args[n], XtNfromVert,	buttonBox);  n++;
		XtSetArg(args[n], XtNtop,	XawChainTop);  n++;
		XtSetArg(args[n], XtNbottom,	XawChainBottom);  n++;
		XtSetArg(args[n], XtNleft,	XawChainLeft);  n++;
		XtSetArg(args[n], XtNright,	XawChainRight);  n++;
	itemsForm = XtCreateManagedWidget("itemsForm", formWidgetClass,
					singleForm, args, n);


	/* create text fields */

	giType = createTextFieldL("giType", itemsForm, NULL);
	giName = createTextFieldL("giName", itemsForm, giType);
	giPath = createTextFieldL("giPath", itemsForm, giName);
	giHost = createTextFieldL("giHost", itemsForm, giPath);
	giPort = createTextFieldL("giPort", itemsForm, giHost);

	setText(giType, "0");
	setText(giName, "");
	setText(giPath, "");
	setText(giHost, "");
	setText(giPort, "70");
				

	/* create QUIT button */

		n = 0;
	doneButton = XtCreateManagedWidget("done", commandWidgetClass,
					buttonBox, args, n);
		XtAddCallback(doneButton, XtNcallback, doneProc, NULL);

	/* create CANCEL button */

		n = 0;
		XtSetArg(args[n], XtNfromHoriz,	doneButton);  n++;
	cancelButton = XtCreateManagedWidget("cancel", commandWidgetClass,
					buttonBox, args, n);
		XtAddCallback(cancelButton, XtNcallback, cancelProc, NULL);

	/* create CLEAR button */

		n = 0;
		XtSetArg(args[n], XtNfromHoriz,	cancelButton);  n++;
	clearButton = XtCreateManagedWidget("clear", commandWidgetClass,
					buttonBox, args, n);
		XtAddCallback(clearButton, XtNcallback, clearProc, NULL);

	/* create MARK button */

		n = 0;
		XtSetArg(args[n], XtNfromHoriz,	clearButton);  n++;
	markButton = XtCreateManagedWidget("mark", commandWidgetClass,
					buttonBox, args, n);
		XtAddCallback(markButton, XtNcallback, singleMarkProc, NULL);

	/* create HELP button */

		n = 0;
		XtSetArg(args[n], XtNfromHoriz,	markButton);  n++;
	helpButton = XtCreateManagedWidget("help", commandWidgetClass,
					buttonBox, args, n);
		XtAddCallback(helpButton, XtNcallback, singleHelpProc, NULL);


	/* for ICCCM window manager protocol complience */

	XtOverrideTranslations (singlePanel,
	    XtParseTranslationTable ("<Message>WM_PROTOCOLS: singleCancel()"));
	XtRealizeWidget(singlePanel);
	(void) XSetWMProtocols (XtDisplay(singlePanel), XtWindow(singlePanel),
	                            &wmDeleteAtom, 1);


	/* find the popup placement for this shell */

	{
	popupPosResources *resourcePlacement;

	resourcePlacement = getPopupPosResources(
				THIS_POPUP_NAME, POPUP_POS_CLASS, &placement);
	bcopy( (char *) resourcePlacement, (char *) &placement,
				sizeof(popupPosResources) );
	}


	return;
}
