/* util.h
   declarations of utility procedures. */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.3     08 April 1993                  */
     /*                version 1.2     20 November 1992               */
     /*                version 1.1     20 April 1992                  */
     /*                version 1.0     04 March 1992                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992, 1993 by                                       */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/

#ifndef UTIL_H
#define UTIL_H

#include "gopher.h"


accessList	nullHostList;


gopherItemP	makeItem(
#ifdef PROTO
	int,		/* type  -- really char, but gcc complains */
	char *,		/* titleString */
	char *,		/* selectString */
	char *,		/* host */
	int,		/* port */
	BOOLEAN		/* plus */
#endif
);

void			initItemClasses(
);

void			doneItemClasses(
);

void			restartItemClasses(
);

BOOLEAN			processItem(
#ifdef PROTO
	gopherItemP	/* gi */
#endif
);

BOOLEAN			copyItemToFile(
#ifdef PROTO
	gopherItemP	/* gi */
#endif
);

void			updateDirectory(
#ifdef PROTO
	gopherDirP	/* d */
#endif
);

static BOOLEAN		GU_ftpCheck(
#ifdef PROTO
	gopherItemP	/* gi */
#endif
);

void			GU_makePrefix(
#ifdef PROTO
	char *,		/* target */
	char *		/* source */
#endif
);

static gopherItemP	GU_getGopherItem(
#ifdef PROTO
	int		/* gfd */
#endif
);

scInfo			*GU_copySubclassRecord(
#ifdef PROTO
	int		/* type  -- really char, but gcc complains */
#endif
);

BOOLEAN			GU_isVowel(
#ifdef PROTO
	char *		/* str */
#endif
);

accessList		GU_createAccessList(
#ifdef PROTO
	char *		/* string */
#endif
);

BOOLEAN			GU_checkAccess(
#ifdef PROTO
	char *,		/* host */
	accessList	/* permitList */
#endif
);

#ifdef DEBUG
void			GU_printAccessList(
#ifdef PROTO
	accessList	/* list */
#endif
);
#endif /* DEBUG */



int			GI_connectWithStatus(
#ifdef PROTO
	gopherItemP     /* gi */
#endif
);

BOOLEAN			GI_copyBinaryFromNetEOF(
#ifdef PROTO
	int,		/* s */
	int,		/* outFD */
	gopherItemP,    /* gi */
	char *		/* msg */
#endif
);

BOOLEAN			GI_copyBinaryFromNetLen(
#ifdef PROTO
	int,		/* s */
	int,		/* outFD */
	gopherItemP,    /* gi */
	char *		/* msg */
#endif
);

BOOLEAN			GI_copyAsciiFromNet(
#ifdef PROTO
	int,		/* s */
	int,		/* outFD */
	gopherItemP,	/* gi */
	char *		/* msg */
#endif
);

BOOLEAN			GI_getGopherDir(
#ifdef PROTO
	int,		/* gfd */
	gopherDirP	/* d */
#endif
);

BOOLEAN			GI_noCopyItem(
#ifdef PROTO
	gopherItemP	/* gi */
#endif
);

BOOLEAN			GI_copyToFile(
#ifdef PROTO
	gopherItemP	/* gi */
#endif
);

BOOLEAN			GI_access(
#ifdef PROTO
	gopherItemP	/* gi */
#endif
);

void			GI_init(
);

void			GI_done(
);

void			GI_restart(
);


BOOLEAN			GI_process(
#ifdef PROTO
	gopherItemP	/* gi */
#endif
);

#endif	/* UTIL_H */
