/* Copyright (c) 1992 Vincent Cate
 * All Rights Reserved.
 *
 * Permission to use and modify this software and its documentation
 * is hereby granted, provided that both the copyright notice and this
 * permission notice appear in all copies of the software, derivative works
 * or modified versions, and any portions thereof, and that both notices
 * appear in supporting documentation.  This software or any derivate works
 * may not be sold or distributed without prior written approval from
 * Vincent Cate.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND VINCENT CATE DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL
 * VINCENT CATE BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
 * OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Users of this software agree to return to Vincent Cate any improvements
 * or extensions that they make and grant Vincent Cate the rights to
 * redistribute these changes.
 *
 */




/* UNFSD - copyright Mark A Shand, May 1988.
 * This software maybe be used for any purpose provided
 * the above copyright notice is retained.  It is supplied
 * as is, with no warranty expressed or implied.
 */

/*
**  Udp socket establishment routine
*/


#ifndef lint
static char sccsid[] = "@(#)init.c  1.2atd  Wed, Jun 07, 1989";
#endif  lint

#include "alexincs.h"
#include "unfsd.h"
#include "alex.h"


#ifdef EXPORTSFILE
#define DEFAULT_EXPORTSFILE EXPORTSFILE
#else
#define DEFAULT_EXPORTSFILE ALEXEXPORTSFILE 
#endif

#ifndef SYSERROR
#define SYSERROR    (-1)
#endif


int init_Log()
{
    char logbuf[100];
 
    sprintf(logbuf,"%s/alex.log",LOGDIR);
    SetLogBaseName(logbuf);
    InitReadOnlyVariables();               /* needs to be first before any Logs() */
    Log("init_Log  just warming up unfsd Log"); 
}

int makesock(port,socksz)
int port;
int socksz;
{
    struct sockaddr_in  my_sock;
    int         s;
    extern int      errno;

    bzero((char *)&my_sock, sizeof(my_sock));
    my_sock.sin_addr.s_addr = INADDR_ANY;
    my_sock.sin_family = AF_INET;
    my_sock.sin_port = htons(port);

    if ((s = socket(AF_INET, SOCK_DGRAM, 0)) == -1)
    {
        error1("makesock could not make a socket");
        return(SYSERROR);
    }
#ifdef SO_SNDBUF
    {
        int sblen, rblen;

        sblen = rblen = socksz + 1024;
        /* 1024 for rpc & transport overheads */
        if (
        setsockopt(s, SOL_SOCKET, SO_SNDBUF, &sblen, sizeof sblen) < 0
        ||
        setsockopt(s, SOL_SOCKET, SO_RCVBUF, &rblen, sizeof sblen) < 0
        )
        error1("makesock  setsockopt failed");
    }
#endif

    if (bind(s, (struct sockaddr *) &my_sock, sizeof(my_sock)) == -1) {
        error1("makesock could not bind name to socket");
        return(SYSERROR);
    }

    return s;
}

ftype ft_map[16];
int svc_euid;
int svc_egid;
int cur_gid;
int svc_ngids;
int svc_gids[NGROUPS+2];

static clnt_param   *clients = NULL;
static clnt_param   *unknown_clients = NULL;
static clnt_param   *default_client = NULL;

#define LINE_SIZE   1024

static char *
parse_opts(s, terminator, o, client_name)
char    *s;
char    terminator;
options *o;
char    *client_name;
{
    /* parse option string pointed to by s and set o accordingly */
    char    kwdbuf[LINE_SIZE];
    char    *k;

    /* skip white */
    while (isspace(*s))
        s++;
    while (*s != terminator)
    {
        k = kwdbuf;
        while (isalnum(*s) || *s == '_')
            *k++ = *s++;
        *k = '\0';
        /* process keyword */
        if (strcmp(kwdbuf, "secure") == 0)
            o->secure_port = 1;
        else if (strcmp(kwdbuf, "insecure") == 0)
            o->secure_port = 0;
        else if (strcmp(kwdbuf, "root_squash") == 0)
            o->root_squash = 1;
        else if (strcmp(kwdbuf, "no_root_squash") == 0)
            o->root_squash = 0;
        else if (strcmp(kwdbuf, "ro") == 0)
            o->read_only = 1;
        else if (strcmp(kwdbuf, "rw") == 0)
            o->read_only = 0;
        else if (strcmp(kwdbuf, "link_relative") == 0)
            o->link_relative = 1;
        else if (strcmp(kwdbuf, "link_absolute") == 0)
            o->link_relative = 0;
        else if (strcmp(kwdbuf, "map_daemon") == 0)
            o->uidmap = map_daemon;
        else if (strcmp(kwdbuf, "map_identity") == 0)
            o->uidmap = identity;
        else
            Log2("parse_opts Unknown keyword ", kwdbuf);
        while (isspace(*s))
            s++;
        if (*s == terminator)
            break;
        if (*s == ',') {
            s++;
        } else if (!isalnum(*s) && *s != '_' && *s != '\0') {
            if (client_name == NULL) {
                LogN("parse_opts Comma expected in option list for default client but got ", (int) *s);
            } else {
                ToLog(DBERROR, "parse_opts Comma expected in option list for client %s but got %c", 
                                                    client_name, *s);
            }
        }
        while (isspace(*s)) {
            s++;
        }
        if (*s == '\0' && *s != terminator) {
            LogN("parse_opts   missing terminator on option list", (int) terminator);
            return(s);
        }
    }
    if (*s != terminator)
        LogC("Internal inconsistency in parse, character '%c'.", *s);
    s++;                                        /* Skip past terminator */
    while (isspace(*s))
        s++;
    return s;
}

static int
filt_getc(f)
FILE    *f;
{
    int c;

    c = getc(f);
    if (c == '\\')
    {
        c = getc(f);
        if (c == '\n')
            return ' ';
        if (c != EOF)
            ungetc(c, f);
        return '\\';
    }
    else if (c == '#')
    {
        int lastc = c;
        while ((c = getc(f)) != '\n' && c != EOF)
            lastc = c;
        if (c == '\n' && lastc == '\\')
            c = getc(f);
    }
    return c;
}

#define CHUNK_SIZE  132 /* The 'typical' maximum length line */

static int getline(lbuf, f)
char    **lbuf;
FILE    *f;
{
    int    c;
    char  *p;
    char  *buf;
    int    sz;

    sz = CHUNK_SIZE;
    buf = malloc(sz);
    if (buf == NULL) {
        MallocDeath("getline");
    }
    p = buf;
    while ((c = filt_getc(f)) != '\n' && c != EOF) {
        if (((int) p - (int) buf) == (sz - 2)) {
            buf = realloc(buf, sz * 2);
            if (buf == NULL) {
                MallocDeath("getline 2");
            }
            p = buf + sz-2;
            sz *= 2;
        }
        *p++ = c;
    }
    if (c == EOF && p == buf) {
        free(buf);
        *lbuf = NULL;
        return 0;
    }
    *p++ = '\0';
    *lbuf = buf;
    return 1;
}

unfsd_init(argc, argv, envp)
int argc;
char    **argv, **envp;
{
    int i, n;
    FILE    *f;
    char    *lbuf;
    char    *p, *q, *r;
    char    *exportsfile = DEFAULT_EXPORTSFILE;
    struct hostent  *hent;
    clnt_param *tmp;
    char    *mount_point;

    /* options */
    int promiscuous = 0;
    char    *o_string = NULL;
    options def_opts;


    /* setup defaults */
    def_opts.uidmap = identity;
    def_opts.root_squash = 0;
    def_opts.secure_port = 1;
    def_opts.read_only = 1;
    def_opts.link_relative = 0;      /* vac changed default for Alex world */

    (void) AlexInit();

#ifdef NAMECHANGE
    InitNameChangeVars(argc, argv, envp);
#endif

    argc--; argv++;
    while (argc > 0)
    {
        if ((*argv)[0] == '-')
        {
            switch ((*argv)[1])
            {
                case 'o':
                    if ((*argv)[2] == '\0' && argc > 1)
                    {
                        argc--; argv++;
                        o_string = *argv;
                    }
                    else
                        o_string = *argv + 2;
                    break;
                case 'p':
                    promiscuous = 1;
                    break;
                case 'f':
                    if ((*argv)[2] == '\0' && argc > 1)
                    {
                        argc--; argv++;
                        exportsfile = *argv;
                    }
                    else
                        exportsfile = *argv + 2;
                    break;
                default:
                    LogC("unfsd_init Unknown option ", (*argv)[1]);
            }
        }
        else
            Log2("unfsd_init Bad argument ", *argv);
        argc--; argv++;
    }

    fh_init();

    ft_map[0] = NFNON;
    for (i = 1; i < 16; i++)
        ft_map[i] = NFBAD;
#ifdef S_IFIFO
    ft_map[ft_extr(S_IFIFO)] = NFFIFO;
#endif
    ft_map[ft_extr(S_IFCHR)] = NFCHR;
    ft_map[ft_extr(S_IFDIR)] = NFDIR;
    ft_map[ft_extr(S_IFBLK)] = NFBLK;
    ft_map[ft_extr(S_IFREG)] = NFREG;
    ft_map[ft_extr(S_IFLNK)] = NFLNK;
    ft_map[ft_extr(S_IFSOCK)] = NFSOCK;

    /*  umask(0); */

    svc_euid = geteuid();
    svc_ngids = getgroups(NGROUPS, svc_gids);
    /* Does this always include gid and egid? I don't know. Play it safe */
    if (svc_ngids < 0)
        svc_ngids = 0;
    n = getgid();
    for (i = 0; i < svc_ngids; i++)
        if (svc_gids[i] == n)
            break;
    if (i == svc_ngids)
        svc_gids[svc_ngids++] = n;
    n = svc_egid = getegid();
    for (i = 0; i < svc_ngids; i++)
        if (svc_gids[i] == n)
            break;
    if (i == svc_ngids)
        svc_gids[svc_ngids++] = n;
    cur_gid = svc_gids[0];
    if (o_string != NULL)
        parse_opts(o_string, '\0', &def_opts, NULL);

    if (!promiscuous && (exportsfile != NULL)) {
        if ((f = fopen(exportsfile, "r")) == NULL) {
            Log2("unfsd_init Could not open ", exportsfile);
            exit(1);
        }
        /* process exports file */
        while (getline(&lbuf, f)) {
            p = lbuf;
            while (isspace(*p))
                p++;
            q = p;
            /* file-system name */
            while (*q != '\0' && !isspace(*q)) {
                q++;
            }
            if ((mount_point = malloc(q-p+1)) == NULL) {
                MallocDeath("unfsd_init");
            }
            for (r = mount_point; p < q;) {
                *r++ = *p++;
            }
            *r = '\0';
            p = q;
            while (isspace(*p)) {
                p++;
            }
            while (*p != '\0') {
                q = p;
                /* host name */
                while (*q != '\0' && !isspace(*q) && *q != '(')
                q++;
                if ((tmp = (clnt_param *) malloc(sizeof *tmp)) == NULL
                || (tmp->clnt_name = malloc(q-p+1)) == NULL)
                MallocDeath("unfsd_init");
                for (r = tmp->clnt_name; p < q;)
                    *r++ = *p++;
                *r = '\0';

                /* Finish parsing options */
                tmp->o = def_opts;
                while (isspace(*p))
                    p++;
                if (*p == '(')
                p = parse_opts(p+1, ')', &(tmp->o), tmp->clnt_name);

                tmp->mount_point = mount_point;
                
                if ((hent = gethostbyname(tmp->clnt_name)) == NULL)
                {
                    char *reason;
                    switch (h_errno) {
#ifdef HOST_NOT_FOUND                           /* Only on 4.3 systems */
                    case HOST_NOT_FOUND:
                        reason = "Authoritive -- the host exists only in your imagination.";
                        break;
                    case TRY_AGAIN:
                        reason = "Non-Authoritive -- the host might exist."; break;
                    case NO_RECOVERY:
                        reason = "Non-recoverable error."; break;
                    case NO_ADDRESS:
                        reason = "Valid host name, but no address."; break;
#endif
                    default:
                        reason = "Unknown reason.";
                    }
                    Log3("Unknown host  in  file ", tmp->clnt_name, exportsfile);
                    tmp->next = unknown_clients;
                    unknown_clients = tmp;
                } else {
                    /* This should be changed to handle the address list under 4.3 */
                    tmp->clnt_addr = *((struct in_addr *)hent->h_addr);
                    tmp->next = clients;            /* Add to client list */
                    clients = tmp;
                }
            }
            free(lbuf);
        }
        fclose(f);
    }
    if (promiscuous) {
        if ((tmp = (clnt_param *) malloc(sizeof *tmp)) == NULL)
            MallocDeath("unfsd_init");
        tmp->clnt_name = NULL;
        tmp->mount_point = CACHEDIRVAR;                      /* vac */
        default_client = tmp;
        tmp->o = def_opts;
    }
}

int
_in_gid_set(gid)
int gid;
{
    int i;

    for (i = 0; i < svc_ngids; i++)
        if (svc_gids[i] == gid)
        {
            cur_gid = gid;
            return 1;
        }
    return 0;
}

clnt_param *knownclient(rqstp)
struct svc_req *rqstp;
{
    clnt_param  **cpp, *cp;
    int IncomingPort;

    /* find host parameter struct */
    for (cpp = &clients; *cpp != NULL; cpp = &((*cpp)->next))
    {
        if ((*cpp)->clnt_addr.s_addr == svc_getcaller(rqstp->rq_xprt)->sin_addr.s_addr)
        {
            cp = *cpp;
            if (cp != clients)
            {
                /* Move to front */
                *cpp = cp->next;
                cp->next = clients;
                clients = cp;
            }
            goto found_it;
        }
    }

    /* Check the list of clients we didn't know at start-up. */
    {
        struct hostent  *hent;
/*      clnt_param *tmp; */
        for (cpp = &unknown_clients; (cp = *cpp) != NULL;
             cpp = &((*cpp)->next)) {
            if ((hent = gethostbyname(cp->clnt_name)) != NULL) {
                ToLog(DBFTP, "clnt_param Found previously unknown host %s\n", cp->clnt_name);
                /* First remove from the unknown_clients list. */
                *cpp = cp->next;

                cp->clnt_addr = *((struct in_addr *)hent->h_addr);
                cp->next = clients;         /* Add to front of client list. */
                clients = cp;

                if (cp->clnt_addr.s_addr == svc_getcaller(rqstp->rq_xprt)->sin_addr.s_addr)
                    goto found_it;
            }
        }
    }

    if (default_client != NULL)
        cp = default_client;
    else
    {
        LogN("clnt_param Access attempt by unknown client ",       /* XXX better as %08X */
            ntohl(svc_getcaller(rqstp->rq_xprt)->sin_addr.s_addr));
        return NULL;
    }
    found_it:
    /* check request originated on a privileged port */
    IncomingPort = ntohs(svc_getcaller(rqstp->rq_xprt)->sin_port);
    if (IncomingPort >= IPPORT_RESERVED && cp->o.secure_port) {
        ToLog(DBERROR, "clnt_param ERROR NFS request originated on insecure port %d  %d \n",
            IncomingPort, ntohl(svc_getcaller(rqstp->rq_xprt)->sin_addr.s_addr)); 

        return NULL; 
    }
    return cp;
}

/*
 * Local variables:
 *  compile-command: "make"
 *  tab-width: 4
 *  comment-column: 48
 *  c-indent-level: 4
 *  c-continued-statement-offset: 4
 *  c-continued-brace-offset: -4
 *  c-brace-offset: 0
 *  c-brace-imaginary-offset: 0
 *  c-argdecl-indent: 0
 *  c-label-offset: -4
 * End:
 */
