#! /bin/sh
# A much expanded version of the one-liner script posted by 
# cedman@golem.ps.uci.edu (Carl Edman) to comp.unix.shell.
# Mark Moraes, University of Toronto.
ARCHIE=${ARCHIE-quiche.cs.mcgill.ca}
case $# in
0)	echo "Usage: $0 [-regex|-subcase|-sub] [-status] [-max maxhits] [-cmd archie_command] searchstring ..." >&2; exit 1;;
esac
timesort="cat"
(
 echo "unset status"
 echo "set maxhits 100"
 echo "set search exact"
 echo "set sortby none"
 while :
 do
	case "$1" in
	-e|-exact)	echo "set search exact"; shift;;
	-r|-regex) echo "set search regex"; shift;;
	-c|-subcase) echo "set search subcase"; shift;;
	-s|-sub) echo "set search sub"; shift;;
	-status) echo "set status"; shift;;
	-m|-max)	echo "set maxhits $2"; shift; shift;;
	-cmd)	echo "$2"; shift; shift;;
	-t)	timesort="sort +2nr -3 +0Mr -1 +1nr -2"; shift;;
	*)	break;;
	esac
 done
 for i
 do
	echo "prog $i" 
 done
) |
	rsh $ARCHIE -l archie "" |
	awk '/Host/ {
		host = $2;
	}
	/Last/ {
		cury = $6;
	}
	/Location:/ {
		dir = $2;
	}
	$0 ~ /FILE/ || $0 ~ /DIRECTORY/ {
		if (index($6, ":"))
			year = cury;
		else year = $6;
			printf "%3s %2s %4s %7s /%s:/%s/%s\n", \
				$4, $5, year, $3, host, dir, $7;
	}' |
	$timesort
