#include "protos.h"

/*
 * This software is Copyright (C) 1988 by Steven Dorner and the
 * University of Illinois Board of Trustees.  No warranties of any
 * kind are expressed or implied.  No support will be provided.
 * This software may not be redistributed for commercial purposes.
 * You may direct questions to nameserv@uiuc.edu
 */

static int IsProxy __P((QDIR, char *));

extern int LocalUser;

/*
 * check if the logged in user is allowed to add entries
 */
int 
CanAddEntries()
{
	return (AmHero);
}

/*
 * can the current user see the field in question?
 */
int 
CanSee(dir, fd, suppress)
	QDIR dir;
	FDESC *fd;
	int suppress;
{
	if (AmHero)
		return (1);	/* the supreme being */

	if (User != NULL)
	{
		if (!stricmp(FINDVALUE(dir, F_ALIAS), UserAlias))
			return (1);	/* user's own record */

		if (IsProxy(dir, UserAlias))
			return (1);	/* (one of) the user's proxy(ies) */
	}
	if (suppress && !fd->fdForcePub)
		return (0);
	if (LocalUser)
		return (fd->fdPublic || fd->fdLocalPub);
	return (fd->fdPublic && ! fd->fdLocalPub);
}

/*
 * is the given alias a proxy of the given dir
 */
static int 
IsProxy(dir, whichAlias)
	QDIR dir;
	char *whichAlias;
{
	char	*token;
	char	proxies[2048];

	strcpy(proxies, FINDVALUE(dir, F_PROXY));
	for (token = strtok(proxies, " \t,\n"); token && *token; token = strtok((char *) 0, " \t,\n"))
		if (!stricmp(whichAlias, token))
			return (1);
	return (0);
}

/*
 * can the current user do a lookup using the field in question?
 */
int 
CanLookup(fd)
	FDESC *fd;
{
	return (AmOpr || AmHero || fd->fdLookup);
}

/*
 * can the current user change anything in an entry?
 */
int 
UserCanChange(dir)
	QDIR dir;
{
	if (AmHero)
		return (1);	/* the supreme being */

	if (!User)
		return (0);	/* nobody logged in */

	if (!stricmp(FINDVALUE(dir, F_ALIAS), UserAlias))
		return (1);	/* user's own entry */

	if (IsProxy(dir, UserAlias))
		return (1);	/* (one of) the user's proxy(ies) */

	if (AmOpr)
	{
		if (*FINDVALUE(dir, F_HERO))
			return (0);	/* oper not allowed to edit hero/opr */
		return (1);
	}

	return (0);		/* sorry... */
}

/*
 * can the current user change a field in an entry?
 */
int 
CanChange(dir, fd)
	QDIR dir;
	FDESC *fd;
{
	int	isPerson;

	if (AmHero)
		return (1);	/* the supreme being */

	if (!User)
		return (0);	/* nobody logged in */

	isPerson = *FINDVALUE(dir, F_TYPE) == 'p';

	if (!stricmp(FINDVALUE(dir, F_ALIAS), UserAlias))
		return (fd->fdChange || fd->fdNoPeople && !isPerson);

	if (IsProxy(dir, UserAlias) || AmOpr)
		return (fd->fdChange || fd->fdNoPeople && !isPerson);

	return (0);		/* sorry... */
}

/*
 * Can the logged in user delete any entries at all?
 */
int 
UserCanDelete()
{
	return (AmHero);
}

/*
 * Can the logged in user delete a particular entry?
 */
int 
CanDelete(dir)
	QDIR dir;
{
	/* no one may delete the Hero entry */
	/* return(AmHero && stricmp(Hero, FINDVALUE(dir,F_ALIAS))); */
	return (AmHero);
}
