#include "protos.h"

/*
 * This software is Copyright (C) 1988 by Steven Dorner and the
 * University of Illinois Board of Trustees.  No warranties of any
 * kind are expressed or implied.  No support will be provided.
 * This software may not be redistributed for commercial purposes.
 * You may direct questions to nameserv@uiuc.edu
 */

OPTION	OptionList[] =
{
	"echo", 0,	/* echo commands before execution */
	"limit", 0,	/* limit the number of entries a command may affect */
	"verbose", 0,	/* I don't remember */
	"addonly", 0,	/* do not change fields that contain information */
	0, 0
};

static OPTION *FindOption __P((char *));
static void SetOption __P((OPTION *, char *));

/*
 * do a set command
 */
void 
DoSet(argp)
	ARG *argp;
{
	OPTION	*option;
	int	successes = 0;

	argp = argp->aNext;
	if (!argp)
	{
		/* list the current options */
		for (option = OptionList; option->opName; option++)
			DoReply(-LR_OK, "%s:%s", option->opName,
			      option->opValue ? (*option->opValue ?
				       option->opValue : "on") : "off");
		DoReply(LR_OK, "Done.");
	} else
	{
		for (; argp; argp = argp->aNext)
		{
			if (option = FindOption(argp->aFirst))
			{
				successes++;
				if (argp->aType & VALUE2)
					SetOption(option, argp->aSecond);
				else if (argp->aType & EQUAL)
					SetOption(option, "off");
				else
					SetOption(option, "on");
			} else
				DoReply(-LR_OPTION, "%s:unknown option", argp->aFirst);
		}
		if (successes)
			DoReply(LR_OK, "Done.");
		else
			DoReply(LR_OPTION, "No option recognized.");
	}
}

/*
 * find an option in the list
 */
static OPTION	*
FindOption(name)
	char *name;
{
	OPTION	*option;

	for (option = OptionList; option->opName; option++)
		if (!strcmp(option->opName, name))
			return (option);

	return (NULL);
}

/*
 * set an option to a value
 */
static void 
SetOption(option, value)
	OPTION *option;
	char *value;
{
	char	*make_str();

	if (option->opValue)
		free(option->opValue);

	if (!value || !strcmp(value, "off") || !(*value))
	{
		option->opValue = NULL;
		if (OP_VALUE(VERBOSE_OP))
			DoReply(LR_PROGRESS, "%s=off", option->opName);
	} else if (!strcmp(value, "on"))
	{
		option->opValue = make_str("");
		if (OP_VALUE(VERBOSE_OP))
			DoReply(LR_PROGRESS, "%s=on", option->opName);
	} else
	{
		option->opValue = make_str(value);
		if (OP_VALUE(VERBOSE_OP))
			DoReply(LR_PROGRESS, "%s=%s", option->opName, value);
	}
}

/*
 * initialize the options
 */
void 
InitializeOptions()
{
	SetOption(&OptionList[LIMIT_OP], "2");
}
