/*
 * keys.h: header for keys.c 
 *
 * Copyright 1990 Michael Sandrof
 * Copyright 1997 EPIC Software Labs
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 */

#ifndef __keys_h__
#define __keys_h__

enum KEY_TYPES {
	BACKSPACE,
	BACKWARD_CHARACTER,
	BACKWARD_HISTORY,
	BACKWARD_WORD,
	BEGINNING_OF_LINE,
	BLINK,
	BOLD,
	CLEAR_SCREEN,
	COMMAND_COMPLETION,
	CPU_SAVER,
	DELETE_CHARACTER,
	DELETE_NEXT_WORD,
	DELETE_PREVIOUS_WORD,
	DELETE_TO_PREVIOUS_SPACE,
	END_OF_LINE,
	ERASE_LINE,
	ERASE_TO_BEG_OF_LINE,
	ERASE_TO_END_OF_LINE,
	FORWARD_CHARACTER,
	FORWARD_HISTORY,
	FORWARD_WORD,
	HIGHLIGHT_OFF,
/* These MUST be in order and must be together... */
	META1_CHARACTER,
	META2_CHARACTER,
	META3_CHARACTER,
	META4_CHARACTER,
	META5_CHARACTER,
	META6_CHARACTER,
	META7_CHARACTER,
	META8_CHARACTER,
	META9_CHARACTER,
	META10_CHARACTER,
	META11_CHARACTER,
	META12_CHARACTER,
	META13_CHARACTER,
	META14_CHARACTER,
	META15_CHARACTER,
	META16_CHARACTER,
	META17_CHARACTER,
	META18_CHARACTER,
	META19_CHARACTER,
	META20_CHARACTER,
	META21_CHARACTER,
	META22_CHARACTER,
	META23_CHARACTER,
	META24_CHARACTER,
	META25_CHARACTER,
	META26_CHARACTER,
	META27_CHARACTER,
	META28_CHARACTER,
	META29_CHARACTER,
	META30_CHARACTER,
	META31_CHARACTER,
	META32_CHARACTER,
	META33_CHARACTER,
	META34_CHARACTER,
	META35_CHARACTER,
	META36_CHARACTER,
	META37_CHARACTER,
	META38_CHARACTER,
	META39_CHARACTER,
/* If they arent, everything will break.  Got it? */
	NEXT_WINDOW,
	NOTHING,
	PARSE_COMMAND,
	PREVIOUS_WINDOW,
	QUIT_IRC,
	QUOTE_CHARACTER,
	REFRESH_INPUTLINE,
	REFRESH_SCREEN,
	REVERSE,
	SCROLL_BACKWARD,
	SCROLL_END,
	SCROLL_FORWARD,
	SCROLL_START,
	SELF_INSERT,
	SEND_LINE,
	SHOVE_TO_HISTORY,
	STOP_IRC,
	SWAP_LAST_WINDOW,
	SWAP_NEXT_WINDOW,
	SWAP_PREVIOUS_WINDOW,
	SWITCH_CHANNELS,
	TOGGLE_INSERT_MODE,
	TOGGLE_STOP_SCREEN,
	TRANSPOSE_CHARACTERS,
	TYPE_TEXT,
	UNCLEAR_SCREEN,
	UNDERLINE,
	UNSTOP_ALL_WINDOWS,
	YANK_FROM_CUTBUFFER,
	NUMBER_OF_FUNCTIONS
};

/* I hate typedefs... */
typedef void (*KeyBinding) (char, char *);

/* KeyMap: the structure of the irc keymaps */
typedef struct
{
	enum KEY_TYPES	key_index;
		char	*stuff;
		char	changed;
		char	*filename;
}	KeyMap;


/* KeyMapNames: the structure of the keymap to realname array */
typedef struct
{
	char	*name;
	KeyBinding func;
}	KeyMapNames;

/* 
 * !!!DONT!!! change this number on a whim!  You could break stuff.  It
 * is defined here so that if/when we want to add more key maps, it will
 * be real easy to change all the stuff that is dependant on how many
 * key maps there are.  However, there is no support for more then 10
 * keymaps in the code!  You have been warned!
 */
#define MAX_META 39
#define NUM_KEYMAPS MAX_META + 1

typedef KeyMap		*KeyTable[256];

extern	KeyTable	*keys[NUM_KEYMAPS];
extern	KeyMapNames 	key_names[];

	void		save_bindings 		(FILE *, int);
	void		bindcmd 		(char *, char *, char *);
	void    	rbindcmd 		(char *, char *, char *);
	void    	parsekeycmd 		(char *, char *, char *);
	void    	type 			(char *, char *, char *);
	void		init_keys_1 		(void);
	void		remove_bindings		(void);
	void		unload_bindings		(const char *);

#endif /* _KEYS_H_ */
