/* -*- C -*-
 *
 * Program:	ximap
 * File:        login.c -- Creates a login widget and gets the username
 *                         and password to log on to the remote mail
 *                         server.
 *
 * Author:	Kevin Brock
 *	        Symbolic Systems Resources Group
 *		Stanford University
 *              MSOB x241
 *		Stanford, CA 94305
 *		Internet: brock@CAMIS.Stanford.Edu
 *
 * Date:	07 September 1992
 *
 * Copyright 1992 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and
 * THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL WARRANTIES, EXPRESS OR 
 * IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN NO EVENT 
 * SHALL THE LELAND STANFORD JUNIOR UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT 
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, 
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) 
 * OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 *
 */
#include <string.h>
#include <netdb.h>
#include <signal.h>
#include <ctype.h>

#include <stdio.h>
#include <memory.h>
#include <pwd.h>

#include <Client/osdep.h>
#include <Client/mail.h>
#include <Client/misc.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/keysymdef.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Box.h>
#ifdef MOTIF
#include <X11/Xm/Text.h>
#else
#include <X11/Xaw/Text.h>
#include <X11/Xaw/AsciiText.h>
#endif

#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>


#include "structures.h"

#include "message.h"
#include "globals.h"
#include "buttons.h"
#include "resources.h"
#include "textutil.h"
#include "util.h"
#include "ximap.h"

#define ABORTED -1

static void gotoPassword();
static void done();
static void gotoName();
static void getString();
void quitCallback();
void okCallback();

typedef struct _XbPassword
{
    char *nmd;
    char *pwd;
    char *host;

    int  isPassword;
    Widget lg_wid;
    Widget nm_wid;
    Widget ps_wid;
    
} PASS_DATA;

PASS_DATA pwd;

static void beep(w, event)
     Widget w;
     XEvent* event;
{
  XBell(XtDisplay(w), 100);
}

static void blockout(w, event, params, num_params)
     Widget w;
     XEvent* event;
     String* params; 
     int num_params;
{
 ;
}

static void abortAct();
static XtActionsRec actionsTable[] = {
  {"beep", beep},
  {"blockout", blockout},
  {"gotoPassword", gotoPassword},
  {"gotoName", gotoName},
  {"done", done},
  {"getString", getString},
  {"abort_login", abortAct}
};

static char nameTranslations[] = 
 "<ButtonPress>: gotoName()          \n\
  <Key>Escape:   abort_login() \n\
  <Key>Return:   gotoPassword()      \n\
  Ctrl<Key>N:    beep()                       \n\
  Ctrl<Key>J:    beep()                       \n\
  Ctrl<Key>O:    beep()                       \n\
  Ctrl<Key>M:    beep()";

static char passwdTranslations[] = 
 "<ButtonPress>: gotoPassword() \n\
  <Key>Return:   done()     \n\
  <Key>:         getString()";

extern Widget toplevel;
extern Widget telemetry;
extern XtAppContext app_context;
extern MAILSESSION id;

Widget
InitLogin ( parent )
     Widget parent;
{
  Arg warg[ARGLISTSIZE];
  int n = 0;
  XFontStruct    *font;
  XtTranslations name_trans, passwd_trans;
 
  char *name;
 
  Widget LoginPanes;
  Widget  PasswordForm, Name;
  Widget LoginButtonBox, QuitButton, OKButton;

  XtAppAddActions(app_context, actionsTable, XtNumber(actionsTable));

  name_trans = XtParseTranslationTable(nameTranslations);
  passwd_trans = XtParseTranslationTable(passwdTranslations);

  memset(warg, 0, sizeof(warg));

  name = getName(getCurhost());
 
  XtSetArg(warg[n], XtNtitle, "Login"); n++;
  pwd.lg_wid = XtCreatePopupShell("login_shell",
				  wmShellWidgetClass,
				  parent, warg, n);  n = 0;

  LoginPanes = XtCreateManagedWidget("loginPanes", panedWidgetClass,
				    pwd.lg_wid, warg, n); n = 0;

  XtSetArg(warg[n], XtNdefaultDistance, 4); n++;
  PasswordForm = XtCreateManagedWidget("passwordForm", formWidgetClass,
				       LoginPanes, warg, n); n = 0;

  XtSetArg(warg[n], XtNshowGrip, FALSE); n++;
  LoginButtonBox = XtCreateManagedWidget("loginButtonBox", boxWidgetClass,
					 LoginPanes, warg, n); n = 0;

  XtSetArg(warg[n], XtNlabel , "OK" ); n++;
  OKButton = XtCreateManagedWidget("okbutton", commandWidgetClass,
				   LoginButtonBox, warg, n); n = 0;
  XtAddCallback(OKButton, XtNcallback, okCallback, pwd.lg_wid);

  XtSetArg(warg[n], XtNlabel ,"Cancel" ); n++;
  QuitButton = XtCreateManagedWidget("quitbutton", commandWidgetClass,
				     LoginButtonBox, warg, n); n = 0;
  XtAddCallback(QuitButton, XtNcallback, quitCallback, pwd.lg_wid);

  XtSetArg(warg[n], XtNlabel , "  name  " ); n++;
  XtSetArg(warg[n], XtNjustify , XtJustifyLeft ); n++;
  XtSetArg(warg[n], XtNborderWidth, 0); n++;
  Name = XtCreateManagedWidget("name", labelWidgetClass,
			       PasswordForm, warg, n); n = 0;

  XtSetArg(warg[n], XtNstring, name); n++;
  XtSetArg(warg[n], XtNfromHoriz, Name); n++;
  XtSetArg(warg[n], XtNborderWidth, 0); n++;
  XtSetArg(warg[n], XtNeditType, XawtextEdit); n++;
  pwd.nm_wid = XtCreateManagedWidget("nameText",
				     asciiTextWidgetClass,
				     PasswordForm, warg, n); n = 0;
  XtOverrideTranslations( pwd.nm_wid, name_trans);
  XtSetArg(warg[0], XtNfont, &font); n++ ;
  XtGetValues(pwd.nm_wid, warg, 1); n = 0;
  XtSetArg(warg[0], XtNheight,
	   (font->max_bounds.ascent + font->max_bounds.descent) + 6);n++ ;
  XtSetValues(pwd.nm_wid, warg, 1); n = 0;

  /* We shouldn't need to refer to the password label ever again... */
  XtSetArg(warg[n], XtNlabel , "password" ); n++;
  XtSetArg(warg[n], XtNjustify, XtJustifyLeft); n++;
  XtSetArg(warg[n], XtNfromVert, pwd.nm_wid); n++;
  XtSetArg(warg[n], XtNborderWidth, 0); n++;
  XtCreateManagedWidget("password", labelWidgetClass,
			PasswordForm, warg, n); n = 0;

  XtSetArg(warg[n], XtNtranslations, passwd_trans);  n++;
  XtSetArg(warg[n], XtNfromVert, pwd.nm_wid); n++;
  XtSetArg(warg[n], XtNfromHoriz, Name); n++;
  XtSetArg(warg[n], XtNborderWidth, 0); n++;
  XtSetArg(warg[n], XtNstring, ""); n++;
  XtSetArg(warg[n], XtNeditType, XawtextAppend); n++;
  pwd.ps_wid  = XtCreateManagedWidget("passwordText",
				      asciiTextWidgetClass,
				      PasswordForm, warg, n); n = 0;
  XtSetArg(warg[0], XtNfont, &font); n++ ;
  XtGetValues(pwd.ps_wid, warg, 1); n = 0;
  XtSetArg(warg[0], XtNheight,
	   (font->max_bounds.ascent + font->max_bounds.descent) + 6); n++ ;
  XtSetValues(pwd.ps_wid, warg, 1); n = 0;

  return (pwd.lg_wid);
}

static int            doneWithLogin; 
static char           *ptemp;
static int            plength;

int getpwdt(host, trial, unm, passwd)
     char *host;
     short trial;
     char *unm;
     char *passwd;
{
    XEvent theEvent;
    Display* dp;
    Boolean NotMapped;
    char *c1;
    char *c2;
    char *name;
    Widget w;
    
    name = cpystr(id.username);
    putHost(host);
    setCurhost(host);

    if ( !(loggedIn(host)) )
    {
	setName(host, name);        	/* current user is this name */
	w = InitLogin(toplevel);
	ptemp = NULL;
	plength = 0;
	
	pwd.pwd = passwd;
	pwd.nmd = unm;
	pwd.host = cpystr(host);
	
	pwd.isPassword = FALSE;
	
	XtPopup(pwd.lg_wid, XtGrabNone);
	
	while (!XtIsRealized(pwd.lg_wid))
	    ; /* VOID */
	
	NotMapped = True;
	while ( NotMapped == True )
	{
	    dp = XtDisplay(pwd.nm_wid);
	    XNextEvent(dp, &theEvent);
	    if ( theEvent.xany.type == MapNotify )
	    {
		NotMapped = False;
	    }
	    XtDispatchEvent(&theEvent); 
	}
	
	dp = XtDisplay(pwd.nm_wid);
	
	gotoName( w, (XEvent*) NULL );
	
	doneWithLogin = FALSE;
	while ( doneWithLogin == FALSE )
	{
	    XtAppNextEvent(app_context, &theEvent);
	    XtDispatchEvent(&theEvent); 
	}
	if (pwd.lg_wid)
	    XtDestroyWidget(pwd.lg_wid);
	
	if (doneWithLogin == ABORTED)
	{
	    return 0;
	}
	else
	{
	    return 1;
	}
    }
    else
    {
	pwd.lg_wid = (Widget) NULL;
	c1 = getPassword(host);
	c2 = getName(host);
	
	strcpy( passwd, c1 );
	/* Zero it out. */
	memset(c1, '\0', strlen(c1));
	strcpy( unm, c2 );
	quitCallback( toplevel, (void*) NULL, &theEvent ); 
	fs_give(&c1);
	fs_give(&c2);
	return(1); /* SUCCESS */
    }
}

  static void
getString( w, event)
     Widget w;
     XEvent* event;
{
  char			theKeyBuffer[MAILTMPLEN + 1];
  char                  tmpbuf[MAILTMPLEN + 1];

  char *temp;

  XComposeStatus        theComposeStatus;
  KeySym		theKeySym;

  memset(theKeyBuffer, 0, (MAILTMPLEN + 1));
  memset(tmpbuf, 0, (MAILTMPLEN + 1));
 
  if ( ptemp == NULL )
    {
      ptemp = pwd.pwd;
      memset(ptemp, 0, MAILTMPLEN);
    }

  XLookupString(event, theKeyBuffer, MAILTMPLEN, &theKeySym, &theComposeStatus);
  if (theKeySym == XK_Shift_R
      || theKeySym == XK_Shift_L
      || theKeySym == XK_Control_R
      || theKeySym == XK_Control_L
      || theKeySym == XK_Alt_L
      || theKeySym == XK_Alt_R)
    {
      ;
    }
  else if (theKeySym != XK_BackSpace && theKeySym != XK_Delete)
    {
      *ptemp++ = theKeySym;
      plength++;
      
      XbTextAppend( pwd.ps_wid, "X");
    }
  else if ( plength > 0 )
    {
      *--ptemp = '\0';
      plength--;
      temp = XbTextCopyBuffer( pwd.ps_wid );
      if(temp)
      {
	  temp[ strlen(temp) - 1 ] = '\0';
	  XbTextClearBuffer(pwd.ps_wid);
	  XbTextAppend(pwd.ps_wid, temp);
      }
    }
  else 
    {
      beep(w, (XEvent*) NULL);
    }
}


  static void
gotoPassword( w, ev )
  Widget w;
  XEvent *ev;
{
  XawTextDisplayCaret( pwd.nm_wid, FALSE);
  XGrabKeyboard(XtDisplay(toplevel),
		XtWindow(pwd.ps_wid), False,
		GrabModeAsync, GrabModeAsync, CurrentTime);
  XawTextDisplayCaret( pwd.ps_wid, TRUE);
  pwd.isPassword = TRUE;
}
  static void
gotoName( w, ev )
  Widget w;
  XEvent *ev;
{
  XawTextDisplayCaret( pwd.ps_wid, FALSE);
  XGrabKeyboard(XtDisplay(toplevel),
		XtWindow(pwd.nm_wid), False, 
		GrabModeAsync, GrabModeAsync, CurrentTime);
  XawTextDisplayCaret( pwd.nm_wid, TRUE);
  pwd.isPassword = FALSE;
}

  static void
done(  w, ev )
  Widget w;
  XEvent *ev;
{ 
  char *temp  = fixnl( (char*) XbTextCopyBuffer( pwd.nm_wid ));

  strcpy ( pwd.nmd, temp );

  setName(pwd.host,pwd.nmd);
  setPassword(pwd.host, pwd.pwd);

  pwd.nmd = NULL;
  pwd.pwd = NULL;

  ptemp = NULL;

  doneWithLogin = TRUE;
  XUngrabKeyboard(XtDisplay(toplevel), CurrentTime);
}

  void
okCallback( w, p, e)
  Widget w;
  void* p;
  XEvent* e;
{
  done( w, e);
}

  void
quitCallback( w, p, e)
  Widget w;
  void* p;
  XEvent* e;
{
  if (pwd.nmd) *(pwd.nmd) = '\0';
  if (pwd.pwd)  *(pwd.pwd) = '\0';

  doneWithLogin = ABORTED;
}

static void abortAct( w, e )
     Widget w;
     XEvent *e;
{
    quitCallback( w, NULL, e );
}
