/* -*- C -*-
 *
 * Program:	ximap
 * File:        mailbox.h -- declarations for functions to manage mailboxes.
 *
 * Author:	Kevin Brock
 *	        Symbolic Systems Resources Group
 *		Stanford University
 *              MSOB x241
 *		Stanford, CA 94305
 *		Internet: brock@CAMIS.Stanford.Edu
 *
 * Date:	07 September 1992
 *
 * Copyright 1992 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and
 * THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL WARRANTIES, EXPRESS OR 
 * IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN NO EVENT 
 * SHALL THE LELAND STANFORD JUNIOR UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT 
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, 
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) 
 * OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 *
 */
#ifndef __ximap_mailbox_h
#define __ximap_mailbox_h

extern void addMailboxActions();

extern void closeMailBox();
extern void checkMailBox();
extern void toggleDebug();

extern void BrowseSelectedHeaders();

extern void fetchNodeInfo();
extern void AddBrowser();
extern void makeDefaultMapping();
extern void makeZoomMapping();

extern int countNew();

extern Widget createMailbox();

extern void check_menus();
extern void check_mailboxes();

extern void checkMailboxes();

/* Button states */
#define NOSELECTION ((unsigned int) 1 << 1)
#define DEFAULTSTATE ((unsigned int) 1 << 2)

#endif /* __ximap_mailbox_h */

