/*
 * main.c -- process entry point for the MADE Email Shell
 * 
 * 9-8-92    ekr@eitech.com                          v1.1
 * 27-Jun-92 weber@eitech.com marked ServiceMail(tm) v1.0
 * 25-May-92 weber@eitech.com created
 *
 * Copyright (c)  1992 Enterprise Integration Technologies Corporation
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name of
 * Enterprise Integration Technologies Corporation may not be used in any 
 * advertising or publicity relating to the software without the specific, 
 * prior written permission of Enterprise Integration Technologies Corporation.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL ENTERPRISE INTEGRATION TECHNOLOGIES CORPORATION  BE
 * LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF
 * ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY
 * THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#include <signal.h>

#include "mesh.h"

cleanup(signum) 
     int signum;
{
  signal(signum, SIG_DFL);
  kill(getpid(), signum);
}

main(argc, argv)
     int argc;
     char **argv;
{
  signal(SIGINT, cleanup);
  signal(SIGILL, cleanup);
  signal(SIGTRAP, cleanup);
  signal(SIGIOT, cleanup);
  signal(SIGEMT, cleanup);
  signal(SIGFPE, cleanup);
  signal(SIGBUS, cleanup);
  signal(SIGSEGV, cleanup);
  signal(SIGTERM, cleanup);
  signal(SIGXCPU, cleanup);
  ProcessArguments(argc, argv);
  return 0;
}

ProcessArguments(argc, argv)
     int argc;
     char **argv;
{
  while (--argc && **++argv == '-') {
    switch (*++*argv) {
    default:
      usage();
    }
  }
  if (argc) {
    while (argc--) {
      FILE *stream;
      stream = fopen(*argv++, "r");
      if (stream == NULL)
	fprintf(stderr, "%s: could not open %s, ignoring.\n",
		PROGRAM_NAME, argv[-1]);
      else HandleMessage(stream);
    }
  }
  else HandleMessage(stdin);
}

usage() {
  fprintf(stderr, "Usage:  %s [filename] ...\n", PROGRAM_NAME);
  exit(1);
}

ErrorExit(txt)
     char *txt;
{
  ErrorMsg(txt);
  exit(2);
}

ErrorMsg(txt)
     char *txt;
{
  if (txt) fprintf(stderr, "%s: %s\n", PROGRAM_NAME, txt);
}
