/*
 * startjob.c -- functions to invoke services
 *
 * 9-8-92    ekr@eitech.com                          v1.1
 * 27-Jun-92 weber@eitech.com marked ServiceMail(tm) v1.0
 * 25-May-92 weber@eitech.com created
 *
 * Copyright (c)  1992 Enterprise Integration Technologies Corporation
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name of
 * Enterprise Integration Technologies Corporation may not be used in any 
 * advertising or publicity relating to the software without the specific, 
 * prior written permission of Enterprise Integration Technologies Corporation.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL ENTERPRISE INTEGRATION TECHNOLOGIES CORPORATION  BE
 * LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF
 * ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY
 * THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#include <tcl.h>

#include "mesh.h"

#ifndef MESHINIT
#define MESHINIT "~/src/mesh/init.tcl"
#endif
#ifndef MESHCONFIG
#define MESHCONFIG "~/src/mesh/config.tcl"
#endif

StartJob(m)
     struct MessageInfo *m;
{
  int i;
  char *s, *cmd, *switches;
  char buf[1024], env[1024];     /* this really should be malloc'ed and realloc'ed */
  char *strtok();
  int mailout();
  
  Tcl_Interp *interp, *Tcl_CreateInterp();
  
  s = m->service ? m->service : m->subject;
  sprintf(env, "{FROM \"%s\" REPLYTO \"%s\" SERVICE \"%s\" MESSAGEID \"%s\"}",
	  m->from, m->reply_to ? m->reply_to : m->from, s ? s : "unknown", m->id ? m->id : "");
  s = strtok(s, " \t\n");
  
  interp = Tcl_CreateInterp();
  Tcl_CreateCommand(interp, "mailout", mailout, (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
  if (Tcl_EvalFile(interp, MESHINIT) != TCL_OK) {
    fputs(interp->result, stderr); fputc('\n', stderr);
    ErrorExit("initialization problem");
  }
  else if (Tcl_EvalFile(interp, MESHCONFIG) != TCL_OK) {
    fputs(interp->result, stderr); fputc('\n', stderr);
    ErrorExit("services configuration problem");
  }
  else {
    switches = strtok(NULL, "[\n"); /* the bracket is for security */
    BuildTclBodyRep(m, buf);
    if (Tcl_VarEval(interp, "invoke-service ", s, " {", switches ? switches : "", "} ",
		    env, " ", buf, (char *)NULL) != TCL_OK) {
      fputs(interp->result, stderr); fputc('\n', stderr);
      ErrorExit("unknown service or error in service execution");
    }
  }
  Tcl_DeleteInterp(interp);
}

BuildTclBodyRep(m, buf)
     struct MessageInfo *m;
     char *buf;
{
  int i;
  
  sprintf(buf, "{ TYPE \"%s\" SUBTYPE \"%s\" PARAMS {", m->content.type, m->content.format);
  while (*buf) buf++;
  for (i=0; i < m->content.numparms; i++) {
    sprintf(buf, "\"%s\" \"%s\"", m->content.parms[i].name,
	    m->content.parms[i].value);
    while (*buf) buf++;
  }
  *buf++ = '}';
  *buf++ = ' ';
  if (strcasecmp(m->content.type, "multipart")) {
    sprintf(buf, "FILE \"%s\" ", m->body.fname);
    while (*buf) buf++;
    sprintf(buf, "ID \"%s\" ", m->content.id ? m->content.id : "");
    while (*buf) buf++;
    sprintf(buf, "DESCRIPTION \"%s\"", m->subject ? m->subject : "");
    while (*buf) buf++;
  }
  else {
    strcpy(buf, "PARTS {");
    for (i=0; i < m->body.multipart.numparts; i++) {
      while (*buf) buf++;
      *buf++ = ' ';
      BuildTclBodyRep(m->body.multipart.parts[i], buf);
    }
    while (*buf) buf++;
    *buf++ = '}';
  }
  *buf++ = '}';
  *buf = 0;
}
