# uudecode
#
# 25-Jun-92 weber@eitech.com updated for new parameter format
# 29-May-92 weber@eitech.com
#
# This service scans through a message body for uudecode source, and
# sends what it found back to the requestor.  If the input is a multipart, it
# scans through the last body in the multipart.
#
proc uudecode {switches envelope inputs} {
      if {[getfield $inputs TYPE] == "multipart"} {
	set parts [getfield $inputs PARTS]
	return [uudecode $switches $envelope [lindex $parts [expr [llength $parts] - 1]]]
      } {
	set src [getfield $inputs FILE]
    	exec awk "/^begin /,/^end\$/" $src | uudecode
	set sink [glob [exec awk "/^begin /{print \$3}" $src]]
        if {[regexp "(.*)\.Z$" $sink match submatch]} {
	  exec uncompress $sink
	  setfield response FILE $submatch
	} {
	  setfield response FILE $sink
	}
	return [mailout [turnaround $envelope] $response]
      }
}
