
/*
 * rcvpack.c -- a rcvmail program to keep a copy
 *
 * $Id$
 */

#include "../h/mh.h"
#include "../h/dropsbr.h"
#include "../h/rcvmail.h"
#include "../zotnet/tws/tws.h"
#include "../zotnet/mts/mts.h"

static struct swit switches[] = {
#define VERSIONSW 0
    { "version", 0 },
#define	HELPSW	1
    { "help", 4 },
    { NULL, 0 }
};


main (int argc, char **argv)
{
    int md;
    char *cp, *file = NULL, buf[100];
    char ddate[BUFSIZ], **ap, **argp;
    char *arguments[MAXARGS];

#ifdef LOCALE
	setlocale(LC_ALL, "");
#endif
    invo_name = r1bindex (argv[0], '/');
    mts_init (invo_name);
    if ((cp = m_find (invo_name)) != NULL) {
	ap = brkstring (cp = getcpy (cp), " ", "\n");
	ap = copyip (ap, arguments);
    }
    else
	ap = arguments;
    copyip (argv + 1, ap);
    argp = arguments;

    while (cp = *argp++) {
	if (*cp == '-')
	    switch (smatch (++cp, switches)) {
		case AMBIGSW: 
		    ambigsw (cp, switches);
		    done (1);
		case UNKWNSW: 
		    adios (NULL, "-%s unknown", cp);

		case HELPSW: 
		    sprintf (buf, "%s [switches] file", invo_name);
		    print_help (buf, switches);
		    done (1);
		case VERSIONSW:
		    print_version(invo_name);
		    done (1);
	    }
	if (file)
	    adios (NULL, "only one file at a time!");
	else
	    file = cp;
    }

    if (!file)
	adios (NULL, "%s [switches] file", invo_name);

    sprintf (ddate, "Delivery-Date: %s\n", dtimenow ());
    rewind (stdin);
    if ((md = mbx_open (file, getuid (), getgid (), m_gmprot ())) == NOTOK
	    || mbx_copy (file, md, fileno (stdin), 1, ddate, 0) == NOTOK
	    || mbx_close (file, md) == NOTOK) {
	if (md != NOTOK)
	    mbx_close (file, md);
	done (RCV_MBX);
    }

    done (RCV_MOK);
}
