
/*
 * folder_realloc.c -- realloc a folder/msgs structure
 *
 * $Id$
 */

#include <h/mh.h>

/*
 * Reallocate some of the space in the folder
 * structure (currently just message status array).
 *
 * Return pointer to new folder structure.
 * If error, return NULL.
 */

struct msgs *
folder_realloc (struct msgs *mp, int lo, int hi)
{
    int msgnum;

    if (lo == 0 && (lo = mp->lowmsg) == 0)
	lo = 1;
    if (hi < mp->hghmsg)
	hi = mp->hghmsg + (MAXFOLDER - mp->nummsg);
    if (hi <= mp->hghmsg)
	hi = mp->hghmsg + MAXFOLDER;
    if (lo == mp->lowmsg && hi == mp->hghmsg)
	return mp;

    /* Reallocate the space for message status */
    if (!(mp->msgstats = realloc(mp->msgstats, MSGSTATSIZE(mp, lo, hi)))) {
	advise (NULL, "unable to reallocate message storage");
	return NULL;
    }

    mp->lowoff = lo;
    mp->hghoff = hi;

    /*
     * Clear the flags for entries outside
     * the message range for this folder.
     */
    for (msgnum = lo; msgnum < mp->lowmsg; msgnum++)
	clear_msg_flags (mp, msgnum);
    for (msgnum = mp->hghmsg + 1; msgnum <= hi; msgnum++)
	clear_msg_flags (mp, msgnum);

    return mp;
}
