# ms_lock.pl -- locking
# SCCS Status     : @(#)@ ms_lock.pl	3.1
# Author          : Johan Vromans
# Created On      : Thu Jun  4 21:22:45 1992
# Last Modified By: Johan Vromans
# Last Modified On: Sat Jun  6 21:01:29 1992
# Update Count    : 67
# Status          : OK

# This file defines the function 'locking' as follows:
#
#    &locking (*FH, $wait)
#
#    FH is a handle to an opened file, with r/w access.
#    $wait indicates if the process is to wait for the lock.
#
# Return values:
#     1  lock succeeded
#     0  lock not succeeded, $wait == 0
#    -1  lock failed
#
# Preferrably, &locking is implemented using the fcntl(2) system
# call that is available on most modern systems.
# As an alternative, code is included to use flock(2) style locking
# available on BSD systems.
# Also code is included to use lockf(2), but this has not been tested.
# Note that this is lockf(2), not lockf(3): the system call, not the
# library routine.
#
# The functioning of this module can be tested using the program
# testlock.pl.

if ( defined $lock_fcntl && $lock_fcntl ) {
    eval <<'EOD';
	sub locking {			# using fcntl(2)
	    local (*FH, $wait) = @_;

	    require "errno.ph";
	    require "fcntl.ph";

	    local ($func) = 
		$wait ? &F_SETLKW	# set lock and wait for it
		    : &F_SETLK;		# don't wait for it
	    local ($lck) = 
		pack ("sslli",	# see man for flock(2)
		      &F_WRLCK,	# short l_type (F_WRLCK: write lock)
		      0,	# short l_whence (as in lseek(2))
		      0,	# long l_start (start of region)
		      0,	# long l_len (0 -> whole file)
		      0);	# int l_pid (not used)
	    local ($ret) = fcntl (FH, $func, $lck);
	    return 1 if $ret eq "0 but true";
	    # print STDERR ("=> ret = $ret, \$! = $! [", 0+$!, "]\n");
	    return 0 if $! == &EACCES && !$wait;
	    -1;			# failed
	}
EOD
}
elsif ( defined $lock_flock && $lock_flock ) {
    eval <<'EOD';
	sub locking {			# using flock(2)
	    local (*FH, $wait) = @_;

	    require "sys/file.ph";
	    require "errno.ph";

	    local ($wp) = &LOCK_EX;
	    $wp |= &LOCK_NB unless $wait;
	    local ($ret) = flock (FH, $wp);
	    return 1 if $ret;
	    # print STDERR ("=> ret = $ret, \$! = $! [", 0+$!, "]\n");
	    return 0 if $! == &EWOULDBLOCK && !$wait;
	    -1;				# failed
	}
EOD
}
elsif ( defined $lock_lockf && $lock_lockf) {
    eval <<'EOD';
	sub locking {			# using lockf(2) **UNTESTED**
	    local (*FH, $wait) = @_;

	    require "errno.ph";
	    require "unistd.ph";
	    require "sys/syscall.ph";

	    local ($func) = $wait ? &F_LOCK : &F_TLOCK;
	    local ($here) = tell (FH);

	    seek (FH, 0, 0);
	    local ($ret) = syscall (&SYS_lockf, fileno(FH), $func, 0);
	    seek (FH, $here, 0);
	    return 1 if $ret == 0;
	    return 0 if $! == &EACCES && !$wait;
	    -1;				# failed
	}
EOD
}
else {
    eval <<'EOD';
	sub locking {			# no locking
	    local (*FH, $wait) = @_;
	    return $wait ? 1 : 0;
	}
EOD
}

1;
