# These proc definitions are preloaded by the MESH program

# the next three procs implement "assoc" lists for tcl; these are very
# handy for examining service inputs and composing service outputs.
# Yes, I know about the keylists in extended tcl, but I didn't like them
#
proc delfield {structname field} {
  if {[catch "upvar $structname struct"]} {return}
  set i [expr [llength $struct]-1]
  while {$i>1} {
    incr i -2
    if {[lindex $struct $i] == $field} {
      set struct [lreplace $struct $i [expr $i+1]]
    }
  }
}

proc setfield {structname field value} {
  upvar $structname struct
  lappend struct $field $value
}

proc getfield {struct field} {
  set i [llength $struct]
  while {$i>1} {
    incr i -2
    if {[lindex $struct $i] == $field} {
      return [lindex $struct [expr $i+1]]
    }
  }
  return {}
}

# The following proc is used by the services.tcl file to define
# available services
proc define-service {extname intname initfile} {
  global executor srcfile
  set executor($extname) $intname
  set srcfile($extname) $initfile
}

# This is the Tcl proc that called by the mesh code to invoke a service.
# It handles error conditions like no-such-service, an incorrect
# installation of implementations, or errors during service execution
#
proc invoke-service {extname switches envelope inputs} {
  global executor srcfile administrator errorInfo

  if {![info exists executor($extname)]} {
        regsub -all " " [array names executor] "\n" servlist
	setfield response STRING "
Sorry, this server does not have a $extname service.

Services are invoked by specifying their name as the first word
in the subject line, followed by any necessary arguments.

Currently available services:

$servlist"
	return [mailout [turnaround $envelope] $response]
  }
  if {[catch {source $srcfile($extname)} errstr]} {
    setfield response STRING "Sorry, the '$extname' service encountered an error during initialization.
Please tell your ServiceMail administrator that the following occurred:\n
$errorInfo"
    set outenv [turnaround $envelope]
    if {[info exists administrator]} {setfield outenv CC $administrator}
    return [mailout $outenv $response]
  }  
  if {[catch "$executor($extname) [list $switches] [list $envelope] [list $inputs]" errstr]} {
    setfield response STRING "Sorry, the service you requested encountered an error during execution.
Please tell your ServiceMail administrator that the following occurred:\n
$errorInfo"
    set outenv [turnaround $envelope]
    if {[info exists administrator]} {setfield outenv CC $administrator}
    return [mailout $outenv $response]
  }
}

# This proc is used to construct outgoing envelopes from incoming
# envelopes
proc turnaround {inenvelope} {
  set i 0
  set outenvelope {}
  while {[set f [lindex $inenvelope $i]] != ""} {
    incr i
    case $f {
      REPLYTO { setfield outenvelope TO [lindex $inenvelope $i] }
      MESSAGEID { setfield outenvelope INREPLYTO [lindex $inenvelope $i] }
      SERVICE { setfield outenvelope SUBJECT "Re: [lindex $inenvelope $i]" }
      CC { setfield outenvelope CC [lindex $inenvelope $i] }
    }
    incr i
  }
  return $outenvelope
}

# This proc implements a crude form of security by checking the FROM
# address to see if its local
proc local from {
  return [regexp {^[^%@!]*$} $from]
}
