#! /usr/local/bin/perl

## Put here your local delivery agent (see sendmail.cf)
$mail = "/usr/local/etc/tulp/queue";

## Path to Sendmail
$sendmail = "/usr/sbin/sendmail";

## Who gets the rejected messages
$mgr = "wolf";

## Should the UNIX From line be removed ?  True on many systems.
$nofrom = 0;

## Regexps for the unwanted strings.
@avoid_hdr = (
	'help',
	'ind(ex)?',
	'lists?',
	'(please\s+)?(add|unsub|remove|del|sub(\s|scribe)?|sign?o?f?f?)',
	'rev(iew)?\s+\S+'
             );
@avoid_msg = (
	'help',
	'ind(ex)?',
	'lists?',
	'(please\s+)?(add|unsub|remove|del|sub(\s|scribe)?|sign?o?f?f?)',
	'rev(iew)?\s+\S+'
             );

$arg = $ARGV[0];
@ARGV = ();

## Paragraph mode
$/ = ""; 
$* =  1;

## Get the header.
$hdr = <>;
$hdr =~ s/^From\s+.+\n//i if ($nofrom == 1);

## Get the entire message
$* = 0;
$/ = "\n";
while (<>) {
   push(@line, $_);
}


## If more than 10 lines or to listserv then it should be okay.
&putMsg() if ($arg =~ /^listserv$/i);
&putMsg() if ($#line > 10);

$nhdr = $hdr;

$/ = ""; 
$* =  1;

$nhdr =~ s/\n\s+//g;

$from = $1 if ($hdr =~ /^From:\s+(.+)\s*$/i);
$subject = $1 if ($hdr =~ /^Subject:\s+(.+)\s*$/i);

if ($subject) {
   foreach $avoid (@avoid_hdr) {
      if ($subject =~ /^\s*($avoid)\s*/i) {  ## We have a suspicious header
         &mailMsg();
      }
   }
}

$* = 0;
$/ = "\n";

foreach $line (@line) {
   foreach $avoid (@avoid_msg) {
      if ($line =~ /^\s*($avoid)\s*/i) {  ## We have a suspicious header
         &mailMsg();
      }
   }
}

&putMsg();
exit(0);

sub putMsg {
   open(STDOUT, "| $mail $arg");
   print $hdr;
   print @line;
   close(STDOUT);
   exit(0);
}

sub mailMsg {
   $from = $mgr if (!$from);
   open(STDOUT, "| $sendmail -f listserv-request -t");
   print "To: $from\n";
   print "Subject: [listserv]: Erreur d'aiguillage?\n";
   print "Bcc: $mgr\n\n";
   print "
Le message suivant a ete adresse a la liste $arg alors qu'il semble
contenir des commandes telles subscribe, signoff, help, index, get...

Si effectivement votre message contenait une commande, sachez
que les commandes ne doivent en aucun cas etre adresses aux listes
(en vous abonnant a cette liste vous aviez recu les instructions
d'utilisation, qu'en avez-vous fait ?).
Sachez que les commandes doivent etre envoyees a l'adresse
listserv@grasp.insa-lyon.fr uniquement.

Si votre message etait effectivement destine a la liste, celui-ci
a malheureusement ete interprete par le logiciel comme une
commande. Veuillez contacter le gestionnaire du service:
$arg-request@grasp.insa-lyon.fr afin qu'il s'occupe de votre
message.     Merci de votre attention.

------ Debut message suspect --------
X-Listserv-To: $arg\n";
   print $hdr;
   print @line;
   print "------- Fin message suspect ---------\n";
   exit(0);
}
