#! /bin/sh
:
#ident	"@(#)smail/conf/lib:RELEASE-3_2_0_117:mkversion.sh,v 1.8 2000/09/03 17:33:06 woods Exp"

#    Copyright (C) 1987, 1988 Ronald S. Karr and Landon Curt Noll
#    Copyright (C) 1992  Ronald S. Karr
# 
# See the file COPYING, distributed with smail, for restriction
# and warranty information.

# Set up a shell, C-header and sed script file defining the current
# version level of smail.
#
# The variable ROOT should be defined as a path to the root of the
# smail source directory.  This should be put in the environment before
# calling this shell script.

# Establish the root of the smail source directory
ROOT="`(cd "$ROOT"; pwd)`"

# Build the smail version number
echo "Read $ROOT/level ..." 1>&2

exec < "$ROOT/level"
read comment			# skip comment line
read VERSION dow month day time tz year
RELEASE_DATE="`echo $year-$month-$day`"

# Build the shell version file
echo "Build version.sh ..." 1>&2

exec > "version.sh"

cat <<EOF
# DO NOT EDIT THIS FILE DIRECTLY, IT IS CREATED AUTOMATICALLY
# FROM THE SCRIPT $ROOT/conf/lib/mkversion.sh.  IF YOU MAKE
# CHANGES TO THIS FILE THEY ARE LIKELY TO GO AWAY.

# The current smail release from the file $ROOT/level
VERSION=$VERSION
RELEASE_DATE=$RELEASE_DATE
EOF

# Build the C version file
echo "Build version.h ..." 1>&2

exec > "version.h"

cat <<EOF
/*
 * DO NOT EDIT THIS FILE DIRECTLY, IT IS CREATED AUTOMATICALLY
 * FROM THE SCRIPT $ROOT/conf/mkversion.sh.  IF YOU MAKE
 * CHANGES TO THIS FILE THEY ARE LIKELY TO GO AWAY.
 */

/* The current smail release from the file $ROOT/level */
#define VERSION "$VERSION"
#define RELEASE_DATE "$RELEASE_DATE"

/* external functions defined in version.c */
extern char *version __P((void));
EOF

# Build the sed version file
echo "Build version.sed ..." 1>&2

exec > "version.sed"

cat <<EOF
s|X_VERSION_X|$VERSION|g
s|X_RELEASE_DATE_X|$RELEASE_DATE|g
EOF

exit 0
