#!/bin/sh
ZCONFIG=/etc/zmailer.conf
if [ ! -r $ZCONFIG ]; then
	echo "$0: $ZCONFIG is missing.  Help." >&2; exit 1
fi
. $ZCONFIG
realprog=$MAILBIN/bin/vacation
if [ ! -x $realprog ]; then
	echo "$0: $realprog is missing.  Help." >&2; exit 1
fi
case "$HOME" in
'')	echo "$0: HOME environment variable not set. Something is wrong." >&2
	exit 1;;
esac
cd || exit
case "$1" in
start)
	if test -f .forward; then
		echo "$0: You already have a $HOME/.forward file." >&2
		echo "        Move it somewhere else first." >&2
		exit 1;
	fi
	if test ! -f .vacation.msg; then
		echo "You don't have a $HOME/.vacation.msg file."
		echo "I will set up a default one for you."
		echo "You should edit it to say when you return,"
		echo "or tell people whom to contact in your absence."
		cat > .vacation.msg << \EOF
Subject: Unable to read my mail for a few days
Precedence: junk

I will be unable to read my mail for a while, since I'm on vacation.
Your message has been saved and I will read and respond to it when I return.
EOF
	else
		echo "$HOME/.vacation.msg already exists.  Using it."
	fi
	user=${LOGNAME-`whoami`}
	case "$user" in
	'')	echo "$0: don't know who you are.  Something is wrong." >&2
		exit 1;;
	esac
	rm -f .forward
	echo "$user," '"|$MAILBIN/bin/vacation' $user'"' > .forward
	$realprog -I
	echo "Enjoy your vacation."
	echo "Please remember to run"
	echo "    vacation stop"
	echo "when you return."
	;;
stop)
	if test ! -f .forward; then
		echo "$0: No $HOME/.forward file. Something is wrong." >&2
		exit 1;
	fi
	rm -f .forward .vacation.dir .vacation.pag
	echo "Welcome back."
	;;
*)
	exec $realprog $@
	;;
esac
