/*
 * body.h
 *
 * Definitions and declarations used in the handling of article bodies.
 *
 */

#define LT_NONE		0	/* Identifiers: types of text */
#define LT_SIGNATURE	1
#define LT_INCLUDED	2
#define LT_NEWTEXT	4
#define LT_TEXT		6
#define LT_BODY		7

#define AS_ARR_SIZE	8	/* Article statistic array size. */
#define ID_LINES	0	/* Indices into the statistics array. */
#define ID_BYTES	1

extern long ArticleStats[2][AS_ARR_SIZE];

#define H_TRUE		(1)	/* Indicates result of "has op" is TRUE */
#define H_FALSE		(0)	/* Indicates result of "has op" is FALSE */

#define AR_LOW_IDX	0	/* Option Base declaration for user arrays */

#define BLOCK_SIZE	2048	/* Read 2K of file at a time. */

/* u_list contains a list of pointers to a variable number of
 * units, and a pointer to an additional u_list for further units.
 * The size member counts only those units pointed to locally.  */

typedef struct _ul {
	short size;		/* Number of entries in this list. */
	struct _ul *next;	/* Ptr the next block. */
	char *u_txt[1];		/* Actual array of pointers to units. */
	} u_list;

#define ULB_SIZE	128	/* Buffer this many lines per u_list. */

/* One area_type is constructed for each distinct area found in
 * the article body.  Each area is linked sequentially to the
 * next one.  Information about the type of area is maintained.  */

typedef struct _at {
	char txt_typ;		/* Type of text represented. */
	unsigned int size;	/* Number of bytes in text area. */
	u_list *list;		/* Contents of the text area. */
	char *para;		/* Contents of text area as a paragraph. */
	struct _at *next;	/* Ptr to the next area. */
	} area_type;
