#include "nc.h"

/*
 * Main entry point for the compiler
 */

 /*
  * Newsclip(TM) Compiler Source Code.
  * Copyright 1989 Looking Glass Software Limited.  All Rights Reserved.
  * Unless otherwise licenced, the only authorized use of this source
  * code is compilation into a binary of the newsclip compiler for the
  * use of licenced Newsclip customers.  Minor source code modifications
  * are allowed before compiling.
  * A short time evaluation of this product is also permitted.  See the file
  * 'Licence' in the library source directory for details.
  */


FILE *outstream;		/* output program */
char *input_name = (char *)0;		/* input filename */
char *output_name =(char *)0;		/* created C program */
char *executable_name = "nclip";	/* created binary program */

char syscom[MAX_LLEN];

char *compopts[MAX_OPTS+10];		/* arg vector for C compiler */
int optcount = 1;			/* count of args */
bool link_flag = TRUE;			/* link together an executable */
bool no_externals = FALSE;		/* do not allow unknown externals */

main(argc, argv)
int argc;
char **argv;
{
	extern FILE *yyin;
	extern char *yyfilename;
	extern bool got_error;
	int argnum;
	char *strchr(), *strrchr();

	/* prepare to call preprocessor */
	strcpy( syscom, CPP );

	for( argnum = 1; argnum < argc; argnum++ ) {
		char *argline;
		char *argstr;		/* argument string */
		int argval;
		int isplus;		/* boolean tells +arg vs -arg */
		argline = argv[argnum];

		if (argstr = strchr(argline, '=')) {
			argstr++;
			argval = atoi(argstr);
			switch( argline[0] ) {
				case 'I':
					if( strlen(argstr)+strlen(syscom)+4
							>= MAX_LLEN )
						fatal(FALSE,"Too many args" );
					strcat( syscom, " -I" );
					strcat( syscom, argstr );
					break;
				case 'D':
					if( strlen(argstr)+strlen(syscom)+4
							>= MAX_LLEN )
						fatal(FALSE,"Too many args" );
					strcat( syscom, "-D" );
					strcat( syscom, argstr );
					break;
				case 'i':
					output_name = argstr;
					if( argstr[0] == 0 || strcmp( argstr+
							strlen(argstr)-2,
							".c" ) != 0 )
						fatal(FALSE,"Intermediate name must end with '.c'" );
					break;
				case 'c':
					if( optcount >= MAX_OPTS )
						fatal( FALSE, "Too many C compiler options" );
					compopts[optcount++] = argstr;
					break;
				case 'o':
					executable_name = argstr;
					break;
				default:
					fatal( FALSE, "Bad Option %s", argline);
				}
			}
		else if( (isplus = argline[0] == '+') || argline[0] == '-' ) {
			switch( argline[1] ) {
				case 'l': /* link or do not link */
					link_flag = isplus;
					break;
				case 'e':
					no_externals = !isplus;
					break;
				default:
					fatal( FALSE, "Bad Option %s", argline);
				}
			}
		else {
			char *p;
			/* code for untagged option */
			/* check extension on file, .c .o or .a */
			p = strchr( argline, '.' );
			if( p && p[2]==0 && (p[1]=='c'||p[1]=='o'||p[1]=='a')) {
				if( optcount >= MAX_OPTS )
					fatal( FALSE, "Too many C compiler options" );
				compopts[optcount++] = argline;
				break;
				}
			 else {
				if( input_name != (char *)0 )
					fatal( FALSE, "Only one file may be compiled at a time" );
				input_name = argline;
				}
			}
		}
	/* body of program */


	initialize();
	symtab_init();

	if( !input_name ) {
		usage();
		}
		

	if( access( input_name, 4 ) != 0 )
		fatal( FALSE, "Could not open input %s", input_name );
 
	if( strlen(syscom)+strlen(input_name)+2 >= MAX_LLEN )
		fatal(FALSE,"Too many args" );
	strcat( syscom, " " );
	strcat( syscom, input_name );

	yyin = popen(syscom, "r");
	if( !yyin )
		fatal( FALSE, "Unable to preprocess input %s", input_name );
	
	if( !output_name ) {
		char *dot;
		int inlen;
		inlen = strlen(input_name);
		/* get 2 extra bytes in case we add .c */
		output_name = checkalloc( inlen+2+1 );
		strcpy( output_name, input_name );
		dot = strrchr( output_name, '.' );
		/* if no dot, append extension to the end */
		if( !dot || strchr( dot, '/' ) != (char *)0 )
			dot = output_name + inlen;
		strcpy( dot, ".c" );
		}
	outstream = fopen( output_name, "w" );
	if( !outstream )
		fatal( FALSE, "Could not open output file '%s'", output_name );
	yyfilename = input_name;

	/* start output by putting in include data */
	cout( "#include \"ucode.h\"\n" );

	if( yyparse() || got_error ) {
		fclose( outstream );
		if( unlink( output_name ) )
			fprintf( stderr, "Could not remove file '%s'\n", output_name );

		fatal( FALSE, "Compilation of NEWSCLIP program failed\n" );
		}
	pclose( yyin );
	write_null();			/* output null entry points as needed */
	write_data();
	fclose( outstream );
	if( link_flag ) 
		compile_it();		/* does an execv, does not return */
	exit(0);
}

initialize()
{
	extern struct stringmap thegroups;
	extern struct stringmap thepatterns;

	thegroups.dbase = init_db( 80, sizeof(numstring) );
	thegroups.counter = 0;
	thepatterns.dbase = init_db( 80, sizeof(numstring) );
	thepatterns.counter = 0;
}

usage()
{
	fprintf( stderr, "NewsClip(TM) News Filter Compiler V0.9\n" );
	fprintf( stderr, "Copyright (c) 1989 Looking Glass Software Limited.\n\n" );
	fprintf( stderr, "Usage:\n\tnnc [I=includedir] [D=symbol=definition] filename\n" );
	fatal( FALSE, "Missing source filename." );
}

compile_it()
{
	/* now compile the program and link with the library */
	compopts[0] = "cc";			/* name the C compiler */
	/* extra options defined in sysdefs.h */
#ifdef EXTRAOPT1
	compopts[optcount++] = EXTRAOPT1;
#endif
#ifdef EXTRAOPT2
	compopts[optcount++] = EXTRAOPT2;
#endif
#ifdef EXTRAOPT3
	compopts[optcount++] = EXTRAOPT3;
#endif
	/* directory to find ucode.h */
	compopts[optcount++] = UCODEDIR;
	/* name of the program */
	compopts[optcount++] = output_name;
	/* name of the library, if it exists */
	if( access( CLIPLIB, 0 ) == 0 )
		compopts[optcount++] = CLIPLIB;
	 else if( access( CLIPBASE, 0 ) == 0 )
		compopts[optcount++] = CLIPBASE;
	compopts[optcount++] = "-o";
	compopts[optcount++] = executable_name;
	compopts[optcount++] = 0;
	/* transfer to the C compiler */
	execv( CCOMP, compopts );
	/* should never get here */
	fatal( FALSE, "Execution of the C compiler failed" );
}
