#include "nl.h"

/* This function contains some general library routines used by
 * the newsclip system.  A few are even available to user programs.
 *
 * Also found here are the error handling routines, which are variable
 * argument programs involving non-portable calls to printf.
 * On some machines you will have to add your own ways to do this with
 * ifdefs.
 */

 /*
  * Newsclip(TM) Library Source Code.
  * Copyright 1989 Looking Glass Software Limited.  All Rights Reserved.
  * Unless otherwise licenced, the only authorized use of this source
  * code is compilation into a binary of the newsclip library for the
  * use of licenced Newsclip customers.  Minor source code modifications
  * are allowed.
  * Use of this code for a short term evaluation of the product, as defined
  * in the associated file, 'Licence', is permitted.
  */


/* Takes a string and makess all the letters lower case */


lowercase( str )
register char *str;
{
	while( *str ) {
		if( isupper( *str ) )
			*str |= 0x20;
		str++;
		}
}

/* strip white space from a string's end, and returns a pointer to
   the first non-white character in the string.  Sort of an
   'affirmative action' routine */

char *
whitestrip( str )
char *str;
{
	return white_delim_strip( str, 0 );
}


/* strip white space from a string's ends and remove a possible terminator
   char */

char *
white_delim_strip( str, delim )
char *str;
char delim;		/* if this character terminates string, null it */
{
	register char *fp;		/* first pointer */
	char *first;
	char *last;
	int len;

	for( fp = str; *fp == ' ' || *fp == '\t'; fp++ )
		;
	first = fp;
	last = 0;
	for( fp = first; *fp; fp++ )
		if( *fp != ' ' && *fp != '\t' )
			last = fp;
	if( last ) {
		last[1] = 0;
		if( *last == delim )
			*last = 0;
		}
	return first;
}

/* Make a copy of a string in permanent memory */

char *
allocstring( str )
char *str;
{
	char *res;

	res = perm_alloc( strlen(str) + 1 );
	strcpy( res, str );
	return res;
}

/* Make a copy of a string in temporary memory */

char *
temp_string( str )
char *str;
{
	char *res;

	res = temp_alloc( strlen(str) + 1 );
	strcpy( res, str );
	return res;
}

/* directory/file open */

FILE *
dfopen( prefix, fname, mode )
char *prefix;
char *fname;
char *mode;
{
	char buf[MAX_FNAME];
	FILE *res;

	sprintf( buf, "%s/%s", prefix, fname );
	return fopen( buf, mode );
}

/* Open a file, and abort if it can't be opened */

FILE *
mustopen( fname, mode, reason )
char *fname;
char *mode;
char *reason;
{
	FILE *res;

	if( res = fopen( fname, mode ) )
		return res;
	 else
		error( "Could not open %s (%s)\n", fname, reason );
}

/* Zero out a region of memory.  Your system may have a routine around to
   do this faster.  If so, remove this and use your own. */

zero( mem, bytes )
char *mem;
int bytes;
{
	register int *p;
	register char *cp;
	int words, extra;

	words = bytes/sizeof(int);
	extra = bytes - sizeof(int)*words;

	p = (int *)mem;
	while( words-- )
		*p++ = 0;
	cp = (char *)p;
	while( extra-- )
		*cp++ = 0;
}

/* Convert a character numeric string into a number, guaranteed to be
   able to handle numbers up to 2^31.*/

int32
atoi32( str )
char *str;
{
#ifdef INTS_32
	return atoi(str);
#else
	extern long atol();
	return (int32)atol(str);
#endif
}

/* debug printf for user programs */

dprintf( form, a,b,c,d,e,f )
long a,b,c,d,e,f;
char *form;
{
	/* check debug flag ? */
	fprintf( stderr, form,a,b,c,d,e,f );
}

/* Issue a warning on stderr */

int warning_level = 1;

warning( level, f, a, b, c, d, e )
int level;
char *f;
{
	if( level <= warning_level ) {
		fprintf( stderr, "NewsClip: " );
		fprintf( stderr, f,a,b,c,d,e );
		}
}

/* case-less string equality routine */

cleq(s1, s2)
register char *s1;
register char *s2;
{
	while( *s1 )
		if( (*s1++ | 0x20) != (*s2++ | 0x20) )
			return FALSE;
	return *s2 == 0;
}

/* Takes a long and returns an int.  If the long is too big, then we
 * return the biggest (magnitude) int we can */

int
makeint( bnum )
long bnum;
{
	if( bnum > MAXINT )
		return MAXINT;
	 else if( bnum < -MAXINT )
		return -MAXINT;
	 else
		return (int)bnum;
}
