
	/* symbols from the header */
extern string	subject;		/* article subject line */
extern string	message_id;
extern string	array references;
extern userid	from;
extern int	lines;

database badmes;		/* bad message-ids - by group */
database baduser;		/* users I don't like - global */
database gooduser;		/* users I do like - global */
database badsubject;		/* subject line database - by group */
database killpatterns;		/* kill patterns for subject lines - by group */


procedure init()
{
	/* set up the good and bad user databases */
	baduser = read_database( "~/News/baduser" );
	gooduser = read_database( "~/News/gooduser" );
	/* nil out the individual newsgroup databases */
	badmes = nildatabase;
	badsubject = nildatabase;
	killpatterns = nildatabase;
}

procedure terminate()
{
	extern datetime time_now;

	/* save out my updated bad user database */
	write_database( baduser, "~/News/baduser", time_now-month );
}

procedure startgroup()
{

	/* load up the databases for this newsgroup */
	badmes = read_database( "~/News/badmes/~N" );
	badsubject = read_database( "~/News/badsubject/~N" );
	killpatterns = read_database( "~/News/killpatterns/~N" );
}

procedure endgroup()
{
	extern datetime time_now;

	/* write out the databases for this newsgroup */

	write_database( badmes, "~/News/badmes/~N", time_now-2*week );
	free_database( badmes );
	badmes = nildatabase;
	write_database( badsubject, "~/News/badsubject/~N", time_now-2*week );
	free_database( badsubject );
	badsubject = nildatabase;
	write_database( killpatterns, "~/News/killpatterns/~N", time_now-2*week );
	free_database( killpatterns );
	killpatterns = nildatabase;
}

procedure
article()
{
	extern newsgroup main_newsgroup;
	extern string drop_re( string );
	extern int distribution_level;

	/* accept articles from desired users immediately */
	accept if from in gooduser;

	/* is this a followup to a killed chain? */
	reject if references != nilarray && references in badmes;


	/* If from a hated user, reject and kill the chain too */
	if( from in baduser ) {
		/* reject all followups, too */
		badmes[message_id] = true;
		reject;
		}

	/* if the subject is explicitly a bad one, or a keyword from our
	   pattern list is found in it, reject */
	if( drop_re(subject) in badsubject || subject has killpatterns )
		reject;

	/* give me messages from local users */
	accept if from has "waterloo.edu$" ||
			distribution_level < dlevel(#province);

	reject if count(newsgroups) > 4;	/* I hate crossposting */

	/* do group sepecific rejection */
	switch( main_newsgroup ) {
		case #rec.arts.comics:
			if( body has "templeton" || body has "stig.*inferno" || body has "league international" || body has "jli" )
				accept;
			 else
				reject;
		case #comp.sys.atari.st:
			reject if is comp.sys.amiga;
			break;
		case #comp.lang.pascal:
			accept if body has "alice" || body has "sytax.directed"
					|| body has "interpret";
			reject;
		case #talk.politics.theory:
			reject if lines / (1+line_count(included)) < 2;
			break;
		}
}

/* My processor for KILL commands */

procedure
command( string com )
{
	userid fromwho;
	string arg;
	extern int chindex( string, int );
	extern string lower( string );
	extern string clipfront( string, int );
	string array artrefs;

	if( chindex( com,1 ) == 'K' ) {
		arg = clipfront(com,4);
		switch( chindex( com,2 ) ) {
			case 'F':	/* followups */
				badmes[arg] = true;
				dprintf( "Adding %s to kill list\n", arg );
				accept;
			case 'T':	/* all followups of top parent */
				parse artrefs = arg, " ";
				if( count(artrefs) > 0 )
					badmes[artrefs[0]] = true;
				 else
					reject;
				dprintf( "Adding master %s to kill list\n",
						artrefs[0] );
				accept;
				
			case 'U':	/* a user */
				parse fromwho = lower(arg);
				baduser[fromwho] = true;
				accept;
			case 'S':	/* a subject re-less */
				badsubject[lower(arg)] = true;
				accept;
			case 's':	/* subject pattern */
				killpatterns[lower(arg)] = true;
				accept;
			case 'x':	/* test filter alive? */
				dprintf( "Filter in operation\n" );
				accept;
			}
		}
	reject;
}
