/*
 * Various system dependent and fine-tuning #defines
 */

#define PAID 1

/* define if ints are 32 bits, or more */

/* #define	INTS_32		1 */
/*
 * Define this macro according to whether your compiler takes ANSI C
 * style function prototypes or not.  (ie.  int f( int, char * ); )
 */

#define ANSI_PROTO 1

#ifdef ANSI_PROTO
# define AC(x)	x
#else
# define AC(x)	()
#endif /*ANSI_PROTO*/
/* Define these according to the directories of your system */

#define NEWSLIB		"/usr/lib/news"		/* lib directory for news */
#define	NEWSSPOOL	"/u/news"		/* spool dir for news */
/* Define this to be the name of the file that contains the sizes for
 * the various distributions
 */
#define DISTLIST	"distlist"	/* level of distrs */

/*
 * Define this to be, in lower case, the domain name your news programs use
 * when they generate a From: address.  If you don't define this, you will
 * get your sitename appended with the default domain. (uucp unless you change
 * it below)
 */
#undef MAILDOMAIN	/* "looking.uucp"		All lower case!!!! */

#define DEFDOMAIN	 "on.ca"


/*
 * Some raw system-type defines
 */

#undef NEED_SLIB /* 1			for systems without system V string
					calls, such as V7 or BSD */

#ifdef NEED_SLIB
/* why don't the BSD people get with it and include these new names? */
#define strchr index
#define strrchr rindex
#endif

#define HAS_UNAME 1			/* for systems with the uname call */

/*
 * Define this if you are a BSD system with the gethostname call.
 */
#undef GETHOSTNAME /* 1				BSD gethostname call */

/*
 * If you don't have this call, and you aren't a SYSV system with the
 * uname call, or a Xenix or other system with the /etc/systemid file,
 * then you should define the symbol 'sysname' to be a string with your
 * system name, as it appears in Xref: lines.  You can often do this on
 * older systems by saying '#include <whoami.h>'
 */

#undef sysname /*"mysite"*/

/* The maximum length of a single component in a filename */
/* too bad there's not a portable way to get this.  Even dir.h doesn't work */

#ifndef MAX_FNAME_LEN

# define MAX_FNAME_LEN 14		/* normal for most unix */

#endif /*MAX_FNAME_LEN*/

/* System dependent definitions for calling the C compiler */

/* How to call the C preprocessor on a file.  Usually either /lib/cpp or
   cc -E, depending on the system */

#define CPP "/lib/cpp"

/* The pathname of the 'cc' C compiler */

#define CCOMP "/bin/cc"

/* Option to tell cc about where the "ucode.h" file can be found */
/* Other system include files may go there as well */

#define UCODEDIR "-I/v/src/nl"

/* Location of the newsclip library -- if it isn't present the user
   must provide it himself as a command line options */

#define CLIPLIB "/v/src/nl/cliplib.a"
/* The basename of the clip library, so that it can be found in the
 * current dir
 */
#define CLIPBASE "cliplib.a"

/* Up to 3 extra options for the C compiler.  You may want to do things
   like set a stack size here.  Note that extra options can be given on
   the ncc command line */

#define EXTRAOPT1 "-Ml2"
#define EXTRAOPT2 "-F"
#define EXTRAOPT3 "2000"


/* probably fixed, unless you have 64 bit ints */

#ifdef INTS_32
# define MAXINT	 2147483647
#else
# define MAXINT  32767				/* change this if need be */
#endif

/*
 * Don't change these unless you want to fine tune the program
 */

#define MAX_FNAME 300			/* max length of file name */

#define MAX_LLEN 300			/* max length of typical input line */	

#define MAX_HLINES 50			/* max number of header lines */

#define MAX_ARRAY 200			/* max elements in an array */

#define MAX_NGLEN 80			/* max length of newgroup name */

#define BITMAP_SIZE 1000		/* at most 8000 articles at a time? */

#define MAX_OPTS 30			/* max options for C compiler or
						user program */

#define TBLOCK_SIZE 5000		/* size of chunks for use in temporary
						allocator */
#define MIN_TBLOCK TBLOCK_SIZE/64	/* smallest block to allocate */

#define HLINE_SIZE 2500			/* buffer for header line */

