''' Hey EMACS, I'm an -*-Nroff-*- file!
''' Use the MM macros.
.TL
An Introduction to Notes at HP
.AF "Hewlett-Packard"
.AU "Tw Cook" TWC "hpisla!tw"
.AS
This introduction was originally written as a contribution to
Alan Silverstein's Electronic GEE-WHIZ-O-GRAM series, and was
issued on August 25, 1983. The current version is an evolution
of that document, which benefitted from editing by Alan.
.AE
.MT 2
.tr ~
.H 1 "Background Information"
.P
A long time ago, on a system far, far away, some users decided
that it would be nice if they had a bulletin board system
which wasn't restricted to a single machine. Conveniently,
the system they had (Unix\*F)
.FS
Unix is a trademark of AT&T Bell Laboratories, as always.
.FE
was amenable to such things, and "The Network News",
also known as
.I netnews
or
.I USENET
was born.
.P
Netnews evolved rapidly, and soon spread throughout the world
(literally - there are hundreds of systems all over Europe,
Canada, the US, Korea, and Australia).
.P
Meanwhile, some folks at the University of Illinois developed
a similar system for their large PLATO mainframes, called
.I notesfiles.
Soon someone recoded the notesfiles system for
their Unix machines, and the notesfiles system we know was born.
.P
At the time, no one thought about interfacing the two, but it
soon became apparent that such a thing was quite feasible, so
it was done.
.P
The notesfile system present on most internal HP machines is
connected at several points to the netnews system of the
outside world. The result is that you have easy access to
experts in many fields (not just computers!), both to listen
to and to ask questions of.
.P
Typically, many notesfiles readers are just that,
.I readers.
They simply listen in on the ongoing discussions, and once in
a great while contribute something. Until you are familiar
with the etiquette involved, you'd be best off to remain a
reader.
.P
There are a few people (mostly "old-timers" on the net) who
are regular contributors to one or more notesfiles, but please
.I don't
become one of these until you have been reading a
notesfile for long enough to understand what it is all about.
.H 1 "Available Topics"
There are several categories of notesfiles\*F
.FS
Netnews users often call these
.I newsgroups
instead.
.FE
which are likely to be present
on your machine. They are distinguished by the first few
characters of the notesfile names.
.H 2 "Notes from the ARPAnet (fa.*)"
Notesfiles whose names begin with "fa." originate on the
ARPANET ("From Arpanet"). These are often in "digest" form,
not unlike a small newspaper.
.H 2 "Notes from Usenet (net.*)"
Notesfiles whose name starts with "net." originate on
USENET ("Users Network", also known as "netnews" or just "The
Net"). These articles cover an incredibly wide variety of
subjects, from movie reviews to local area networks.
.H 2 "Moderated Notesfiles (mod.*)"
In an effort to weed out some of the more spurious transmissions,
the USENET community has created several moderated newsgroups (notesfiles).
These cannot be posted to directly; instead, you must send mail to the
moderator for each group. The list of moderators is periodically posted
to "mod.newslists". Most moderated newsgroups have names which start
with "mod"; however, there are two important ones which don't - these
are "net.announce" and "net.announce.newusers". "net.announce" is for
important announcements which concern the whole USENET community. If you
read any "net" or "mod" notesfiles, you should also read this
one. "net.announce.newusers" is a special group containing information on
how to help you get started. Some of the more interesting material
appearing there is included as appendices to this document.
.H 2 "HP Internal Notesfiles (hp.* and hug.*)"
Notesfiles whose name starts with "hp." are distributed ONLY
within Hewlett-Packard R&D labs, so it is perfectly alright to discuss
new products or HP confidential material in them. DO NOT post
any material which is potentially HP confidential to any
notesfile whose name doesn't begin with "hp". Chances are
that it will be broadcast to the world, which includes many HP
competitors, such as DEC, SUN, Tektronix and Fortune.
.P
There are also some notesfiles whose names start with "hug" - these
are for the HP-UX Users Group, and are mostly used for communication
between the various field personnel. These are gatewayed into the
R&D labs, but not the reverse.
.H 2 "Local and Regional Notesfiles"
There are also miscellaneous other notesfiles available,
usually on a site-dependent basis. Typically, "general" is
used for information of interest only to people on your
specific machine. Some areas also have regional networks; for
example, in Oregon there are "or." notesfiles, which are
shared with U of O, OSU, Tektronix, HP, and several other
local industrial sites. At FSD there are "fsd."
notesfiles. Such notesfiles typically do not leave a machine,
facility, or region.
.H 2 "Differences between notes and news"
One key difference between notesfiles and netnews is that the
former understands how to tie "responses" to "base notes", but
the latter does not. Netnews readers perceive EVERY article
as an independent entity, with a title of its own. There is
even a newsgroup called "net.followup", where response
articles are SUPPOSED to go, except usually no-one bothers.
Notesfile articles which cross to netnews format and back are
supposed to retain the tie to their basenote, but sometimes
they don't. This is a common source of response articles
titled "Orphaned Response", tied to an empty basenote.
.H 1 "How to Get Started"
First, you need to decide which notesfile(s) you'd like to
read. To get started, you might try "hp.general" -- this is a
general purpose bulletin board which goes to all HP-UX sites.
You can start by just typing "notes hp.general".
.P
What you should see is an index of the available articles, by
subject and author. You can look at any note simply by typing
its number, followed by a carriage return. "i" will bring you
back to the index page. You can also just keep hitting the
space bar to page through the note you started with and any
subsequent notes. "q" will exit notesfiles, and return you to
your shell.
.P
If this seems like a lot of work, you're right. There is an
easier way. First you need to create a subscription list.
This must be placed in the file ".notesrc" in your home
directory. All you need is a file with the name of a
notesfile you wish to view on each line. That isn't hard,
because normal shell wildcards work, so to subscribe to all hp
notesfiles, just put in a line which says "hp.*". You can
subscribe to everything by putting just a single "*" in the
file [and start spending two hours a day reading it...].
.P
The next step is to invoke notes using the automatic
sequencer. What the sequencer does for you is to remember
which notes you have and haven't read, so that you never have
to look at the same note twice unless you want to. It will
also take care of scanning all the notesfiles in your
subscription list.
.P
All you have to do is invoke notes with a special name: "autoseq".\*F
.FS
You can also use the notes -s option or put "-s" in your .notesrc file.
.FE
Just type "autoseq" and notes will read your .notesrc
file, scan the notesfiles listed, and will take you
to the first note [or response] you haven't read.
.P
You can use the "j" key to jump to the next unread note in
each notesfile. The "q" key (or "k" if you"re right handed)
will take you to the next notesfile.
.P
You can ask for help at any time by typing "?".
.P
One particularly nice feature is "u", to unsubscribe. If you
decide that some notesfile isn't for you, just type "u" while
reading it. The sequencer will never take you there again.
.P
There are lots of other useful commands, but this should be
enough to get you started. Check the notesfiles manual if you
want to know more.
.H 1 "Cautions"
Remember that
.I thousands
of people read notesfiles (or
equivalently, netnews) and that if you post something stupid,
you'll be making a fool of yourself in front of all of those
people.
.I Think
before posting, and if there isn't a good
reason to post the article, then don't post it at all.
.P
If you say something dumb (or just controversial) you'll
probably get quite a lot of hate mail from all the people you
annoyed.
.P
Think about whether you'd rather post an article to all sites
to respond to a question, or if it wouldn't be better to send
personal mail to the poster of the article in question. (Use
the "p" key from inside notes to send mail to the author of
the current article).
.P
This shouldn't deter you from posting articles, just make sure
you know what you're doing. Remember that you represent HP
to potential customers, as well.
.H 1 "More on the HP Internal Notesfiles"
As more and more HP divisions start using HP-UX as both a
software development environment and for engineering support,
we should see lots of new participants in the "hp.*"
notesfiles.
.P
HP has traditionally had communication problems between
divisions; this is our chance to get over that. Let us know
what you are doing, and instead of reinventing something, ask
first to see if someone already did it. It makes little sense
for people at three or four divisions to be working on the
same driver for the same device on the same system, yet this
happens all the time.
.P
Besides, it is a lot more fun to feel like there are lots of
people out there on your side!
.nr Hu 1
.HU "Appendix 1: The Ten Commandments for Usenet (by hpfcla!ajs)"
.AL I
.LI
The Net is special; treat it with respect.
.LI
Always create a clear and concise Subject line.
.LI
Keep thy postings short and never ramble.
.LI
Always post to the proper newsgroup.
.LI
Never post the same thing twice; post once to multiple
newsgroups or use short pointers where required.
.LI
Thou shalt spend 40 days and nights in meditation
before adding or removing any newsgroup.
.LI
Specify clearly if and how thou expectest responses.
.LI
Reply in person whenever possible and limit thy
followups to truly worthy items.
.LI
Read all current articles in a newsgroup before
replying to any.
.LI
Use proper English, and prepare postings with an
editor when required.
.LE
.HU "Appendix 2: Notesfiles of Interest"
This is a selected list of available notesfiles. There are far more
than this, so for the complete list you will need to check
net.news.group.
.VL 25 1 1
.LI "hp.announce"
Important announcements
.LI "hp.forum"
Controversial topics (whatever that means!)
.LI "hp.general"
Anything that is of interest to all at HP
.LI "hp.misc"
Misc. stuff that doesn't fit in elsewhere
.LI "hp.notes"
Discussion of notes problems and enhancements.
.LI "hp.people"
Tell us who you are and what you're doing
.LI "hp.projects"
Discussion of projects at various divisions
.LI "hp.sources"
For internal distribution of software. If
you've written a neat program and want to
share it within HP, this is how to send it
.LI "hp.unix"
Discussion of HP-UX efforts in general
.LI "hp.unix.s200"
Questions and bug reports for S200 HP-UX
.LI "hp.unix.s500"
Questions and bug reports for S500 HP-UX
.LI "------------"
.LI "mod.map.news"
Lists of sites that participate in USENET
.LI "mod.newslists"
Lists of moderators, current newsgroups, etc.
.LI "mod.sources"
Source code for various useful things.
.LI "mod.std.c"
People interested in standardizing the C language.
.LI "mod.unix"
Discussions about Unix.
.LI "------------"
.LI "net.ai"
Artificial intelligence
.LI "net.announce"
Important announcements of interest to all USENET readers
.LI "net.bugs"
General bug reports and fixes
.LI "~~~net.bugs.usg"
Subgroup for USG (System III, V, etc.) bugs
.LI "~~~net.bugs.uucp"
Subgroup for UUCP related bugs
.LI "net.flame"
Lots of frothing at the keyboard
.LI "net.general"
Important and timely announcements of
interest to all
.LI "net.graphics"
Computer graphics, art, and animation
.LI "net.jokes"
Every tenth article will have you rolling
in the aisles
.LI "net.lang"
Different computer languages
.LI "~~~net.lang.c"
Subgroup for C
.LI "~~~net.lang.lisp"
Subgroup for LISP
.LI "~~~net.lang.pascal"
Subgroup for PASCAL
.LI "net.micro"
Micro computers of all kinds
.LI "~~~net.micro.16k"
Subgroup for 16k's
.LI "~~~net.micro.68k"
Subgroup for 68k's
.LI "~~~net.micro.cpm"
Subgroup for the CP/M operating system
.LI "~~~net.micro.pc"
Subgroup for IBM personal computers
.LI "net.misc"
Miscellaneous discussions too short lived for
their own groups
.LI "net.movies"
Reviews and discussions of movies
.LI "net.music"
Music lovers' group
.LI "net.news"
Discussions of USENET itself
.LI "~~~net.news.config"
Subgroup for posting of computer down times
and network interruptions
.LI "~~~net.news.group"
Subgroup for discussions and lists of
newsgroups
.LI "~~~net.news.map"
Subgroup for maps
.LI "~~~net.news.newsite"
Subgroup for new site announcements
.LI "net.notes"
Discussion of notesfile software
.LI "net.sf-lovers"
Science fiction lovers' newsgroup
.LI "net.singles"
Newsgroup for single people
.LI "net.sources"
For the posting of software packages
.LI "net.unix-wizards"
Discussions, bug reports, and fixes on and
for UNIX; not for the weak of heart
.LI "fa.human-nets"
Computer aided communications digest
.LI "fa.tcp-ip"
TCP and IP network protocols
.LI "fa.telecom"
Telecommunications digest
.LE
.TC
