/* $Header: /g1/users/staff/gore/exp/notes/src/RCS/access.c,v 2.0 89/04/15 23:34:27 gore Exp $ */

/*
 *	doaccess - process access list editing
 *
 *	functions include:
 *	(1) display access lists
 *	(2) insert new entries
 *	(3) delete old entries
 *	(4) modify existing entries
 *
 *	Original Coding: Ray Essick	January 1982
 */

#include "parms.h"
#include "structs.h"
#include <pwd.h>
#include <grp.h>		       /* /etc/passwd and /etc/group formats */

#include "acl.h"
#ifdef __STDC__
static void acssort(int);
static short getmode(short*);
static void plotit(int, struct io_f*);
#else
static void acssort();
static short getmode();
static void plotit();
#endif __STDC__

/* mapping for name types */
static char *kmap[] = {
    "usr:", "grp:", "sys:"
};

static char *map[] = {
     /* ---- */ "Null",
     /* ---r */ "Read Only",
     /* --w- */ "(02)",
     /* --wr */ "(03)",
     /* -d-- */ "(04)",				/* nonsense */
     /* -d-r */ "(05)",				/* nonsense */
     /* -dw- */ "(06)",				/* nonsense */
     /* -dwr */ "(07)",
     /* a--- */ "Answer Only",			/* nonsense */
     /* a--r */ "Read/Answer",
     /* a-w- */ "Write only",
     /* a-wr */ "Read/Write",
     /* ad-- */ "(014)",			/* nonsense */
     /* ad-r */ "(015)",			/* nonsense */
     /* adw- */ "(016)",			/* nonsense */
     /* adwr */ "Director/R/W"
};

doaccess (io)
struct io_f *io;			/* notefile working with */
{
    struct passwd  *getpwnam ();
    struct group   *getgrnam ();	/* check validity of name/group */
#ifdef __STDC__
    char *getname(int);
#else
    char *getname();
#endif
    char    c;
    int base, which;
    acl_t *aclp;
    acl_h aclh;
    ace_t ace;

    base = 0;				/* which part are we displaying */
    erase();
    plotit(base, io);

    while(1) {
	cmdprompt();
	c = gchar(0);					/* grab command */
	switch(c) {
	    case '?': 
	    case 'h': 
		nfhelp(ACCHLP);			/* print the help page */
		goto redraw;			/* redraw the screen */

	    case '!': 				/* fork a shell for him */
		gshell();
		goto redraw;

	    case 'K':
	    case 'Q': 
		return(0);			/* return to the caller */

	    case '\004': 			/* abort notefiles */
		return(QUITFAST);

	    case 'k':
	    case 'q': 		/* update lists (if changed) and leave) */
		/*
		 * The list is updated after each change.  That's not how it
		 * was done before, but it's consistent with everything else
		 * in the director's menu.
		 */
		return(0);

	    case '-': 				/* scroll display backwards */
		base -= (nrows - 6);		/* back a half sreen */
		if (base < 0) {
		    base = 0;			/* don't pass zero */
		}
		goto redraw;

	    case '+': 				/* scroll display forwards */
		base += (nrows - 6);		/* up half screen */
		if (base < 0) {
		    base = 0;			/* don't pass zero */
		}
		goto redraw;

	    case 'r': 		/* redraw the lists */
	    case '\014': 	/* everyone else uses ^L, might as well */
	redraw: 
		erase();
		plotit(base, io);
		break;			/* back to command sucker */

	    case 'i': 			/* enter a bunch of permissions */
		for (;;) {
	    reget:  at(-4, 40);
		    putstr("Entry type:  \b");
		    c = gchar(0);
		    if (c == '\n' || c == '\r' || c == 'q')
			break;				/* get out */
		    switch (c) {
			case 'u':
			    ace.ptype = PERMUSER;
			    break;

			case 'g': 
			    ace.ptype = PERMGROUP;
			    break;
			     
			case 's':
			    ace.ptype = PERMSYSTEM;
			    break;

			default: 
			    putstr("\07  (u,g,s,q,<cr>)");
			    goto reget;
		    }
		    putch(c);
		    at(-3, 40);
		    putstr("Name: ");
		    clear_eol();
		    if (gline(ace.name, sizeof(ace.name)) == 0)
			continue;			/* null name */
		    if (ace.ptype==PERMUSER && strcmp("Other", ace.name)!=0) {
			if (getpwnam (ace.name) == NULL) {
			    at (-2, 40);
			    putstr("--No such user-- ");
			    continue;
			}
		    }
		    if (ace.ptype==PERMGROUP && strcmp("Other",ace.name)!=0) {
			if (getgrnam (ace.name) == NULL) {
			    at (-2, 40);
			    putstr("--No such group--");
			    continue;
			}
		    }

		    ace.perms = DFLTPERMS;
		    getmode(&ace.perms);
		    aclp = acl_open(io);
		    acl_add(aclp, &ace);
		    acl_sort(aclp);
		    acl_close(aclp);
		    erase();				/* clean screen */
		    plotit(base, io);			/* show new list */
		}
		endpwent();				/* close passwd and */
		endgrent();				/*    group files   */
		break;


	    case 'd': 				  /* delete some permissions */
		prompt("Delete entry #: ");
		if ((c = gchar(0)) == '\n')
		    break;				/* null */
		which = getnum(c);			/* grab number */
		if (which <= 0)
		    break;				/* don't update */
		if (c < '0' || c > '9') {
		    warn("Bad entry");
		    break;
		}
		aclp = acl_open(io);
		aclh = acl_nth(aclp, which);
		if (aclh == ACL_NOHANDLE) {
		    warn("Bad entry");
		    break;
		}
		ace_copy(&ace, acl_ace(aclp, aclh));
		if ((ace.ptype==PERMUSER) && strcmp(getname(0),ace.name)==0) {
		    warn("Can't delete yourself");
		    break;
		}
		acl_delete(aclp, aclh);
		acl_close(aclp);
		goto redraw;			/* show updated screen */

	    case 'm': 			       /* modify someones permission */
		prompt("Modify entry #: ");
		if ((c = gchar(0)) == '\n')
		    break;				/* null entry */
		which = getnum(c);
		if (which <= 0) {
		    break;
		}
		if (c < '0' || c > '9') {
		    warn("Bad entry");
		    break;
		}
		aclp = acl_open(io);
		aclh = acl_nth(aclp, which);
		if (aclh == ACL_NOHANDLE) {
		    warn("Bad entry");
		    break;
		}
		ace_copy(&ace, acl_ace(aclp, aclh));
		getmode(&ace.perms);
		acl_replace(aclp, aclh, &ace);
		acl_close(aclp);
		goto redraw;			/* repaint screen */

	    default: 				/* wrong key dummy */
		putch('\07');
		break;
	}
    }
}

static short
getmode(zmode)
short *zmode;
{						/* grab a mode from the tty */
    char    c;
    short mode;					/* resulting mode */
    char buf[80];

    mode = *zmode;				/* set to what passed in */

    while (1) {
	at(-2, 40);
	sprintf(buf, "Mode: %s", map[mode]);
	putstr(buf);
	clear_eol();
	at(-1, 40);
	putstr("Mods: ");
again:
	c = gchar(0);
	switch(c) {
	    case 'a': 				/* toggle answer */
		if (mode & WRITOK) {
		    break;			/* write supersedese */
		}
		if (mode & RESPOK) {
		    mode &= ~RESPOK;
		} else {
		    mode |= RESPOK;
		}
		break;

	    case 'r': 				/* toggle read */
		if (mode & DRCTOK) {
		    break;			/* director supersedes */
		}
		if (mode & READOK) {
		    mode &= ~READOK;
		} else {
		    mode |= READOK;
		}
		break;

	    case 'w': 				/* toggle write */
		if (mode & DRCTOK) {
		    break;			/* director supersedes */
		}
		if (mode & WRITOK) {
		    mode &= ~WRITOK;
		} else {
		    mode |= WRITOK|RESPOK;
		}
		break;

	    case 'd': 				/* toggle director */
		if (mode & DRCTOK) {
		    mode &= ~DRCTOK;
		} else {
		    mode |= DRCTOK|READOK|WRITOK|RESPOK;
		}
		break;

	    case 'n': 				/* set to null */
		mode = 0;
		break;

	    case '\n':				/* acceptable to him, return */
	    case 'q': 
		return(*zmode = mode);		/* do both ways */

	    default: 
		putstr("\07  (d,r,w,a,n,q,<cr>)");
		goto again;
	}
	putch(c);
    }
}

static void
plotit (base, io)					/* plot the list */
    int base;
    struct io_f *io;
{
    register int atrow, length, atcol, i;
    acl_t *aclp;
    ace_t *acep;
    acl_h aclh;

    atrow = 1;
    atcol = 1;
    length = nrows - 6;					/* maximum in a col */

    aclp = acl_open(io);

    for (i=0, aclh=acl_first(aclp);
	 aclh != ACL_NOHANDLE && i - base < 2 * length;
	 i++, aclh=acl_next(aclp, aclh)		       ) {

	acep = acl_ace(aclp, aclh);

	at(atrow++, atcol);
	printf("%2d %s%-*s %s", i + 1,
	        kmap[acep->ptype], 16,	/* 16 to fit two columns in */
		acep->name, map[acep->perms]);
	if (atrow > length) {
	    atrow = 1;
	    atcol += 40;
	}
    }
}
