/* $Header: /g1/users/staff/gore/exp/notes/src/RCS/adnote.c,v 2.0 89/04/15 23:42:56 gore Exp $ */

#include "parms.h"
#include "structs.h"
#include "header.h"

/*
 *	addnote(io, fid, pstr)
 *	get a note from the terminal and store it in notefile specified by
 *	io. If fid >=0, then prepend text of that file (as positioned) in the
 *	scratch file so the new writer can include it in his note.
 *	Returns:	-1 if no write (empty note, no permissions)
 *			 else the notes number in the notefile.
 */
addnote(io, preface, pstr, tpstr)
struct io_f *io;
FILE *preface;
char *pstr;						/* edit pstr */
char *tpstr;					/* title pstr */
{
	struct note_f note;
	int anon;
	int retcode;
	struct hbuf h;

	if (allow(io, WRITOK) == 0) {			/* check writability */
		warn("You are not allowed to write in %s", io->nf);
		wfchar();
		return(-1);
	}
	prompt(pstr);
	if (gettext(io, &note.n_msg.m_addr, preface) == 0)
		return(-1);
	note.n_stat = 0;
	if (allow(io, DRCTOK)) {			/* director mesg */
		prompt("Director message? ");
		if (askyn() == 'y')
			note.n_stat |= DIRMES;
	}
	anon = 'n';
	if (io->descr.d_stat & ANONOK) {
		/* anon only if permitted and wants */
		prompt("Do you wish this to be anonymous? ");
		anon = askyn();
	}

	while (1) {				/* force him to type a title */
		prompt(tpstr);
		if (gline(note.n_title, TITLEN) == 0)
			continue;
		break;
	}

	/* have done title, stat */
	genhdr(io, &h, anon == 'y');
	if (is_moderated(io))
	  {
	    char buf[512];
	    warn("This notesfile is moderated and may not be posted to directly.");
	    retcode = mailit (io, &note, &note.n_msg, MODERATOR, 0);
	    if (retcode < 0) {
	      warn("Could not mail to moderator.");
	      wfchar();
	    }
	  }
	else
	  {
	    lock(io, 'n');
	    puthdr(io, &note.n_msg, &h);
	    retcode = putnote(io, &note, NOPOLICY, ADDTIME);
	    unlock(io, 'n');
	    
	    if (retcode < 0) {
	      warn("Your note was lost in a compression, probably due to archiving going on");
	      wfchar();
	    }
	  }
	return(retcode);
}

/*
 *	addresp(io, fid, notenum)
 *		grab text from the terminal, with the appropriate
 *	prepending from fid, and stick it in the notefile as a response
 *	to notenumber notenum. OF course the policy note can't have
 *	responses so we check that.
 */
addresp(io, preface, notenum)
struct io_f *io;
FILE *preface;
{
	int anon;
	int c;
	int ret;
	struct note_f note;
	struct msg_f msg;
	struct hbuf h;
	char buf[BUFLEN];

	ret = 0;
	if (allow(io, RESPOK) == 0) {			/* check writability */
		warn("You are not allowed to write in %s", io->nf);
		wfchar();
		return(-1);
	}
	prompt("Edit Response Text:");
	if (gettext(io, &msg.m_addr, preface) == 0)
		return(-1);
	anon = 'n';
	if (io->descr.d_stat & ANONOK) {
		prompt("Do you wish this response to be anonymous? ");
		anon = askyn();
	}
	msg.m_stat = 0;
	if (allow(io, DRCTOK))	{		/* director mesg */
		prompt("Director message? ");
		c = askyn();
		if (c == 'y')
			msg.m_stat |= DIRMES;
	}
	genhdr(io, &h, anon == 'y');
	getnrec(io, notenum, &note);
	gethdr(io, &note.n_msg, note.n_msg.m_artid, buf);
	strcpy(h.followid, buf);
	lock(io, 'n');
	puthdr(io, &msg, &h);
	ret = putresp(io, notenum, &note, &msg, ADDTIME);
	unlock(io, 'n');
	if (ret == 0) {
		warn("Sorry, the base note has just been deleted, response lost");
		wfchar();
	}
	return(ret);
}
