/* $Header: archiver.c,v 1.8 87/11/06 15:38:57 notes Exp $ */

#include "parms.h"
#include "structs.h"
#include <sys/stat.h>
#include <time.h>

/*
 *	archiver - archives a notesfile. Takes all articles older
 *	than 'daysold' days and places them, in generic format, in
 *	a sub-directory in the archive directory. The files are marked
 *	by the time that they were created. 
 *	The deleteonly parameter is normally zero. If it is non-zero,
 *	no archive is taken; the old notes are merely thrown away.
 *
 *	Ray Essick			March 1982
 *
 *	modified so that could also toggle on the director message.
 *	in addition to the days untouched.
 *				Ray Essick	June 1982
 */

archiver(nfname, daysold, deleteonly, dirmsgflag)
char   *nfname;
{
    struct io_f io;
    time_t zaptime;				/* boundary time */
    struct tm *tm;
    struct note_f   note;
    int archfid, i, ncount;
    char line[CMDLEN];
    char archfile[WDLEN];
    long current;
    struct stat buf;
    FILE *farchfile;
    int nnotes, nresps;

    if (init(&io, nfname) < 0)
	return(-1);					/* no notesfile */

    if ((allow(&io, DRCTOK) == 0) && (globuid != notesuid)) {
	closenf (&io);
	printf ("You are not allowed to archive the %s notesfile\n", io.nf);
	return(-1);
    }

    time(&zaptime);					/* make the old time */
    tm = localtime(&zaptime);
    sprintf(archfile, "%02d.%02d.%02d:%02d%02d", tm->tm_year,
	    tm->tm_mon+1, tm->tm_mday, tm->tm_hour, tm->tm_min);

    zaptime -= (long)daysold * DAYSECS;

    if (deleteonly == 0) {

	if (access(archdir, 0) < 0) {
	    printf("archiver: no archive directory");
	    exit(BAD);
	}
	sprintf(line, "%s/%s", archdir, nfname);
	if (access(line, 0) < 0) {
#ifdef BSD4_2
	    x(mkdir(line, 0777) < 0, "mknf: can't make directory \"%s\"",
	    archdir, nfname);
#else
	    dosystem("/bin/mkdir", line, NOSTR);
#endif BSD4_2
	    log("archiver: created directory %s", line);
	}

	sprintf(line, "%s/%s/%s", archdir, nfname, archfile);
	if ((archfid = open(line, 0)) >= 0) {
	    printf("Archive of %s too recent, try again in a minute\n",nfname);
	    close(archfid);
	    return(-1);					/* did not archive */
	}
	x ((farchfile = fopen(line, "w")) == NULL,
	    "archiver: can't create \"%s\"", line);
    }

    lock(&io, 'n');				/* would be a good idea */

    if (group_timeout > 0)
    {
        /* delete inactive groups - RLS 1/8/83 */
        sprintf(line, "%s/%s/%s", spooldir, mapnfname(nfname), TEXT);
        stat(line, &buf);
        current = time(0);
        if (current - buf.st_mtime > DAYSECS*group_timeout &&
	    buf.st_size == 4) {	/* Empty TEXT files are four bytes long. */

	    unlock(&io, 'n');
	    finish(&io);

	    sprintf(line, "%s/rmnf", libdir);
	    dosystem(line, "-f", nfname, NOSTR);

	    /* message in nfmaint */
	    sprintf(line, "Archiver: removed old notesfile %s\n", nfname);
            nfcomment(NOSUCHWARN, line, line, 0, 0);

	    log("Archiver: deleted old notesfile %s", nfname);
	    return(0);
        }
    }

    /*
     * 	this open races with above check - can archive twice! 
     */
    getdscr(&io, &io.descr);
    ncount = 0;				/* count of notes archived */
    for (i = 1; i <= io.descr.d_nnote; i++) {
	getnrec(&io, i, &note);
	if (note.n_stat & DELETED) {
	    continue;			/* never archive deleted notes */
	}
	if (dirmsgflag == DIROFF && (note.n_stat & DIRMES)) {
	    continue;					/* don't if dir on */
	}
	if (dirmsgflag == DIRON && (note.n_stat & DIRMES) == 0) {
	    continue;					/* don't if dir off */
	}
	if (zaptime < note.n_lmod)
	    continue;
	if (deleteonly == 0) {
	    dmpnote(&io, &note, i, farchfile, NODETAIL);
							/* save base note */
	    dmprall(&io, &note, i, farchfile, NODETAIL);
							/* save resps */
	}
	delnote(&io, i, NOLOCKIT);			/* delete entry */
	ncount++;
    }

    if (deleteonly == 0)
    	x (fclose (farchfile) < 0,
	    "archiver: failed to close archive \"%s/%s\"", 
	    archdir, mapnfname (nfname));

    if (compress(&io, NOLOCKIT, &nnotes, &nresps) >= 0)
	printf("%s: %d notes and %d responses after compression.\n",
		nfname, nnotes, nresps);
    else
	printf("%s: notesfile already compressed\n", nfname);

    unlock(&io, 'n');				/* all done with this */
    finish(&io);				/* and close the notesfile */

    if (ncount) {				/* log only if did somethine */
	if (deleteonly == 0)
	    log("%s: archived %d notes into %s", nfname, ncount, archfile);
	else
	    log("%s: archiver deleted %d notes", nfname, ncount);
    }

    if (deleteonly == 0) {
	printf("Archived: %s: %d notes into file %s\n",
		nfname, ncount, archfile);
    } else {
	printf("Archiver deleted from %s %d notes\n", nfname, ncount);
    }
    return(0);						/* and return */
}
