/* $Header: /g1/users/staff/gore/exp/notes/src/RCS/control.c,v 1.1 89/01/27 12:51:43 gore Exp $ */

/*
 *	Code in this module ( control.c) is designed to process
 *	a single notefile. Its paramters include the name of
 *	the notefile to process and whether to use the sequencer.
 */

#include "parms.h"
#include "structs.h"

control(nfname, seqon, wdate, sequencer)
	char *nfname;
	int seqon;
	time_t wdate;
	char *sequencer;	/* name of sequencer file */
{
	struct io_f io;
	struct note_f   note;
	time_t entered;		/* entry into notefile package */

	int	ret;
	int     firstdis, lastdis;	/* display counters */
	int     readnum;		/* where to start reading notes */
	int     respnum;		/* response to be on */
	/* currently 0 always */

	terse = (seqon & TERSE) != 0;
	seqon &= ~TERSE;
	if (seqon == NOSEQ)
		wdate = 0;	/* conservative */
	/* extra test to avoid opening files */
	if (wdate && (seqon == NORMSEQ || seqon == INDXSEQ)) {
		if (nfmod_before(nfname, wdate))
			return(-1);
	}
	time(&entered);		/* get the entry time */
	if ((ret = init(&io, nfname)) < 0)
		return(ret);
	if (allow(&io, READOK) == 0) {
		/* if sequencing, just skip the thing */
		if (seqon == NOSEQ) {
			printf("You aren't allowed to read %s\n", nfname);
			if (io.descr.d_plcy) {
				prompt("Do you wish to see the policy note? ");
				if (askyn() == 'y') {
					/* show the policy */
					getnrec(&io, 0, &note);
					dspmsg(&io, &note, &note.n_msg, 0, 0);
				}
			}
			if (allow(&io, WRITOK)) {
			    printf("You may leave a note in the notefile\n");
			    prompt("Do you wish to leave a note? ");
			    if (askyn() == 'y') {
				addnote(&io, (FILE *)0,
					"Edit Note Text:", "Note title: ");
				printf("Your note has been registered\n");
			    }
			} else
			    wfchar();
		}
		finish(&io);
		return(-1);
	}

	if ((io.descr.d_stat & OPEN) == 0 && !allow (&io, DRCTOK)) {
		finish(&io);
		return(QUITBAD);
	}
	/*
	 * if sequencer is off, stime is jan 1 1970,
	 * so will enter notefile
	 */
	io.stime = wdate;
	if (io.descr.d_lastm < io.stime &&
	    (seqon == NORMSEQ || seqon == INDXSEQ)) {
		/*
		 * text file was modified, but there are
		 * no new notes (probably because the compactor
		 * was run).  Update sequencer information.
		 * This will allow stat's to work more reliably.
		 */
		updseq(nfname, entered);
		if (saveseq(sequencer))
		  {
		    prompt("Writing sequencer...");
		    fflush(stdout);
		  }
		finish(&io);
		return(-1);
	}
	if (seqon != NOSEQ) {
		firstdis = nxtnote(&io, 0, io.stime);
		if (firstdis > 0 && (seqon == NORMSEQ || seqon == EXTSEQ)) {
			readnum = firstdis;
			respnum = nxtmsg(&io, readnum, -1, io.stime);
			goto seqenter;
		}
	} else
		firstdis = io.descr.d_nnote - nindex + 1;
	respnum = 0;
	while (1) {
		readnum = mstindex(&io, &firstdis, &lastdis, &respnum);
		if (readnum < -1)
			break;
seqenter:
		/* if sequencer is on, we start here */
		readnum = readem(&io, readnum, &firstdis, respnum);
		if (readnum < -1)
			break;
	}
	if (seqon && (readnum == QUITSEQ || readnum == QUITUPD))
		{
		updseq(nfname, entered);
		if (saveseq(sequencer))
		  {
		    prompt("Writing sequencer...");
		    fflush(stdout);
		  }
		}
	finish(&io);
	return(readnum);	/* return the termination flag */
}
