/* $Header: /g1/users/staff/gore/exp/notes/src/lib/RCS/dumpmsg.c,v 2.0 89/04/16 00:47:16 gore Exp $ */

#include "parms.h"
#include "structs.h"
#include "dumpmsg.h"

/*
 * dump a message, including the header
 */
dumpmsg(io, note, msgp, rflag, dump_format, rnews)
	struct io_f *io;
	struct note_f *note;
	struct msg_f *msgp;
        int rflag;
        dumpfmt_t dump_format;
	FILE *rnews;
{
	int lines;

	switch (dump_format) {

	  case DMP_TEXT:
	    lines = 0;
	    break;

	  case DMP_NOTE:
	    return preptxt(io, rnews, msgp);

	  case DMP_MAIL_MMDF:
	    fprintf(rnews, "\001\001\001\001\n");
	    lines = 2 + dumphdr(io, note, msgp, rflag, 0, rnews);
	    putc('\n', rnews);
	    break;

	  case DMP_MAIL_V7:
	    /*
	     * Defer "From " inclusion to dumphdr, since it will
	     * know the From: address.
	     */
	    lines = 1 + dumphdr(io, note, msgp, rflag, 1, rnews);
	    putc('\n', rnews);
	    break;

	  case DMP_HEADED:
	    lines = 1 + dumphdr(io, note, msgp, rflag, 0, rnews);
	    putc('\n', rnews);
	    break;

	  default:
	    x(1, "dumpmsg: unrecognized dump format: %d\n", dump_format);
	}

	lines += pageout(io, &msgp->m_addr, rnews);	/* dump text */

	switch (dump_format) {

	  case DMP_TEXT:
	  case DMP_NOTE:
	  case DMP_MAIL_V7:
	  case DMP_HEADED:
	    break;

	  case DMP_MAIL_MMDF:
	    fprintf(rnews, "\001\001\001\001\n");
	    ++lines;
	    break;

	  default:
	    x(1, "dumpmsg: unrecognized dump format: %d\n", dump_format);
	}

	return(lines);
}

/*
 * dump the header of a message
 */
dumphdr(io, note, msgp, rflag, fromflag, rnews)
	struct io_f *io;
	struct note_f *note;
	struct msg_f *msgp;
	FILE *rnews;
{
	register int c;
	register int nleft;
	char *buf;
	char version[BUFLEN];
	struct txthead_f txthead;
	int lines = 0;
	extern char *arpadate();

	gethrec(io, &msgp->m_head, &txthead);		/* get header */

	/* Used to have a fixed size buffer, but I don't trust headers */
	/* to stay under 1024 bytes.  Malloc as much space as we need. */
	x((buf=malloc(msgp->m_misc))==NULL,
	  "dumphdr: malloc failed, size= %d", msgp->m_misc);

	nleft = txthead.textlen;
	fread(buf, 1, msgp->m_misc, io->fidtxt);
	nleft -= msgp->m_misc;

	if (fromflag) {		/* print Unix mail header line */
	    struct auth_f *ap, *parseauth();
	    char destaddr[512];
	    
	    ap = parseauth(buf + msgp->m_from);
	    if (strcmp(ap->a_name, ANONYMOUS) == 0) {
		warn("Can't send to %s", ANONYMOUS);
		return(-1);
	    }
	    if (*ap->a_sys && strcmp(full_hostname, ap->a_sys) != 0) {
		sprintf(destaddr, "%s@%s", ap->a_name, ap->a_sys);
	    } else {
		strcpy(destaddr, ap->a_name);
	    }
	    
	    fprintf(rnews, "From %s %s", destaddr, ctime(&msgp->m_subtime));
	    lines = 1;
	}

	fprintf(rnews, "From: %s\n", buf + msgp->m_from);
	fprintf(rnews, "Date: %s\n", arpadate(&msgp->m_subtime));
	fprintf(rnews, "Date-Received: %s\n", arpadate(&msgp->m_rcvtime));
	if (rflag) {
	    fprintf(rnews, "Subject: Re: %s\n", note->n_title);
	} else {
	    fprintf(rnews, "Subject: %s\n", note->n_title);
	}
	fprintf(rnews, "Message-ID: %s\n", buf + msgp->m_artid);
	if (strlen(buf + msgp->m_org) != 0) {
	    /* Print only if something there */
	    fprintf(rnews, "Organization: %s\n", buf + msgp->m_org);
	    lines ++;
	}
	if (prefix(buf + msgp->m_path, hostname_in_path)) {
	    fprintf(rnews, "Path: %s\n", buf + msgp->m_path);
	} else {
	    fprintf(rnews, "Path: %s!%s\n", hostname_in_path,
		    buf + msgp->m_path);
	}
#ifdef notdef
	if(strlen(buf + msgp->m_ctlmsg) != 0) {
	    fprintf(rnews, "Control: %s\n", buf + msgp->m_ctlmsg);
	    lines ++;
	}
#endif notdef
	fprintf(rnews, "Newsgroups: %s\n", buf + msgp->m_ngroup);
	lines += 6;		/* always generate this many lines */

#ifdef HPVERSION
	/*
	 * News code assumes that groups matching "all.all.announce" are
	 * moderated and will reject articles for those groups that do
	 * not have an "Approved:" header line.  "hp.announce" has been
	 * on HP notes for a few years already and does not need a name
	 * change or a moderator.
	 *
	 *   I hearby approve all articles current and future for
	 *   posting in hp.announce.   Walter Underwood 6/12/86
	 */
	if (strcmp(io->nf, "hp.announce") == 0)
	  {
	    fprintf(rnews, "Approved: wunder@hplabs\n");
	    lines++;
	  }
#endif /* HPVERSION */

	free(buf);

	/* dump of rest of header lines */
	while (nleft-- > 0) {
		c = getc(io->fidtxt);
		if (c == '\n')
			lines++;
		putc(c, rnews);
	}
	return(lines);
}

dumpfmt_t dump_format(str)
    char *str;
{
    if (strcasecmp(str, STR_HEADED   ) == 0) return DMP_HEADED;
    if (strcasecmp(str, STR_NOTE     ) == 0) return DMP_NOTE;
    if (strcasecmp(str, STR_TEXT     ) == 0) return DMP_TEXT;
    if (strcasecmp(str, STR_MAIL_V7  ) == 0) return DMP_MAIL_V7;
    if (strcasecmp(str, STR_MAIL_MMDF) == 0) return DMP_MAIL_MMDF;
    return DMP_INVALID;
}
