/* $Header: find.c,v 1.6 87/08/25 15:30:21 notes Exp $ */

#include "parms.h"
#include "structs.h"

/*
 *	chknote(io, noteid, note)
 *	see if a copy of the note specified by noteid is in the notefile
 *	returns the number of the note (0 if no note)
 *	NOTE: this routine is rather inefficient - since it 
 *	will go through the entire file to discover that the note is
 *	not in the notefile... This should be done over so that the
 *	access is run somewhat better/faster..
 *
 *	Original Coding:	Ray Essick	December 1981
 */

char *index();

chknote(io, noteid, note)
struct io_f *io;
char *noteid;
struct note_f  *note;
{
    int i;
    char hline[BUFLEN];
    char hline2[BUFSIZ];
    char cleanid[IDSZ];
    char cleanid2[IDSZ];
    int  a_hasdomain;
    int  b_hasdomain;
    char *p;

    /*
     * Just in case we have multiple Msg-ID's on a line, let's
     * cut it down to one.
     */
    strcpy(cleanid, noteid);
    p = index(cleanid, '>');
    *++p = '\0';
    strcpy(cleanid2, noteid);
    p = index(cleanid2, '>');
    *++p = '\0';

    /*
     * make a copy of the ID without the .DOMAIN ("<id@host.DOMAIN>")
     */

    a_hasdomain = stripid(cleanid2);

    for (i = 1; i <= io->descr.d_nnote; i++) {
	getnrec(io, i, note);
	gethdr(io, &note->n_msg, note->n_msg.m_artid, hline);

	strcpy(hline2, hline);
	b_hasdomain = stripid(hline2);

	/* only include the domain in the compare if BOTH have domains */
	if ((a_hasdomain == 1) && (b_hasdomain == 1)) {
		if (strcmp(cleanid, hline) == 0) /* compare with domains */
		  return i;	/* return note number */
	} else {
		if (strcmp(cleanid2, hline2) == 0) /* compare without domains */
		  return i;
	}
    }
    return(0);						/* not found */
}

/*
 *	chkresp(io, respid, note, notenum)
 *	check the specified response to see if a response exists with
 *	the specified unique identifier
 *
 *	This too can be speeded up similarly to the chknote routine..
 *	but we shall worry about it later..after it already works.
 *
 *	Original Coding:	Ray Essick	December 1981
 */

chkresp(io, respid, note, notenum)
struct io_f *io;
char *respid;
struct note_f *note;
{
    struct resp_f rrec;
    int roffset, rrecnum;
    int i;
    char artid[BUFLEN];
    char artid2[BUFLEN];
    struct msg_f *msgp;
    char cleanid[IDSZ];
    char cleanid2[IDSZ];
    int  a_hasdomain;
    int  b_hasdomain;
    char *p;

    /*
     * Just in case we have multiple Msg-ID's on a line, let's
     * cut it down to one.
     */
    strcpy(cleanid, respid);
    p = index(cleanid, '>');
    *++p = '\0';
    strcpy(cleanid2, respid);
    p = index(cleanid2, '>');
    *++p = '\0';

    /*
     * make a copy of the ID without the .DOMAIN
     */

    a_hasdomain = stripid(cleanid2);

    for (i = 1; i <= note->n_nresp; i++) {
	if (lrsp(io, notenum, i, &rrec, &roffset, &rrecnum) == -1) {
	    continue;			/* no response */
	}
	msgp = &rrec.r_msg[roffset];
	gethdr(io, msgp, msgp->m_artid, artid);

	strcpy(artid2, artid);
	b_hasdomain = stripid(artid2);

	/* only include the domain in the compare if BOTH have domains */
	if ((a_hasdomain == 1) && (b_hasdomain == 1)) {
		if (strcmp(cleanid, artid) == 0) /* compare with domains */
		  return i;	/* return the response number */
	} else {
		if (strcmp(cleanid2, artid2) == 0) /* compare without domains */
		  return i;
	}
    }
    return(0);				/* is not a response to this note */
}


#define FULLREFS
#ifdef FULLREFS
/*
 * Experimental stuff to check entire reference line.
 */

#define MAXREFS 40

#ifdef MSGID_INDEX

#define MAKE_DATUM(d,str)	{ \
				d.dptr = str;\
				d.dsize = strlen(str)+1;\
				}

struct number_f
chkref(io, refline, note)
     struct io_f *io;
     char *refline;
     struct note_f *note;
{
  extern int errno;
  extern char *sys_errlist[];
  DBM  *db = io->msgindexp;
  datum key;
  datum d;
  char *refs[MAXREFS];
  char *p;
  char *q;
  char *r;
  int numrefs;
  int i;
  struct number_f result;	/* Build the return value in this */

  /* First we parse the references line into an array. */
  p = refline;
  for( numrefs = 0 ; numrefs < MAXREFS ; numrefs++ )
    {
      p = index(p, '<');
      if( p == NULL )
	break;

      q = index(p+1, '>');
      if( q == NULL )
	break;				/* Truncated ID */

      refs[numrefs] = malloc((q-p)+2); /* Make room for last letter and null */
      r = &refs[numrefs][0];

      while( p != q+1 )
	*r++ = *p++;

      *r = '\0';		/* Terminate */
      
      p = q;			/* Get ready for next ID */
    }

  /* Now we check each ref against the Message-ID index. */
  for( i = 0 ; i < numrefs ; i++ )
    {
      MAKE_DATUM(key, refs[i]);
      d = dbm_fetch(db, key);
      x(dbm_error(db),
	"chkref: IO error from dbm_fetch, errno= %d (\"%s\"), key= \"%s\"",
	errno, sys_errlist[errno], key.dptr);

      if( d.dptr != NULL )	/* key hit */
	{
	  char *p;

	  /* Field looks like "4/24/86 11:29\tnet.rec.wombats/186:42" */
	  /* A tab separates the date and the notesfile name.         */
	  /* 186 is the note number and 42 is the response number.    */

	  p = rindex(d.dptr, '\t');	/* Skip over date */
	  p = index(p, '/');		/* Skip over notesfile name */
	  p++;				/* Skip over the slash */

	  x(sscanf(p, "%ld:%ld", &result.note, &result.resp) != 2,
	    "chkref: can't parse msg-ID record key= \"%s\", value= \"%s\"",
	    key.dptr, d.dptr);

	  goto cleanup;
	}
      /* Key miss, try another */
    }

  /* Didn't find any matches */
  result.note = -1;

 cleanup:

  for( i = 0 ; i < numrefs ; i++ )
    free(refs[i]);
  
  return result;
}



#else /* MSGID_INDEX */

struct number_f
chkref(io, refline, note)    /* THIS VERSION DOES NOT WORK */
struct io_f *io;
char *refline;
struct note_f  *note;
{
    int i,j;
    char artid[BUFLEN];
    char *refs[MAXREFS];
    char *p;
    char *q;
    char *r;
    struct resp_f rrec;
    struct msg_f  *msgp;
    int roffset, rrecnum;
    int numrefs;
    struct number_f result;

    /* copy references into the array */
    
    p = refline;
    for( numrefs = 0 ; numrefs < MAXREFS ; numrefs++ )
      {
	p = index(p, '<');
	if( p == NULL )
	  break;
	
	q = index(p+1, '>');
	if( q == NULL )
	  break;		/* Truncated ID */

	refs[numrefs] = malloc((q-p)+2); /* room for last letter and null */
	r = &refs[numrefs][0];
	
	while( p != q+1 )
	  *r++ = *p++;
	
	*r = '\0';		/* Terminate */
      
	p = q;			/* Get ready for next ID */
      }

    /*
     * Search the notesfile, starting at the last notes string.
     *   Starting at the end is a real speedup for notesfiles with
     *   10,000 articles (like Donn's).
     * Do not check against note 0, so that we don't tack responses
     *   on the Policy Note.
     */

    for (i = io->descr.d_nnote ; i > 0 ; i--) {
	getnrec(io, i, note);
	gethdr(io, &note->n_msg, note->n_msg.m_artid, artid);
	if (refequal(refs, numrefs, artid)) {
	    result.note = i;
	    result.resp = 0;
	    return result;	/* return note number */
	}

        for (j = 1; j <= note->n_nresp; j++) {
	    if (lrsp(io, i, j, &rrec, &roffset, &rrecnum) == -1)
	        continue;			/* no response */
	    msgp = &rrec.r_msg[roffset];
	    gethdr(io, msgp, msgp->m_artid, artid);
	    if (refequal(refs, numrefs, artid)) {
	        result.note = i;
		result.resp = j;
	        return result;	/* return the response number */
	    }
	}
    }
    result.note = -1;
    return result;		/* not found */
}

#endif /* MSGID_INDEX */

refequal(refs, num, id)
     char *refs[];
     char *id;
{
  int i;

  for( i = 0 ; i < num ; i++ )
      if (strcmp(refs[i], id) == 0)
	return 1;
  return 0;
}
#endif /* FULLREFS */
